/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ElementData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ClassID myClassId = null;
    private HashMap<ParameterCodes, Object> parametersList = new HashMap();

    public ElementData(CommKey key, ClassID classId) {
        if (key != null) {
            this.parametersList.put(ParameterCode.ELEMENT_ID, new CommKeyClassId(key, classId));
        }
        this.myClassId = classId;
    }

    public ElementData() {
    }

    public ElementData(CommKeyClassId data) {
        this(data.getCommKeys(), data.getClassID());
    }

    public ElementData(ElementData element) {
        this(element.getCommKey(), element.getClassId());
        this.addParameter(element.getParametersList());
    }

    public ElementData(CommKey[] aKeys, ClassID aClassId) {
        if (aKeys != null) {
            this.validateCommKeys(aKeys);
            this.parametersList.put(ParameterCode.ELEMENT_ID, new CommKeyClassId(aKeys, aClassId));
        }
        this.myClassId = aClassId;
    }

    public ElementData(CommKey[] key, ClassID classId, HashMap<ParameterCodes, Object> parameters) {
        this(key, classId);
        this.parametersList.putAll(parameters);
    }

    public ElementData(CommKey key, ClassID classId, HashMap<ParameterCodes, Object> parameters) {
        this(key, classId);
        this.parametersList.putAll(parameters);
    }

    public ElementData(ClassID classId) {
        this.myClassId = classId;
    }

    public void setCommKey(CommKey aKey) {
        if (aKey != null) {
            this.parametersList.put(ParameterCode.ELEMENT_ID, new CommKeyClassId(aKey, this.myClassId));
        } else {
            this.parametersList.remove(ParameterCode.ELEMENT_ID);
        }
    }

    public Set<ParameterCodes> keySet() {
        HashSet<ParameterCodes> keys = new HashSet<ParameterCodes>(this.parametersList.keySet());
        ElementData.removeHiddenParameters(keys);
        return keys;
    }

    public Set<ParameterCodes> hiddenKeySet() {
        return new HashSet<ParameterCodes>(this.parametersList.keySet());
    }

    protected void put(ParameterCodes key, Object value) {
        this.parametersList.put(key, value);
    }

    public void setCommKeys(CommKey[] aKeys) {
        if (aKeys != null) {
            this.validateCommKeys(aKeys);
            this.parametersList.put(ParameterCode.ELEMENT_ID, new CommKeyClassId(aKeys, this.myClassId));
        } else {
            this.parametersList.remove(ParameterCode.ELEMENT_ID);
        }
    }

    public void setCommKeyClassId(CommKeyClassId data) {
        this.myClassId = data.getClassID();
        this.setCommKeys(data.getCommKeys());
    }

    public CommKey[] getCommKey() {
        CommKeyClassId id = this.getCommKeyClassId();
        if (id != null) {
            return id.getCommKeys();
        }
        return null;
    }

    public void setClassId(ClassID aClassId) {
        this.myClassId = aClassId;
        CommKeyClassId id = this.getCommKeyClassId();
        if (id != null) {
            this.parametersList.put(ParameterCode.ELEMENT_ID, new CommKeyClassId(id.getCommKeys(), aClassId));
        }
    }

    public ClassID getClassId() {
        return this.myClassId;
    }

    public boolean compareCommKey(ElementData aOther) {
        HashSet<CommKey> otherSet;
        CommKey[] objKeys = aOther.getCommKey();
        CommKey[] keys = this.getCommKey();
        HashSet<CommKey> keySet = keys != null ? new HashSet<CommKey>(Arrays.asList(keys)) : null;
        HashSet<CommKey> hashSet = otherSet = objKeys != null ? new HashSet<CommKey>(Arrays.asList(objKeys)) : null;
        if (keySet != null && keySet.size() != keys.length) {
            throw new IllegalStateException("Illegal Keys: " + this);
        }
        if (otherSet != null && otherSet.size() != objKeys.length) {
            throw new IllegalStateException("Illegal Keys: " + aOther);
        }
        return Util.equalsWithNull(keySet, otherSet);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElementData) {
            ElementData elem = (ElementData)obj;
            return this.myClassId.equals(elem.getClassId()) && this.compareCommKey(elem) && this.getParametersList().equals(elem.getParametersList());
        }
        return false;
    }

    public SnmpCommKey getSnmpKey() {
        if (this.getCommKey() == null) {
            return null;
        }
        return this.getCommKeyClassId().getSnmpCommKey();
    }

    public DataBaseCommKey getDbKey() {
        return this.getCommKeyClassId().getDBCommKey();
    }

    public Object clone() {
        ElementData newElement = new ElementData(this.getCommKey(), this.getClassId(), this.getParametersList());
        return newElement;
    }

    public void addParameter(HashMap<ParameterCodes, Object> params) {
        for (ParameterCode parameterCode : params.keySet()) {
            Object value = params.get(parameterCode);
            if (value == null) {
                if (this.parametersList.containsKey(parameterCode)) continue;
                this.parametersList.put(parameterCode, value);
                continue;
            }
            this.parametersList.put(parameterCode, value);
        }
    }

    public HashMap<ParameterCodes, Object> getParametersList() {
        HashMap<ParameterCodes, Object> params = new HashMap<ParameterCodes, Object>(this.parametersList);
        ElementData.removeHiddenParameters(params);
        return params;
    }

    public <T> T getValue(ParameterCodes code) {
        return (T)this.parametersList.get(code);
    }

    public Object removeValue(ParameterCodes code) {
        if (code.equals(ParameterCode.ELEMENT_ID)) {
            return null;
        }
        return this.parametersList.remove(code);
    }

    public void setValue(ParameterCode code, SrType value) {
        this.parametersList.put(code, value);
    }

    public void setValue(ParameterCode code, ElementData value) {
        this.parametersList.put(code, value);
    }

    public void setValue(ParameterCode code, ConfigElementDataList value) {
        this.parametersList.put(code, value);
    }

    public void setValues(ParameterCode code, SrType[] values) {
        this.parametersList.put(code, values);
    }

    public Object removeParameter(ParameterCode code) {
        if (code.equals(ParameterCode.ELEMENT_ID)) {
            return null;
        }
        return this.parametersList.remove(code);
    }

    public void removeAll() {
        Object vsIDs = this.parametersList.get(ParameterCode.VSWITCH_ID);
        Object id = this.parametersList.get(ParameterCode.ELEMENT_ID);
        this.parametersList.clear();
        this.parametersList.put(ParameterCode.VSWITCH_ID, vsIDs);
        if (id != null) {
            this.parametersList.put(ParameterCode.ELEMENT_ID, id);
        }
    }

    public boolean containsParameter(ParameterCode code) {
        return this.parametersList.containsKey(code);
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer("Element [");
        if (this.getCommKey() != null) {
            retVal.append(this.getCommKeyClassId());
        } else {
            retVal.append(this.getClassId().toString());
        }
        retVal.append(", Parameters: ");
        retVal.append(this.parametersList);
        retVal.append("]");
        return retVal.toString();
    }

    public CommKeyClassId getCommKeyClassId() {
        Object ckid = this.parametersList.get(ParameterCode.ELEMENT_ID);
        if (ckid instanceof CommKeyClassId) {
            return new CommKeyClassId((CommKeyClassId)ckid);
        }
        return null;
    }

    private void validateCommKeys(CommKey[] aKeys) {
        if (aKeys != null) {
            for (int i = 0; i < aKeys.length; ++i) {
                if (aKeys[i] != null) continue;
                throw new IllegalArgumentException("CommKey is null");
            }
        }
    }

    public void addParameterToElement(ElementData src, ParameterCode code) {
        this.addParameterToElement(src, code, code);
    }

    public void addParameterToElement(ElementData src, ParameterCode srcCode, ParameterCode destCode) {
        Object value = src.getValue(srcCode);
        if (src.getValue(srcCode) instanceof ElementData) {
            this.setValue(destCode, (ElementData)value);
            return;
        }
        if (src.getValue(srcCode) instanceof ConfigElementDataList) {
            this.setValue(destCode, (ConfigElementDataList)value);
            return;
        }
        if (value != null) {
            this.setValue(destCode, (SrType)value);
        }
    }

    public boolean isCreated() {
        return this.getCommKey() != null;
    }

    public ElementData getFirstChild() {
        for (ParameterCode parameterCode : this.parametersList.keySet()) {
            if (this.parametersList.get(parameterCode) instanceof ElementData) {
                return (ElementData)this.parametersList.get(parameterCode);
            }
            if (!(this.parametersList.get(parameterCode) instanceof ConfigElementDataList)) continue;
            return ((ConfigElementDataList)this.parametersList.get(parameterCode)).getElementDataAt(0);
        }
        return null;
    }

    public CommKeyClassId getVswitchId() {
        CommKeyClassId[] ids = this.getVswitchIds();
        if (ids != null) {
            return ids[0];
        }
        return null;
    }

    public CommKeyClassId[] getVswitchIds() {
        Object data = this.parametersList.get(ParameterCode.VSWITCH_ID);
        if (data instanceof CommKeyClassId) {
            return new CommKeyClassId[]{(CommKeyClassId)data};
        }
        if (data instanceof Object[]) {
            Object[] dataArray = (Object[])data;
            ArrayList<CommKeyClassId> idList = new ArrayList<CommKeyClassId>();
            for (Object obj : dataArray) {
                CommKeyClassId id;
                if (!(obj instanceof CommKeyClassId) || !ClassID.VSWITCH.equals((id = (CommKeyClassId)obj).getClassID())) continue;
                idList.add(id);
            }
            if (idList.isEmpty()) {
                return null;
            }
            return idList.toArray(new CommKeyClassId[idList.size()]);
        }
        return null;
    }

    private static void removeHiddenParameters(Map<ParameterCodes, Object> aMap) {
        aMap.remove(ParameterCode.ELEMENT_ID);
    }

    private static void removeHiddenParameters(Set<ParameterCodes> aSet) {
        aSet.remove(ParameterCode.ELEMENT_ID);
    }
}

