/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.types;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ElementData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ConfigElementDataList
extends ArrayList<ElementData> {
    private static final long serialVersionUID = 1L;
    private ConfigOperation myConfigOperation = ConfigOperation.NO_OPERATION;

    public ConfigElementDataList() {
        this(ConfigOperation.NO_OPERATION);
    }

    public ConfigElementDataList(ConfigOperation aConfigOperation) {
        this.setConfigOperation(aConfigOperation);
    }

    public ConfigElementDataList(Collection<ConfigElementData> aConfigElementDatas) {
        this(aConfigElementDatas, ConfigOperation.NO_OPERATION);
    }

    public ConfigElementDataList(Collection<ConfigElementData> aConfigElementDatas, ConfigOperation aConfigOperation) {
        super(aConfigElementDatas);
        this.setConfigOperation(aConfigOperation);
    }

    public ConfigElementDataList(ConfigElementData ... aConfigElementDatas) {
        this(ConfigOperation.NO_OPERATION, aConfigElementDatas);
    }

    public ConfigElementDataList(ConfigOperation aConfigOperation, ConfigElementData ... aConfigElementDatas) {
        this.addAll((Collection<? extends ElementData>)Arrays.asList(aConfigElementDatas));
        this.setConfigOperation(aConfigOperation);
    }

    public void setClassIdToAllElements(ClassID classId) {
        for (ElementData ed : this) {
            ed.setClassId(classId);
        }
    }

    public ElementData getElementDataAt(int i) {
        return (ElementData)super.get(i);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends ElementData> list) {
        for (ElementData elementData : list) {
            if (this.contains(elementData)) continue;
            this.add(elementData);
        }
        return true;
    }

    public List<CommKeyClassId> getAllCommkeyClassIDsInList() {
        ArrayList<CommKeyClassId> retVal = new ArrayList<CommKeyClassId>();
        for (ElementData ed : this) {
            retVal.add(ed.getCommKeyClassId());
        }
        return retVal;
    }

    public CommKeyClassId[] getArrayOfCommKeyClassId() {
        CommKeyClassId[] array = new CommKeyClassId[this.size()];
        int i = 0;
        for (ElementData ed : this) {
            array[i++] = ed.getCommKeyClassId();
        }
        return array;
    }

    public void removeEqualElements() {
        ConfigElementDataList temp = new ConfigElementDataList();
        for (int i = this.size() - 1; i >= 0; --i) {
            ElementData ced = (ElementData)this.get(i);
            if (!temp.isEmpty() && temp.contains(ced)) continue;
            temp.add(ced);
        }
        this.clear();
        for (int j = temp.size() - 1; j >= 0; --j) {
            if (temp.get(j) == null) continue;
            this.add((ElementData)temp.get(j));
        }
    }

    public ArrayList getValues(ParameterCode code) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ElementData ed : this) {
            if (!ed.getParametersList().containsKey(code)) continue;
            list.add(ed.getParametersList().get(code));
        }
        return list;
    }

    @Override
    public void add(int index, ElementData element) {
        this.logAndAssertNotNull(element);
        super.add(index, element);
    }

    @Override
    public synchronized boolean add(ElementData o) {
        this.logAndAssertNotNull(o);
        return super.add(o);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends ElementData> c) {
        this.logAndAssertNotNull(c.toArray());
        return super.addAll(index, c);
    }

    private void logAndAssertNotNull(Object ... aObjects) {
        for (Object o : aObjects) {
            SrLogger.getLogger().logAndAssert(SrLogCategories.ERROR, o != null, new Object[]{"Cannot add a null Object to ConfigElementDataList"});
        }
    }

    @Override
    public synchronized String toString() {
        return "ConfigElementDataList" + super.toString();
    }

    public ElementData findElementData(ElementData aCed) {
        int indexOf = this.indexOf(aCed);
        if (indexOf >= 0) {
            return (ElementData)this.get(indexOf);
        }
        for (ElementData ced : this) {
            for (ParameterCodes code : ced.hiddenKeySet()) {
                ElementData element;
                Object obj = ced.getValue(code);
                if (obj instanceof ElementData) {
                    if (!obj.equals(aCed)) continue;
                    return (ElementData)obj;
                }
                if (!(obj instanceof ConfigElementDataList) || (element = ((ConfigElementDataList)obj).findElementData(aCed)) == null) continue;
                return element;
            }
        }
        return null;
    }

    public ConfigOperation getConfigOperation() {
        return this.myConfigOperation;
    }

    private void setConfigOperation(ConfigOperation aConfigOperation) {
        this.myConfigOperation = aConfigOperation != null ? aConfigOperation : ConfigOperation.NO_OPERATION;
    }
}

