/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.table;

import com.sanrad.nms.server.util.table.MultiKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MultiKeyHashMap {
    private Class[] keyTypes = null;
    private int numberOfKeys = 0;
    private HashMap map = new HashMap();
    private Set keySet = null;

    public MultiKeyHashMap(int numberOfKeys) {
        this.numberOfKeys = numberOfKeys;
    }

    public MultiKeyHashMap(Class[] keyTypes) {
        if (keyTypes != null && keyTypes.length > 0) {
            this.keyTypes = keyTypes;
        }
    }

    public Object put(MultiKey keys, Object value) {
        if (keys == null) {
            throw new IllegalArgumentException("MultiKey parameter is null");
        }
        Object[] keysValues = keys.getKeyValues();
        if (keysValues.length == 0) {
            throw new IllegalArgumentException("MultiKey parameter is empty");
        }
        if (this.keyTypes != null) {
            if (keysValues.length != this.keyTypes.length) {
                throw new IllegalArgumentException("MultiKey size doesn't match the configured key size");
            }
            this.checkKeyTypeEnforcement(keysValues);
        }
        HashMap prevMap = this.map;
        HashMap currMap = this.map;
        for (int i = 0; i < keysValues.length - 1; ++i) {
            currMap = (HashMap)prevMap.get(keysValues[i]);
            if (currMap == null) {
                prevMap.put(keysValues[i], new HashMap());
                currMap = (HashMap)prevMap.get(keysValues[i]);
            }
            prevMap = currMap;
        }
        Object oldValue = currMap.get(keysValues[keysValues.length - 1]);
        currMap.put(keysValues[keysValues.length - 1], value);
        this.addKey(keys);
        return oldValue;
    }

    public void remove(MultiKey key) {
        Object[] keyValues = key.getKeyValues();
        this.checkKeyTypeEnforcement(keyValues);
        if (this.keySet.remove(key)) {
            this.removeKeyFromMap(this.map, keyValues, 0);
        }
    }

    private void removeKeyFromMap(HashMap map, Object[] keyValues, int recursionLevel) {
        if (recursionLevel < keyValues.length - 1) {
            HashMap nextMap = (HashMap)map.get(keyValues[recursionLevel]);
            if (nextMap != null) {
                this.removeKeyFromMap(nextMap, keyValues, recursionLevel + 1);
                if (nextMap.isEmpty()) {
                    map.remove(keyValues[recursionLevel]);
                }
            }
        } else {
            map.remove(keyValues[recursionLevel]);
        }
    }

    public Object[] get(MultiKey keys) {
        ArrayList tempList = new ArrayList();
        if (keys == null) {
            return null;
        }
        tempList = this.getValues(this.map, keys);
        if (tempList == null) {
            return null;
        }
        return tempList.toArray();
    }

    public Set keySet() {
        return this.keySet;
    }

    protected void addKey(MultiKey key) {
        if (this.keySet == null) {
            this.keySet = new HashSet();
        }
        this.keySet.add(key);
    }

    protected MultiKey getKeyToAll() {
        int numOfKeys = this.numberOfKeys != 0 ? this.numberOfKeys : this.keyTypes.length;
        Object[] AllKeys = new Object[numOfKeys];
        for (int i = 0; i < numOfKeys; ++i) {
            AllKeys[i] = null;
        }
        return new MultiKey(AllKeys);
    }

    private ArrayList getValues(HashMap map, MultiKey partialKey) {
        ArrayList valuesList = new ArrayList();
        Object[] keyValues = partialKey.getKeyValues();
        if (keyValues[0] == null) {
            for (Object currParam : map.keySet()) {
                Object currValue = map.get(currParam);
                if (currValue == null) continue;
                if (currValue instanceof HashMap) {
                    if (keyValues.length == 1) {
                        Object value = ((HashMap)currValue).get(keyValues[0]);
                        valuesList.add(value);
                        continue;
                    }
                    valuesList.addAll(this.getValues((HashMap)currValue, partialKey.noFirstKeyPartialKey()));
                    continue;
                }
                valuesList.add(currValue);
            }
        } else {
            Object currValue = map.get(keyValues[0]);
            if (currValue != null) {
                if (currValue instanceof HashMap) {
                    if (keyValues.length == 1) {
                        Object value = ((HashMap)currValue).get(keyValues[0]);
                        valuesList.add(value);
                    } else {
                        valuesList.addAll(this.getValues((HashMap)currValue, partialKey.noFirstKeyPartialKey()));
                    }
                } else {
                    valuesList.add(currValue);
                }
            }
        }
        return valuesList;
    }

    public MultiKey[] getMatchingKeys(MultiKey mKey) {
        ArrayList valuesList = new ArrayList();
        valuesList = this.getMatchingKeys(this.map, mKey, new ArrayList(), null);
        return valuesList.toArray(new MultiKey[valuesList.size()]);
    }

    public String toString() {
        StringBuffer toStringVal = new StringBuffer("");
        this.getMatchingKeys(this.map, this.getKeyToAll(), new ArrayList(), toStringVal);
        return toStringVal.toString();
    }

    protected void checkKeyTypeEnforcement(Object[] keyComp) {
        if (this.keyTypes != null) {
            for (int i = 0; i < keyComp.length; ++i) {
                if (keyComp[i] == null || this.keyTypes[i].isAssignableFrom(keyComp[i].getClass())) continue;
                throw new ClassCastException("The key components doesn't match the configured key types");
            }
        } else if (keyComp.length != this.numberOfKeys) {
            throw new IllegalArgumentException("The key length doesn't match the configured length");
        }
    }

    private ArrayList getMatchingKeys(HashMap map, MultiKey mKey, ArrayList tempKey, StringBuffer toStringValue) {
        ArrayList<MultiKey> keysList = new ArrayList<MultiKey>();
        Object[] keyValues = mKey.getKeyValues();
        if (keyValues[0] == null) {
            for (Object currKey : map.keySet()) {
                Object currValue = map.get(currKey);
                if (currValue == null) continue;
                if (keyValues.length == 1) {
                    int size = tempKey.size();
                    Object[] newKey = new Object[size + 1];
                    for (int j = 0; j < size; ++j) {
                        newKey[j] = tempKey.get(j);
                    }
                    newKey[size] = currKey;
                    MultiKey newMultiKey = new MultiKey(newKey);
                    if (toStringValue != null) {
                        toStringValue.append(newMultiKey.toString() + " " + currValue.toString() + "\n");
                    }
                    keysList.add(newMultiKey);
                    continue;
                }
                ArrayList oneMoreKey = (ArrayList)tempKey.clone();
                oneMoreKey.add(currKey);
                keysList.addAll(this.getMatchingKeys((HashMap)currValue, mKey.noFirstKeyPartialKey(), oneMoreKey, toStringValue));
            }
        } else {
            Object currValue = map.get(keyValues[0]);
            if (currValue != null) {
                if (keyValues.length == 1) {
                    int size = tempKey.size();
                    Object[] newKey = new Object[size + 1];
                    for (int j = 0; j < size; ++j) {
                        newKey[j] = tempKey.get(j);
                    }
                    newKey[size] = keyValues[0];
                    MultiKey newMultiKey = new MultiKey(newKey);
                    if (toStringValue != null) {
                        toStringValue.append(newMultiKey.toString() + " " + currValue.toString() + "\n");
                    }
                    keysList.add(newMultiKey);
                } else {
                    currValue = map.get(keyValues[0]);
                    if (currValue != null) {
                        ArrayList oneMoreKey = (ArrayList)tempKey.clone();
                        oneMoreKey.add(keyValues[0]);
                        keysList.addAll(this.getMatchingKeys((HashMap)currValue, mKey.noFirstKeyPartialKey(), oneMoreKey, toStringValue));
                    }
                }
            }
        }
        return keysList;
    }
}

