/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.table;

import com.sanrad.nms.server.exception.IllegalOperationException;
import com.sanrad.nms.server.logic.IllegalValueException;

public class MultiKey {
    protected StringBuffer toStringValue = new StringBuffer("");
    private Object[] keys = null;

    public MultiKey(Object[] keys) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException();
        }
        this.keys = keys;
        this.toStringValue.append('[');
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) {
                this.toStringValue.append(" * ");
                continue;
            }
            this.toStringValue.append(keys[i].toString() + " ");
        }
        this.toStringValue.append("] ");
    }

    public Object[] getKeyValues() {
        return this.keys;
    }

    public MultiKey partialKey(boolean[] keysToUse) throws IllegalValueException {
        if (keysToUse == null || keysToUse.length != this.keys.length) {
            throw new IllegalValueException(keysToUse == null ? "keysToUse == null" : "keysToUse.length(" + keysToUse.length + ") != keys.length(" + this.keys.length + ")");
        }
        Object[] subKey = new Object[keysToUse.length];
        for (int i = 0; i < keysToUse.length; ++i) {
            subKey[i] = keysToUse[i] ? this.keys[i] : null;
        }
        return new MultiKey(subKey);
    }

    public MultiKey noFirstKeyPartialKey() {
        if (this.keys.length == 1) {
            throw new IllegalOperationException("cannot make a partial MultiKey for a MultiKey which has only one key");
        }
        Object[] subKey = new Object[this.keys.length - 1];
        for (int i = 1; i < this.keys.length; ++i) {
            subKey[i - 1] = this.keys[i];
        }
        return new MultiKey(subKey);
    }

    public MultiKey noLastKeyPartialKey() {
        if (this.keys.length == 1) {
            throw new IllegalOperationException("cannot make a partial MultiKey for a MultiKey which has only one key");
        }
        Object[] subKey = new Object[this.keys.length - 1];
        for (int i = 0; i < this.keys.length - 1; ++i) {
            subKey[i] = this.keys[i];
        }
        return new MultiKey(subKey);
    }

    public boolean equals(MultiKey key) {
        if (key == null) {
            return false;
        }
        Object[] myValues = this.getKeyValues();
        Object[] valuesOfOtherMultiKey = key.getKeyValues();
        if (valuesOfOtherMultiKey.length != myValues.length) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!(valuesOfOtherMultiKey[i] != null ? !valuesOfOtherMultiKey[i].equals(myValues[i]) : myValues[i] != null)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o instanceof MultiKey ? this.equals((MultiKey)o) : super.equals(o);
    }

    public int hashCode() {
        int hash = 0;
        Object[] values = this.getKeyValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            hash += values[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.toStringValue.toString();
    }
}

