/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.client;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.validation.CreationValidator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.ConfigOperation;

public class ClientCedValidator {
    static String validate(ClientConfigElementData aCed) {
        ConfigOperation configType = aCed.getConfigOperation();
        switch (configType) {
            case CREATE: {
                CreationValidator validator = ClientCedValidator.getValidator(aCed.getClassId());
                return validator.validate(aCed);
            }
            case CHANGE: {
                if (aCed.isNested(ClientParameterCode.ELEMENT_ID)) {
                    return null;
                }
                GeneralLogicObjectImpl element = LogicMgrAOImpl.getInstance().getLogicObject(aCed.getCommKeyClassId());
                return element.validateChange(aCed.getValues());
            }
            case DELETE: 
            case DELETE_TREE: {
                GeneralLogicObjectImpl element = LogicMgrAOImpl.getInstance().getLogicObject(aCed.getCommKeyClassId());
                return element.validateDeletion();
            }
        }
        throw new IllegalArgumentException("CED type " + (Object)((Object)configType) + " in not valid");
    }

    private static CreationValidator getValidator(ClassID aClassId) {
        CreationValidator validator = CreationValidator.getCreationValidator(aClassId);
        if (validator == null) {
            throw new UnsupportedOperationException("The type " + aClassId + " doesn't have a creation validator");
        }
        return validator;
    }
}

