/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util.client;

import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.client.ClientCedValidator;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.SnapshotSchedulerStateConstant;
import com.sanrad.util.NetUtil;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class ClientCedExecutor {
    private static final ClientCedExecutor theInstance = new ClientCedExecutor();

    private ClientCedExecutor() {
    }

    public static ClientCedExecutor getInstance() {
        return theInstance;
    }

    public SrFuture<Void> config(ClientConfigElementData aClientCed) throws IllegalValueException {
        HashSet<ClusterImpl> clustersAccumulator = new HashSet<ClusterImpl>();
        this.getAllClusterFromNestedCeds(aClientCed, clustersAccumulator);
        for (ClusterImpl cluster : clustersAccumulator) {
            cluster.getStoragePoolMgr().startAllocationRequest();
        }
        ConfigElementDataList conversionResult = this.convertToServerCedList(aClientCed);
        List<ConfigElementDataList> cedListsByClusters = this.splitCedListByClustersAndVswitches(conversionResult);
        SrFuture<Void> retFuture = new SrFuture<Void>("ClientCedExecutor.config:" + aClientCed);
        this.executeSequentialConfigurations(cedListsByClusters.iterator(), retFuture);
        return retFuture;
    }

    private void executeSequentialConfigurations(final Iterator<ConfigElementDataList> aCedListIterator, final SrFuture<Void> aRetFuture) {
        if (aRetFuture.isDone()) {
            return;
        }
        if (aCedListIterator.hasNext()) {
            ConfigElementDataList currCedList = aCedListIterator.next();
            ClusterImpl currCluster = this.cleanClusterFromCedList(currCedList);
            final SrFuture<Void> currFuture = currCluster.configureElements(currCedList, null);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        currFuture.get();
                    }
                    catch (ExecutionException e) {
                        aRetFuture.setException(e);
                    }
                    catch (InterruptedException e) {
                        aRetFuture.setException(e);
                    }
                    ClientCedExecutor.this.executeSequentialConfigurations(aCedListIterator, aRetFuture);
                }
            };
            DefaultFutureListener.listenTo(run, currFuture);
        } else {
            aRetFuture.set(null);
        }
    }

    private ConfigElementDataList convertToServerCedList(ClientConfigElementData aClientCed) throws IllegalValueException {
        ConfigElementDataList result = new ConfigElementDataList(aClientCed.getConfigOperation());
        this.convertRecursive(aClientCed, false, new ArrayList<ClientConfigElementData>(), result);
        return result;
    }

    private ConfigElementData convertRecursive(ClientConfigElementData aNestedClientCed, boolean aIsNested, ArrayList<ClientConfigElementData> aConvertedCeds, ConfigElementDataList aConversionResult) throws IllegalValueException {
        if (this.isStartSnapshotSchedulerCed(aNestedClientCed)) {
            ClusterImpl cluster = this.getClientCedCluster(aNestedClientCed);
            aNestedClientCed = cluster.getSnapshotSchedulerMgr().getClientCedForStartScheduler(aNestedClientCed);
        }
        for (ClientConfigElementData preClientElement : aNestedClientCed.getPreConfigurationElements()) {
            this.convertRecursive(preClientElement, false, aConvertedCeds, aConversionResult);
        }
        ConfigElementData convertedCed = null;
        String validationError = ClientCedValidator.validate(aNestedClientCed);
        if (validationError != null) {
            throw new IllegalValueException(validationError);
        }
        convertedCed = this.convertClientCed(aNestedClientCed);
        convertedCed.setValue(ParameterCode.CLUSTER_ID, aNestedClientCed.getClusterId());
        if (!aConvertedCeds.contains(aNestedClientCed)) {
            aConvertedCeds.add(aNestedClientCed);
            Map<ClientParameterCode, ClientConfigElementData> nestedCeds = aNestedClientCed.getAllNestedClientCeds();
            for (ClientParameterCode nestedCode : nestedCeds.keySet()) {
                convertedCed.setValue(nestedCode.getParameterCode(), this.convertRecursive(nestedCeds.get(nestedCode), true, aConvertedCeds, aConversionResult));
            }
            Map<ClientParameterCode, ClientConfigElementData[]> nestedCedLists = aNestedClientCed.getAllNestedClientCedArrays();
            for (ClientParameterCode nestedCode : nestedCedLists.keySet()) {
                ClientConfigElementData[] cedArr;
                ConfigElementDataList cedList = new ConfigElementDataList(aNestedClientCed.getNestedConfigOperation(nestedCode));
                for (ClientConfigElementData clientCed : cedArr = nestedCedLists.get(nestedCode)) {
                    cedList.add(this.convertRecursive(clientCed, true, aConvertedCeds, aConversionResult));
                }
                convertedCed.setValue(nestedCode.getParameterCode(), cedList);
            }
        } else {
            convertedCed = (ConfigElementData)aConversionResult.findElementData(convertedCed);
        }
        boolean isConvertedCedAddedToResult = false;
        ConfigOperation configOperation = aNestedClientCed.getConfigOperation();
        if (configOperation.isDeleteOperation()) {
            LogicObjectImpl deleteTreeLogicObject = (LogicObjectImpl)LogicMgrAOImpl.getInstance().getLogicObject(convertedCed.getCommKeyClassId());
            ConfigElementDataList deleteCedList = null;
            if (ConfigOperation.DELETE_TREE.equals((Object)configOperation)) {
                deleteCedList = deleteTreeLogicObject.getTreeDeletionCedList();
            } else if (ConfigOperation.DELETE.equals((Object)configOperation)) {
                deleteCedList = new ConfigElementDataList(deleteTreeLogicObject.getCedForDeletion(), ConfigOperation.DELETE);
            }
            for (int i = 0; i < deleteCedList.size(); ++i) {
                CommKeyClassId deleteTreeCedId;
                ConfigElementData deleteTreeCed = (ConfigElementData)deleteCedList.get(i);
                CommKeyClassId covertedCedId = convertedCed.getCommKeyClassId();
                if (covertedCedId.equals(deleteTreeCedId = deleteTreeCed.getCommKeyClassId()) && ConfigOperation.DELETE.equals((Object)deleteTreeCed.getConfigOperation())) {
                    aConversionResult.add(convertedCed);
                    isConvertedCedAddedToResult = true;
                    continue;
                }
                deleteTreeCed.setValue(ParameterCode.CLUSTER_ID, aNestedClientCed.getClusterId());
                aConversionResult.add(deleteTreeCed);
            }
        }
        if (!aIsNested && !isConvertedCedAddedToResult) {
            aConversionResult.add(convertedCed);
        }
        for (ClientConfigElementData postClientElement : aNestedClientCed.getPostConfigurationElements()) {
            this.convertRecursive(postClientElement, false, aConvertedCeds, aConversionResult);
        }
        return convertedCed;
    }

    private ConfigElementData convertClientCed(ClientConfigElementData aClientCed) throws IllegalValueException {
        CommKeyClassId commKeyClassId;
        ConfigElementData ced = null;
        ClassID classId = aClientCed.getClassId();
        ConfigOperation configType = aClientCed.getConfigOperation();
        ClusterImpl cluster = this.getClientCedCluster(aClientCed);
        if (configType.equals((Object)ConfigOperation.CREATE)) {
            BigInteger size;
            if (ClassID.SUB_DIRECT_ACCESS_DEVICE.equals(classId)) {
                ConfigElementData subdiskCed = this.convertToSubdiskCed(aClientCed);
                cluster.getStoragePoolMgr().extractAndStoreNewVolumeNodesAliases(subdiskCed);
                return subdiskCed;
            }
            if (classId.isVolume() && (size = (BigInteger)aClientCed.getValue(ClientParameterCode.VOLUME_SPACE)) != null) {
                String targetName = (String)aClientCed.getValue(ClientParameterCode.TARGET_NAME);
                if (targetName != null) {
                    return cluster.getStoragePoolMgr().getExposeVolumeAllocationCed(aClientCed);
                }
                return cluster.getStoragePoolMgr().getVolumeAllocationCed(aClientCed);
            }
        }
        ced = (commKeyClassId = LogicMgrAOImpl.getInstance().getServerCKCI(aClientCed.getCommKeyClassId())) != null ? new ConfigElementData(commKeyClassId, configType) : new ConfigElementData(classId, configType);
        Map<ClientParameterCode, Object> values = aClientCed.getValues();
        for (ClientParameterCode clientCode : values.keySet()) {
            Object clientValue = values.get(clientCode);
            if (clientValue instanceof Object[]) {
                Object convertedValues = this.convertValues((Object[])clientValue, classId, clientCode);
                if (convertedValues instanceof SrType[]) {
                    ced.setValues(clientCode.getParameterCode(), (SrType[])convertedValues);
                    continue;
                }
                if (!(convertedValues instanceof ConfigElementDataList)) continue;
                ced.setValue(clientCode.getParameterCode(), (ConfigElementDataList)convertedValues);
                continue;
            }
            Object convertedValue = this.convertValue(clientValue, classId, clientCode);
            if (convertedValue instanceof SrType) {
                ced.setValue(clientCode.getParameterCode(), (SrType)convertedValue);
                continue;
            }
            if (convertedValue instanceof ConfigElementData) {
                ced.setValue(clientCode.getParameterCode(), (ConfigElementData)convertedValue);
                continue;
            }
            throw new IllegalStateException("Value of type " + convertedValue.getClass().getSimpleName() + " is not supported, value = " + convertedValue);
        }
        if (ConfigOperation.CREATE.equals((Object)configType) && classId.isVolume()) {
            cluster.getStoragePoolMgr().extractAndStoreNewVolumeNodesAliases(ced);
        }
        return ced;
    }

    private Object convertValue(Object aValue, ClassID aClassId, ClientParameterCode aClientCode) throws IllegalValueException {
        if (aValue instanceof String) {
            String strVal = (String)aValue;
            if (ClientParameterCode.TARGET_EXPOSED_ON.equals(aClientCode)) {
                return new SrString(strVal);
            }
            if (NetUtil.isIpAddress(strVal)) {
                return new SrIpAddress(strVal);
            }
            return new SrString(strVal);
        }
        if (aValue instanceof Integer) {
            return new SrInteger((Integer)aValue);
        }
        if (aValue instanceof Long) {
            if (ClientParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE.equals(aClientCode)) {
                return new SrLunFormat(new BigInteger(aValue.toString()));
            }
            return new SrGauge((Long)aValue);
        }
        if (aValue instanceof CommKeyClassId) {
            CommKeyClassId serverCkid = LogicMgrAOImpl.getInstance().getServerCKCI((CommKeyClassId)aValue);
            if (ClassID.DIRECT_ACCESS_DEVICE.equals(serverCkid.getClassID())) {
                if (ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_PARENT.equals(aClientCode)) {
                    return serverCkid;
                }
                DirectAccessDeviceImpl disk = (DirectAccessDeviceImpl)LogicMgrAOImpl.getInstance().getLogicObject(serverCkid);
                if (disk != null) {
                    if (disk.isTotalSpaceSubdisk()) {
                        SubDirectAccessDeviceImpl totalSpaceSubdisk = disk.getTotalSpaceSubdisk();
                        return totalSpaceSubdisk.getCommKeyClassId();
                    }
                    if (disk.isTotalSpaceAvailableForAllocation()) {
                        return disk.getTotalSpaceSubdiskCed();
                    }
                    throw new IllegalValueException("Disk " + disk + " is not free for use");
                }
                throw new IllegalValueException("No element found for ID " + aValue);
            }
            return serverCkid;
        }
        if (aValue instanceof SrType) {
            return (SrType)aValue;
        }
        if (aValue instanceof Date) {
            return new SrDateAndTime((Date)aValue);
        }
        if (aValue instanceof List) {
            List list = (List)aValue;
            Object[] converted = new Object[list.size()];
            int index = 0;
            for (Object clientValue : list) {
                converted[index] = this.convertValue(clientValue, aClassId, aClientCode);
                ++index;
            }
        } else {
            if (aValue == null) {
                return null;
            }
            if (aValue instanceof ClientConfigElementData) {
                return null;
            }
            if (aValue instanceof ClientConfigElementData[]) {
                return null;
            }
        }
        throw new IllegalValueException("Could not convert value " + aValue + " of type " + aValue.getClass() + " of ClientParamterCode " + aClientCode);
    }

    private Object convertValues(Object[] aValues, ClassID aClassId, ClientParameterCode aClientCode) throws IllegalValueException {
        if (aValues instanceof String[] || aValues instanceof Integer[] || aValues instanceof Long[] || aValues instanceof CommKeyClassId[] || aValues instanceof SrType[]) {
            boolean isCedList = false;
            boolean isCkidList = true;
            ConfigOperation cedListConfigOperation = null;
            Object[] converted = new Object[aValues.length];
            for (int i = 0; i < aValues.length; ++i) {
                converted[i] = this.convertValue(aValues[i], aClassId, aClientCode);
                if (converted[i] instanceof ConfigElementData) {
                    isCedList = true;
                    cedListConfigOperation = ((ConfigElementData)converted[i]).getConfigOperation();
                    continue;
                }
                if (converted[i] instanceof CommKeyClassId) continue;
                isCkidList = false;
            }
            if (isCedList && !isCkidList) {
                throw new IllegalArgumentException("The list of values in ClientParameterCode " + aClientCode + " are invalid, values:" + Arrays.toString(aValues));
            }
            if (isCedList) {
                ConfigElementDataList cedList = new ConfigElementDataList(cedListConfigOperation);
                for (int i = 0; i < converted.length; ++i) {
                    if (converted[i] instanceof ConfigElementData) {
                        cedList.add((ConfigElementData)converted[i]);
                        continue;
                    }
                    if (!(converted[i] instanceof CommKeyClassId)) continue;
                    ConfigElementData ced = new ConfigElementData((CommKeyClassId)converted[i], cedListConfigOperation);
                    cedList.add(ced);
                }
                return cedList;
            }
            SrType[] convertedSrTypes = new SrType[aValues.length];
            System.arraycopy(converted, 0, convertedSrTypes, 0, converted.length);
            return convertedSrTypes;
        }
        throw new IllegalValueException("Could not convert value " + Arrays.asList(aValues) + " of type " + aValues.getClass() + " of ClientParamterCode " + aClientCode);
    }

    private ConfigElementData convertToSubdiskCed(ClientConfigElementData aClientCed) throws IllegalValueException {
        if (!ClassID.SUB_DIRECT_ACCESS_DEVICE.equals(aClientCed.getClassId())) {
            throw new IllegalArgumentException("aClientCed, " + aClientCed + ", is not a subdisk CED");
        }
        if (!ConfigOperation.CREATE.equals((Object)aClientCed.getConfigOperation())) {
            throw new IllegalArgumentException("aClientCed, " + aClientCed + ", is not a subdisk creation CED");
        }
        CommKeyClassId diskId = (CommKeyClassId)aClientCed.getValue(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_PARENT);
        DirectAccessDeviceImpl disk = (DirectAccessDeviceImpl)LogicMgrAOImpl.getInstance().getLogicObject(diskId);
        String alias = (String)aClientCed.getValue(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        BigInteger size = (BigInteger)aClientCed.getValue(ClientParameterCode.SUB_DIRECT_ACCESS_DEVICE_SIZE);
        return disk.getVolumeAllocationCed(alias, size, null);
    }

    private ClusterImpl getClientCedCluster(ClientConfigElementData aClientCed) {
        return (ClusterImpl)LogicMgrAOImpl.getInstance().getLogicObject(aClientCed.getClusterId());
    }

    private void getAllClusterFromNestedCeds(ClientConfigElementData aClientCed, Set<ClusterImpl> aClustersAccumulator) {
        Util.validateInputNotNull(aClientCed, "Client CED");
        Util.validateInputNotNull(aClustersAccumulator, "Clusters accumulator");
        for (ClientConfigElementData preClientElement : aClientCed.getPreConfigurationElements()) {
            this.getAllClusterFromNestedCeds(preClientElement, aClustersAccumulator);
        }
        aClustersAccumulator.add(this.getClientCedCluster(aClientCed));
        Map<ClientParameterCode, ClientConfigElementData> nestedCeds = aClientCed.getAllNestedClientCeds();
        for (ClientParameterCode nestedCode : nestedCeds.keySet()) {
            ClientConfigElementData nsetedCed = nestedCeds.get(nestedCode);
            this.getAllClusterFromNestedCeds(nsetedCed, aClustersAccumulator);
        }
        Map<ClientParameterCode, ClientConfigElementData[]> nestedCedLists = aClientCed.getAllNestedClientCedArrays();
        for (ClientParameterCode nestedCode : nestedCedLists.keySet()) {
            ClientConfigElementData[] cedArr;
            for (ClientConfigElementData clientCed : cedArr = nestedCedLists.get(nestedCode)) {
                this.getAllClusterFromNestedCeds(clientCed, aClustersAccumulator);
            }
        }
        for (ClientConfigElementData postClientElement : aClientCed.getPostConfigurationElements()) {
            this.getAllClusterFromNestedCeds(postClientElement, aClustersAccumulator);
        }
    }

    private boolean isStartSnapshotSchedulerCed(ClientConfigElementData aCed) {
        return ConfigOperation.CHANGE.equals((Object)aCed.getConfigOperation()) && ClassID.SNAPSHOT_SCHEDULER.equals(aCed.getClassId()) && SnapshotSchedulerStateConstant.RUNNING.equals(aCed.getValue(ClientParameterCode.SNAPSHOT_SCHEDULER_STATE));
    }

    private ClusterImpl cleanClusterFromCedList(ConfigElementDataList aCedList) {
        ClusterImpl retCluster = null;
        for (ElementData ced : aCedList) {
            ClusterImpl currCluster = this.cleanClusterFromCed((ConfigElementData)ced);
            if (retCluster == null) {
                retCluster = currCluster;
                continue;
            }
            if (currCluster == null || currCluster.equals(retCluster)) continue;
            throw new IllegalStateException("CED list contains CEDs with different clusters: " + aCedList);
        }
        return retCluster;
    }

    private ClusterImpl cleanClusterFromCed(ConfigElementData aCed) {
        CommKeyClassId clusterId = (CommKeyClassId)aCed.removeValue(ParameterCode.CLUSTER_ID);
        ClusterImpl retCluster = (ClusterImpl)LogicMgrAOImpl.getInstance().getLogicObject(clusterId);
        for (ParameterCodes code : aCed.hiddenKeySet()) {
            Object obj = aCed.getValue(code);
            ClusterImpl nestedCluster = null;
            if (obj instanceof ElementData) {
                nestedCluster = this.cleanClusterFromCed((ConfigElementData)obj);
            } else if (obj instanceof ConfigElementDataList) {
                nestedCluster = this.cleanClusterFromCedList((ConfigElementDataList)obj);
            }
            if (nestedCluster == null || nestedCluster.equals(retCluster)) continue;
            throw new IllegalStateException("CED contains nested CEDs with different clusters: " + aCed);
        }
        return retCluster;
    }

    private List<ConfigElementDataList> splitCedListByClustersAndVswitches(ConfigElementDataList aCedList) {
        ArrayList<ConfigElementDataList> retListOfCedList = new ArrayList<ConfigElementDataList>();
        ConfigElementDataList cedListSplit = new ConfigElementDataList();
        List<CommKeyClassId> cedListIdentifiers = null;
        for (ElementData ced : aCedList) {
            boolean isNewBrokenList = false;
            List<CommKeyClassId> currIdentifiers = this.getCedIdentifiers(ced);
            if (cedListIdentifiers == null) {
                cedListIdentifiers = currIdentifiers;
            } else if (!Util.equalsListNotOrdered(cedListIdentifiers, currIdentifiers)) {
                isNewBrokenList = true;
            }
            if (isNewBrokenList) {
                retListOfCedList.add(cedListSplit);
                cedListSplit = new ConfigElementDataList((ConfigElementData)ced);
                continue;
            }
            cedListSplit.add(ced);
        }
        retListOfCedList.add(cedListSplit);
        return retListOfCedList;
    }

    private List<CommKeyClassId> getCedIdentifiers(ElementData aCed) {
        Util.validateInputNotNull(aCed, "CED");
        CommKeyClassId[] vswitchIds = aCed.getVswitchIds();
        if (vswitchIds != null) {
            return Util.convertToList(vswitchIds);
        }
        CommKeyClassId clusterId = (CommKeyClassId)aCed.getValue(ParameterCode.CLUSTER_ID);
        if (clusterId == null) {
            throw new IllegalStateException("CED doesn't contain a cluster ID: " + aCed);
        }
        return Collections.singletonList(clusterId);
    }
}

