/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import java.util.HashMap;

public class VSwitchClusterMap {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static VSwitchClusterMap theInstance = new VSwitchClusterMap();
    private HashMap vSwitchClusterMap = new HashMap();

    private VSwitchClusterMap() {
    }

    public static VSwitchClusterMap getInstance() {
        return theInstance;
    }

    public void add(CommKeyClassId vSwitchId, CommKeyClassId clusterId) {
        this.vSwitchClusterMap.put(vSwitchId, clusterId);
    }

    public CommKeyClassId getClusterId(CommKeyClassId vSwitchId) {
        return (CommKeyClassId)this.vSwitchClusterMap.get(vSwitchId);
    }

    private String getVSwitchIp(CommKeyClassId vSwitchId) {
        CommKey[] commKeys = vSwitchId.getCommKeys();
        for (int i = 0; i < commKeys.length; ++i) {
            if (!(commKeys[i] instanceof DataBaseCommKey)) continue;
            return commKeys[i].getKey();
        }
        return null;
    }

    public Integer getClusterId(String vSwitchIp) {
        for (CommKeyClassId vSwitchId : this.vSwitchClusterMap.keySet()) {
            String ip = this.getVSwitchIp(vSwitchId);
            if (!vSwitchIp.equals(ip)) continue;
            CommKeyClassId clusterCommKeyClassId = this.getClusterId(vSwitchId);
            return new Integer(clusterCommKeyClassId.getCommKeys()[0].myKey);
        }
        return null;
    }

    public void remove(CommKeyClassId vSwitchId) {
        if (this.vSwitchClusterMap.remove(vSwitchId) == null) {
            theLogger.warn(SrLogCategories.LEGACY, "VSwitch ID ", vSwitchId, " not found in VSwitchClusterMap");
        } else {
            theLogger.trace(SrLogCategories.LEGACY, "VSwitch ID ", vSwitchId, " removed from VSwitchClusterMap");
        }
    }
}

