/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.util.FileInterface;
import com.sanrad.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.rmi.RemoteException;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileInterfaceImpl
extends RemoteObjectImpl
implements FileInterface {
    private static SrLogger theLogger = null;

    @Override
    public byte[] downloadFile(String fileName) throws RemoteException {
        try {
            String fullPathToFileName = Util.getLocalDir() + '\\' + fileName;
            File file = new File(fullPathToFileName);
            byte[] buffer = new byte[(int)file.length()];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(fullPathToFileName));
            input.read(buffer, 0, buffer.length);
            input.close();
            return buffer;
        }
        catch (Exception e) {
            theLogger.trace(SrLogCategories.LEGACY, "FileInterfaceImpl: ", e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void uploadFile(byte[] filedata) throws RemoteException {
        StringBuffer sb = new StringBuffer(Util.getLocalDir());
        sb.append("\\config\\spconfig.zip");
        File destinationZIPFile = new File(sb.toString());
        try {
            destinationZIPFile.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(destinationZIPFile);
            fileOutputStream.write(filedata);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.changeXmlFilesName(true);
            this.decompressFile(destinationZIPFile);
            if (!this.verifyFiles()) {
                this.changeXmlFilesName(false);
            }
        }
        catch (Exception ioe) {
            System.err.println("FileServer exception: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void changeXmlFilesName(boolean type) {
        File sanNew = new File(Util.getLocalDir() + "\\config\\san.xml");
        File logNew = new File(Util.getLocalDir() + "\\config\\LogProperties.xml");
        File alarmNew = new File(Util.getLocalDir() + "\\config\\alarms.xml");
        File sanOld = new File(Util.getLocalDir() + "\\config\\sanOld.xml");
        File logOld = new File(Util.getLocalDir() + "\\config\\LogPropertiesOld.xml");
        File alarmOld = new File(Util.getLocalDir() + "\\config\\alarmsOld.xml");
        if (type) {
            sanNew.renameTo(sanOld);
            logNew.renameTo(logOld);
            alarmNew.renameTo(alarmOld);
        } else {
            sanOld.renameTo(sanNew);
            logOld.renameTo(logNew);
            alarmOld.renameTo(alarmNew);
        }
    }

    private boolean verifyFiles() {
        File san = new File(Util.getLocalDir() + "\\config\\san.xml");
        File log = new File(Util.getLocalDir() + "\\config\\LogProperties.xml");
        File alarm = new File(Util.getLocalDir() + "\\config\\alarms.xml");
        return san.isFile() && log.isFile() && alarm.isFile();
    }

    private void decompressFile(File zip) {
        int BUFFER = 2048;
        BufferedOutputStream dest = null;
        try {
            ZipEntry entry;
            FileInputStream fis = new FileInputStream(zip);
            CheckedInputStream checksum = new CheckedInputStream(fis, new Adler32());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(checksum));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(Util.getLocalDir() + "\\config\\" + entry.getName());
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        theLogger = SrLogger.getLogger();
    }
}

