/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrType;

public class CommKeyClassId
extends SrType
implements CommKeyFetcher {
    private CommKey[] keys;
    private ClassID classId;

    public CommKeyClassId(CommKey[] keys, ClassID classId) {
        super("CommKeyClassId");
        this.keys = keys;
        this.classId = classId;
    }

    public CommKeyClassId(CommKey key, ClassID classId) {
        super("CommKeyClassId");
        if (key == null) {
            throw new NullPointerException("CommKey shouldn't be null");
        }
        this.keys = new CommKey[1];
        this.keys[0] = key;
        this.classId = classId;
    }

    public CommKeyClassId(CommKeyClassId val) {
        super("CommKeyClassId");
        if (val == null) {
            throw new NullPointerException("CommKeyClassId shouldn't be null");
        }
        int keysLen = val.getCommKeys().length;
        this.keys = new CommKey[keysLen];
        System.arraycopy(val.getCommKeys(), 0, this.keys, 0, keysLen);
        this.classId = val.getClassID();
    }

    public CommKey[] getCommKeys() {
        return this.keys;
    }

    public ClassID getClassID() {
        return this.classId;
    }

    @Override
    public Object value() {
        return null;
    }

    public Object clone() {
        return new CommKeyClassId(this);
    }

    private boolean isContainCommKey(CommKey commKey, CommKey[] commKeys) {
        for (int i = 0; i < commKeys.length; ++i) {
            if (!commKey.equals(commKeys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommKeyClassId)) {
            return false;
        }
        CommKeyClassId other = (CommKeyClassId)obj;
        ClassID otherClassId = other.getClassID();
        if (!(this.getClassID().equals(otherClassId) || this.getClassID().isVolume() && otherClassId.isVolume() || this.getClassID().isSCSIDevice() && otherClassId.isSCSIDevice() || this.getClassID().isInterface() && otherClassId.isInterface())) {
            return false;
        }
        if ((this.getClassID().isStatisticsClassId() || otherClassId.isStatisticsClassId()) && !this.getClassID().equals(otherClassId)) {
            return false;
        }
        CommKey[] objKeys = other.getCommKeys();
        if (objKeys == null && this.keys == null) {
            return true;
        }
        if (objKeys == null && this.keys != null || objKeys != null && this.keys == null) {
            return false;
        }
        for (CommKey key : this.keys) {
            if (!this.isContainCommKey(key, objKeys)) continue;
            return true;
        }
        for (CommKey key : objKeys) {
            if (!this.isContainCommKey(key, this.keys)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.classId.isVolume()) {
            int code = ClassID.GENERAL_VOLUME.toString().hashCode();
            return code;
        }
        if (this.classId.isSCSIDevice()) {
            return ClassID.GENERAL_SCSI_DEVICE.toString().hashCode();
        }
        if (this.classId.isInterface()) {
            return ClassID.INTERFACE.toString().hashCode();
        }
        return this.classId.toString().hashCode();
    }

    @Override
    public String toDisplayString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("CKCID [");
        str.append(this.classId);
        str.append('{');
        if (this.keys != null) {
            int i = this.keys.length;
            while (i-- > 0) {
                str.append(this.keys[i].toString());
                if (this.keys[i] instanceof SnmpCommKey) {
                    str.append(':');
                    str.append((int)((SnmpCommKey)this.keys[i]).getSnmpAgentIndex());
                }
                str.append(',');
            }
        } else {
            str.append("null keys");
        }
        str.append("}]");
        return str.toString();
    }

    public char getMyFirstSnmpAgentIndex() {
        return CommKeyUtil.getSnmpCommKey(this.keys).getSnmpAgentIndex();
    }

    @Override
    public int getTypeNumber() {
        return 14;
    }

    public boolean startsWith(CommKeyClassId commKey) {
        SnmpCommKey thisSnmpCommkey = (SnmpCommKey)this.keys[0];
        SnmpCommKey valueSnmpCommkey = (SnmpCommKey)commKey.getCommKeys()[0];
        return thisSnmpCommkey.toString().startsWith(valueSnmpCommkey.toString());
    }

    public CommKeyClassId[] getVswitchesCommKeyClassId() {
        return CommKeyUtil.getVSwitchCommKeyClassIDs(this.getCommKeys());
    }

    @Override
    public DataBaseCommKey getDBCommKey() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (((CommKeyFetcher)((Object)this.keys[i])).getDBCommKey() == null) continue;
            return (DataBaseCommKey)this.keys[i].clone();
        }
        return null;
    }

    @Override
    public SnmpCommKey getSnmpCommKey() {
        for (int i = 0; i < this.keys.length; ++i) {
            if (((CommKeyFetcher)((Object)this.keys[i])).getSnmpCommKey() == null) continue;
            return (SnmpCommKey)this.keys[i].clone();
        }
        return null;
    }
}

