/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.util;

import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AllocationPolicy
implements Serializable {
    private static final long serialVersionUID = -801571511217610775L;
    public static final AllocationPolicy REUSE_ALLOCATED = new SinglePolicy("REUSE_ALLOCATED");
    public static final AllocationPolicy DONT_REUSE_ALLOCATED = new SinglePolicy("DONT_REUSE_ALLOCATED");
    public static final AllocationPolicy SEPARATED_RAIDS = new SinglePolicy("SEPARATED_RAIDS");
    public static final AllocationPolicy EXTRA_BLOCK = new SinglePolicy("EXTRA_BLOCK");
    public static final AllocationPolicy FORBIDDEN_STORAGES = new SinglePolicy("FORBIDEN_STORAGES");
    public static final AllocationPolicy ALLOWED_STORAGES = new SinglePolicy("ALLOWED_STORAGES");
    public static final AllocationPolicy IGNORE_RAID_ATTACHMENT = new SinglePolicy("IGNORE_RAID_ATTACHMENT");
    protected SinglePolicy[] myPolicies;
    private ArrayList<CommKeyClassId> myAllocableList = new ArrayList();

    private AllocationPolicy() {
    }

    public Object clone() {
        AllocationPolicy cloned = new AllocationPolicy();
        cloned.myAllocableList = new ArrayList<CommKeyClassId>(this.myAllocableList);
        cloned.myPolicies = new SinglePolicy[this.myPolicies.length];
        System.arraycopy(this.myPolicies, 0, cloned.myPolicies, 0, this.myPolicies.length);
        return cloned;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        for (SinglePolicy ap : this.myPolicies) {
            sb.append(ap.mySinglePolicyType).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString();
    }

    public AllocationPolicy createResourcesPolicy(List<CommKeyClassId> aResourcesList) {
        AllocationPolicy cloned = (AllocationPolicy)this.clone();
        if (aResourcesList != null) {
            cloned.myAllocableList.addAll(aResourcesList);
        }
        return cloned;
    }

    public List<CommKeyClassId> getStorageResources() {
        return new ArrayList<CommKeyClassId>(this.myAllocableList);
    }

    public AllocationPolicy addPolicy(AllocationPolicy aOtherPolicy) {
        if (aOtherPolicy == null) {
            return this;
        }
        AllocationPolicy cloned = new AllocationPolicy();
        ArrayList<SinglePolicy> policies = new ArrayList<SinglePolicy>();
        for (SinglePolicy singlePolicy : this.myPolicies) {
            if (policies.contains(singlePolicy)) continue;
            policies.add(singlePolicy);
        }
        for (SinglePolicy singlePolicy : aOtherPolicy.myPolicies) {
            if (policies.contains(singlePolicy)) continue;
            policies.add(singlePolicy);
        }
        cloned.myPolicies = policies.toArray(new SinglePolicy[policies.size()]);
        cloned.myAllocableList.addAll(this.myAllocableList);
        cloned.myAllocableList.addAll(aOtherPolicy.myAllocableList);
        return cloned;
    }

    public AllocationPolicy addPolicy(AllocationPolicy aOtherPolicy, List<CommKeyClassId> aResourcesList) {
        AllocationPolicy policy = this.createResourcesPolicy(aResourcesList);
        policy = policy.addPolicy(aOtherPolicy);
        return policy;
    }

    public static AllocationPolicy addPolicy(AllocationPolicy aFirstPolicy, AllocationPolicy aSecondPolicy, List<CommKeyClassId> aResourcesList) {
        if (aFirstPolicy == null) {
            return aSecondPolicy == null ? null : aSecondPolicy.createResourcesPolicy(aResourcesList);
        }
        if (aSecondPolicy == null) {
            return aFirstPolicy == null ? null : aFirstPolicy.createResourcesPolicy(aResourcesList);
        }
        return aFirstPolicy.addPolicy(aSecondPolicy, aResourcesList);
    }

    public static AllocationPolicy addPolicy(AllocationPolicy aFirstPolicy, AllocationPolicy aSecondPolicy) {
        if (aFirstPolicy == null) {
            return aSecondPolicy;
        }
        if (aSecondPolicy == null) {
            return aFirstPolicy;
        }
        return aFirstPolicy.addPolicy(aSecondPolicy);
    }

    public boolean contains(AllocationPolicy aOtherPolicy) {
        return Arrays.asList(this.myPolicies).containsAll(Arrays.asList(aOtherPolicy.myPolicies)) && this.myAllocableList.containsAll(aOtherPolicy.myAllocableList);
    }

    private static class SinglePolicy
    extends AllocationPolicy {
        private String mySinglePolicyType;

        SinglePolicy(String aSinglePolicyType) {
            Util.validateInputNotNull(aSinglePolicyType, "Policy type String");
            this.mySinglePolicyType = aSinglePolicyType;
            this.myPolicies = new SinglePolicy[]{this};
        }

        public boolean equals(Object o) {
            if (o instanceof SinglePolicy) {
                return this.mySinglePolicyType.equals(((SinglePolicy)o).mySinglePolicyType);
            }
            return false;
        }
    }
}

