/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.user;

import com.sanrad.log.LogManager;
import com.sanrad.log.LogManagerImpl;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.AbstractBoundedStub;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.alarm.AlarmMgr;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.EventService;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.volume.SimpleVolumeFinder;
import com.sanrad.nms.server.logic.volume.SimpleVolumeFinderImpl;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserEvent;
import com.sanrad.nms.server.user.UserImpl;
import com.sanrad.nms.server.user.UserListener;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.security.StringCodec;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class UserManagerImpl
extends AbstractBoundedStub
implements UserManager,
UserListener {
    public static String DEFAULT_USER = Server.CONSTANSTS_BUNDLE.getString(SrConstantsBundleKeys.NMS_DEFAULT_USER_NAME);
    private static SrLogger theLogger = SrLogger.getLogger();
    private boolean myLoadUsersCompleted = false;
    private static final String DEFAULT_PASSWORD;
    private static UserManagerImpl theInstance;
    private HashMap<String, UserImpl> myUsers = new HashMap();
    private boolean myIsUserFileConverted = false;

    private UserManagerImpl() {
    }

    public static synchronized UserManagerImpl getInstance() {
        if (theInstance == null) {
            theInstance = new UserManagerImpl();
        }
        return theInstance;
    }

    private static String getFileCodecKey() {
        String codecKey = ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage();
        return codecKey;
    }

    @Override
    public String getCodecKey() {
        return UserImpl.getCodecKey();
    }

    @Override
    public SrFuture<Void> addUser(String username, String password) throws RemoteException, IllegalValueException, IOException {
        UserImpl user = this.myUsers.get(username);
        if (user != null) {
            String msg = "User " + username + " already exists.";
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        UserImpl newUser = new UserImpl(username, password);
        newUser.addUserListener(this);
        this.myUsers.put(username, newUser);
        this.saveUsers();
        ElementEventImpl event = new ElementEventImpl((Object)newUser, newUser);
        LogicMgrAOImpl.getInstance().__elementCreated(event);
        return new CompleteFuture<Void>("UserManagerImpl.addUser");
    }

    @Override
    public SrFuture<Void> removeUsers(Vector users) throws RemoteException, IllegalValueException, IOException {
        final SrFuture<Void> retFuture = new SrFuture<Void>("UserManagerImpl.removeUsers");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        Enumeration e = users.elements();
        while (e.hasMoreElements()) {
            User user = (User)e.nextElement();
            midFutures.add(this.removeUser(user));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, retFuture);
            }
        };
        DefaultFutureListener.listenTo(toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> removeUser(User user) throws IllegalValueException, IOException {
        UserImpl oldUser = this.myUsers.remove(user.getUsername());
        if (oldUser == null) {
            String msg = "User " + user.getUsername() + " not found.";
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        this.saveUsers();
        ElementEventImpl event = new ElementEventImpl((Object)user, user);
        LogicMgrAOImpl.getInstance().__elementRemoved(event);
        return new CompleteFuture<Void>("UserManagerImpl.removeUser");
    }

    @Override
    public User getUser(String username) throws RemoteException, IllegalValueException {
        if (this.myUsers == null) {
            String msg = "User " + username + " not found.";
            theLogger.trace(SrLogCategories.LEGACY, msg, " probably users file was corrupted.");
            throw new IllegalValueException(msg);
        }
        UserImpl user = this.myUsers.get(username);
        if (user == null) {
            String msg = "Incorrect password or unknown user name.";
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        return user;
    }

    @Override
    public void login(String aUsername, String aPassword) throws RemoteException, IllegalValueException {
        this.loginClient(aUsername, aPassword);
    }

    @Override
    public User loginClient(String aUserName, String aPassword) throws RemoteException, IllegalValueException {
        UserImpl user = null;
        UserImpl loginUser = new UserImpl(aUserName, aPassword);
        while (!this.myLoadUsersCompleted) {
            try {
                Thread.sleep(1000L);
                theLogger.info(SrLogCategories.INFORMATIVE, "Login: " + aUserName + ". Waiting for load users to complete.");
            }
            catch (InterruptedException ie) {
                theLogger.error(SrLogCategories.EXCEPTION, ie, new Object[0]);
            }
        }
        if (this.myUsers.size() == 0) {
            if (aUserName.equals(DEFAULT_USER)) {
                user = new UserImpl(DEFAULT_USER, DEFAULT_PASSWORD);
            } else {
                String oldDefaultUserAndPassword = "sanrad";
                if (aUserName.equals(oldDefaultUserAndPassword)) {
                    user = new UserImpl(oldDefaultUserAndPassword, UserImpl.getCodePassword(oldDefaultUserAndPassword));
                }
            }
        } else {
            user = (UserImpl)this.getUser(aUserName);
        }
        String errorMsg = "Incorrect password or unknown user name.";
        if (user == null) {
            String msg = errorMsg;
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        if (!user.equals(loginUser)) {
            String msg = errorMsg;
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        return user;
    }

    @Override
    public HashMap getAllUsers() throws RemoteException, IllegalValueException {
        return this.myUsers;
    }

    @Override
    public void userChanged(UserEvent aEvent) {
        try {
            this.saveUsers();
        }
        catch (RemoteException e1) {
            theLogger.error(SrLogCategories.EXCEPTION, e1, new Object[0]);
        }
        catch (IOException e) {
            theLogger.error(SrLogCategories.EXCEPTION, e, new Object[0]);
        }
    }

    private void saveUsers() throws IOException {
        Set<String> usernames = this.myUsers.keySet();
        String codecKey = UserManagerImpl.getFileCodecKey();
        Properties usersProp = new Properties();
        Iterator<String> i = usernames.iterator();
        while (i.hasNext()) {
            UserImpl decodeUser = this.myUsers.get(i.next());
            String password = UserImpl.getCodePassword(codecKey, decodeUser.getPassword());
            String username = decodeUser.getUsername();
            String encodedUsername = StringCodec.encryptString(codecKey, username);
            usersProp.setProperty(encodedUsername, password);
        }
        ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().setPropertiesToFile("users.dat", usersProp));
    }

    public synchronized void loadUsersFromFile() throws RemoteException {
        this.myLoadUsersCompleted = false;
        this.myUsers.clear();
        String codecKey = UserManagerImpl.getFileCodecKey();
        try {
            Properties usersProp = DataMgrAdapter.getInstance().loadPropertiesFromFile("users.dat").get();
            for (Map.Entry<Object, Object> entry : usersProp.entrySet()) {
                String encodedUesrname = (String)entry.getKey();
                String decodedUsername = StringCodec.decryptString(codecKey, encodedUesrname);
                if (decodedUsername == null && !this.myIsUserFileConverted) {
                    ConvertUsersFile cuf = new ConvertUsersFile();
                    cuf.convert();
                    this.myIsUserFileConverted = true;
                    this.loadUsersFromFile();
                    return;
                }
                String encodedPassword = (String)entry.getValue();
                String decodedPassword = StringCodec.decryptString(codecKey, encodedPassword);
                UserImpl decodeUser = new UserImpl(decodedUsername, decodedPassword, false);
                decodeUser.addUserListener(this);
                this.myUsers.put(decodeUser.getUsername(), decodeUser);
            }
        }
        catch (SrExecutionException e) {
            for (Throwable exception : e.getCauses()) {
                if (exception instanceof FileNotFoundException) {
                    theLogger.warn(SrLogCategories.INFORMATIVE, "Users file couldn't found: " + exception.getMessage());
                    continue;
                }
                theLogger.error(SrLogCategories.ERROR, "Failed to load Users file: " + exception);
            }
        }
        catch (InterruptedException ie) {
            theLogger.error(SrLogCategories.ERROR, "The LogicMgr thread was interrupted ", ie);
        }
        this.myLoadUsersCompleted = true;
    }

    @Override
    public void checkConnectivity() throws RemoteException {
    }

    @Override
    public SystemRoot getSystemRoot() throws RemoteException {
        return SystemRootImpl.getInstance();
    }

    @Override
    public LogManager getLogManager() throws RemoteException {
        return LogManagerImpl.getInstance();
    }

    @Override
    public SimpleVolumeFinder getSimpleVolumeFinder() {
        return SimpleVolumeFinderImpl.getInstance();
    }

    @Override
    @Deprecated
    public EventService getEventService() {
        return LogicMgrAOImpl.getInstance().getEventServiceImpl();
    }

    @Override
    public AlarmMgr getAlarmMgr() throws RemoteException {
        return AlarmMgrImpl.getInstance();
    }

    @Override
    public AlarmMgr getDrAlarmMgr() throws RemoteException {
        return DrAlarmMgrImpl.getInstance();
    }

    public String toString() {
        return "UserManager";
    }

    @Override
    public int getMaxSnapshotsPerVolume() throws RemoteException {
        return ServerPropertiesFetcher.getMaxSnapshotPerVolume();
    }

    static {
        DEFAULT_USER = DEFAULT_USER == null || DEFAULT_USER.equals("") ? "sanrad" : DEFAULT_USER;
        DEFAULT_PASSWORD = UserImpl.getCodePassword(DEFAULT_USER);
        theInstance = null;
    }

    private class ConvertUsersFile {
        public void convert() {
            String javaHome = System.getProperty("java.home");
            String[] command = new String[]{javaHome + File.separator + "bin" + File.separator + "javaw", "-jar", "convertUsersFile.jar"};
            try {
                Process process = Runtime.getRuntime().exec(command);
                StreamReader errorGobbler = new StreamReader(process.getErrorStream(), SrLogCategories.ERROR);
                StreamReader outputGobbler = new StreamReader(process.getInputStream(), SrLogCategories.INFORMATIVE);
                errorGobbler.start();
                outputGobbler.start();
                theLogger.info(SrLogCategories.INFORMATIVE, "Users file converting in progress...");
                try {
                    int exitVal = process.waitFor();
                    String completed = exitVal == 0 ? "SUCCESS" : "FAILED";
                    theLogger.info(SrLogCategories.INFORMATIVE, "Users file converting completed (" + completed + " exit value: " + exitVal + ")");
                }
                catch (InterruptedException ie) {
                    theLogger.error(SrLogCategories.EXCEPTION, ie, new Object[0]);
                }
            }
            catch (IOException ioe) {
                theLogger.error(SrLogCategories.EXCEPTION, ioe, new Object[0]);
            }
        }
    }

    private class StreamReader
    extends Thread {
        private InputStream myInputStream;
        private SrLogCategories myCategory;

        public StreamReader(InputStream inputStream, SrLogCategories aCategory) {
            this.myInputStream = inputStream;
            this.myCategory = aCategory;
        }

        @Override
        public void run() {
            InputStreamReader reader = new InputStreamReader(this.myInputStream);
            BufferedReader br = new BufferedReader(reader);
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    if (this.myCategory.equals(SrLogCategories.ERROR)) {
                        theLogger.error(this.myCategory, line);
                        continue;
                    }
                    theLogger.info(this.myCategory, line);
                }
            }
            catch (IOException ioe) {
                theLogger.error(SrLogCategories.EXCEPTION, ioe, new Object[0]);
            }
        }
    }
}

