/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.user;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserEvent;
import com.sanrad.nms.server.user.UserListener;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.security.StringCodec;
import com.sanrad.util.SrEventListenerManager;
import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class UserImpl
extends UnicastRemoteObject
implements User {
    private String username;
    private String password;
    private static SrLogger theLogger = SrLogger.getLogger();
    @Deprecated
    private Vector listeners = new Vector();
    private transient SrEventListenerManager m_listeners;
    private transient SrEventListenerManager.Informer<UserListener, UserEvent> userChangedInformer;

    public UserImpl(String username, String password) throws RemoteException {
        this(username, password, true);
    }

    public UserImpl(String username, String password, boolean decrypt) throws RemoteException {
        this.initTransientProperties();
        this.username = username;
        if (decrypt) {
            this.setPassword(password);
        } else {
            this.password = password;
        }
    }

    private void initTransientProperties() {
        this.m_listeners = new SrEventListenerManager();
        this.userChangedInformer = new SrEventListenerManager.Informer<UserListener, UserEvent>(){

            @Override
            public void inform(UserListener listener, UserEvent event) {
                listener.userChanged(event);
            }
        };
    }

    private Object readResolve() throws ObjectStreamException {
        this.initTransientProperties();
        return this;
    }

    public static String getCodecKey() {
        String codecKey = ErrorMessage.ALIAS_ALREADY_IN_USE.getMessage(UserManagerImpl.DEFAULT_USER);
        return codecKey;
    }

    public static String getCodePassword(String codeKey, String password) {
        return StringCodec.encryptString(codeKey, password);
    }

    public static String getCodePassword(String password) {
        return UserImpl.getCodePassword(UserImpl.getCodecKey(), password);
    }

    public static String getDecodePassword(String codeKey, String password) {
        return StringCodec.decryptString(codeKey, password);
    }

    public static String getDecodePassword(String password) {
        return UserImpl.getDecodePassword(UserImpl.getCodecKey(), password);
    }

    @Override
    public void changePassword(String oldPassword, String newPassword) throws RemoteException, IllegalValueException {
        String decodeNewPassword = UserImpl.getDecodePassword(newPassword);
        String decodeOldPassword = UserImpl.getDecodePassword(oldPassword);
        if (!decodeOldPassword.equals(this.password)) {
            String msg = "User " + this.username + ": wrong password.";
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        if (decodeOldPassword.equals(decodeNewPassword)) {
            String msg = "User " + this.username + ": new password should be different from old password.";
            theLogger.trace(SrLogCategories.LEGACY, msg);
            throw new IllegalValueException(msg);
        }
        this.setPassword(newPassword);
        this.fireUserChanged();
    }

    private void setPassword(String password) throws RemoteException {
        this.password = UserImpl.getDecodePassword(password);
    }

    public void addUserListener(UserListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeUserListener(UserListener listener) {
        this.m_listeners.remove(listener);
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() throws RemoteException {
        return this.username;
    }

    private void fireUserChanged() {
        UserEvent event = new UserEvent(this);
        this.m_listeners.fireEvent(UserListener.class, event, this.userChangedInformer);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UserImpl) {
            String objUsername = ((UserImpl)obj).username;
            String objPassword = ((UserImpl)obj).password;
            return objUsername.equals(this.username) && objPassword.equals(this.password);
        }
        return false;
    }

    @Override
    public String hashKey() throws RemoteException {
        return "USERIMPL";
    }
}

