/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.volume.MirrVolConfigElementData;
import com.sanrad.nms.server.mgr.volume.MirrorVolumeSyncConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeOperationAdminStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.SrDebugLogObject;
import com.sanrad.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class VolumeOperationConfigurator
extends ElementConfigurator {
    static Integer[] lastOperIndex = new Integer[0];
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final ArrayList<VolumeOperationAdminStatusConstant> copyOperAdminStatusList = new ArrayList();

    public VolumeOperationConfigurator() {
        super(ClassID.COPY_OPERATION, "srVirtVolOperTable", MibItem.VOLUME_OPERATION_RS, MibItem.VOLUME_OPERATION_TBL_LAST_UPDATE);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_DST, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_OPER_STATUS, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_PERCENTAGE_COPIED, null);
        paramList.put(ParameterCode.VOLUME_OPERATION_SRC, null);
        return paramList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOperIndex(Integer operIndex, char agentIndex) {
        Integer[] integerArray = lastOperIndex;
        synchronized (lastOperIndex) {
            if (lastOperIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastOperIndex, 0, newArray, 0, lastOperIndex.length);
                newArray[agentIndex] = operIndex;
                lastOperIndex = newArray;
            } else if (lastOperIndex[agentIndex] == null || operIndex > lastOperIndex[agentIndex]) {
                VolumeOperationConfigurator.lastOperIndex[agentIndex] = operIndex;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOperIndex(char agentIndex) throws SrCommException {
        Integer[] integerArray = lastOperIndex;
        synchronized (lastOperIndex) {
            if (lastOperIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastOperIndex, 0, newArray, 0, lastOperIndex.length);
                lastOperIndex = newArray;
            }
            VolumeOperationConfigurator.lastOperIndex[agentIndex] = new Integer(0);
            this.getAllAndRemoveIfNeed(agentIndex, false);
            Integer lastIndex = lastOperIndex[agentIndex];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return lastIndex + 1;
        }
    }

    @Override
    public ConfigElementDataList getAll(char agentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData allCommKeysList) throws SrCommException {
        return this.getAllAndRemoveIfNeed(agentIndex, true);
    }

    public ConfigElementDataList getAllAndRemoveIfNeed(char agentIndex, boolean removeIfNeed) throws SrCommException {
        CommVarBindList[] table = this.commGetAll(this.myTableName, agentIndex);
        if (table != null) {
            ConfigElementDataList tableOfElements = new ConfigElementDataList();
            int numOfRows = table.length;
            for (int i = 0; i < numOfRows; ++i) {
                ConfigElementData element = this.createConfigElementFromTableRow(table[i], agentIndex);
                Object operType = element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
                if (operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY || operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME || operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE || operType == VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_RESTORE) {
                    tableOfElements.add(element);
                    continue;
                }
                if (!removeIfNeed) continue;
                this.internalRemove(element);
            }
            return tableOfElements;
        }
        return null;
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        ConfigElementDataList elementsList = this.getAllExtended(vSwitchData.getMyFirstSnmpAgentIndex(), null, null);
        this.sendDiscoveredElementsToEventMgr(elementsList, vSwitchData);
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList elementsList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (elementsList != null) {
            Iterator itr = elementsList.iterator();
            while (itr.hasNext()) {
                ConfigElementData copyOper = (ConfigElementData)itr.next();
                CommKeyClassId src = (CommKeyClassId)copyOper.getValue(ParameterCode.VOLUME_OPERATION_SRC);
                CommKeyClassId dst = (CommKeyClassId)copyOper.getValue(ParameterCode.VOLUME_OPERATION_DST);
                VolumeOperationOperStatusConstant copyOperStatus = (VolumeOperationOperStatusConstant)copyOper.getValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
                boolean isOperOperatingOrWaiting = copyOperStatus.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_OPERATING) || copyOperStatus.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_WAITING);
                VolumeOperationAdminStatusConstant adminStatus = (VolumeOperationAdminStatusConstant)copyOper.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
                boolean isOperAbortedAndEndedOk = adminStatus.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY) && copyOperStatus.equals(VolumeOperationOperStatusConstant.VOLUME_OPERATION_OPER_END_OK);
                char agentIndex = copyOper.getSnmpAgentFromParameter();
                if (copyOperAdminStatusList.contains(adminStatus)) continue;
                itr.remove();
            }
            MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
            elementsList.addAll(mirrSyncConfig.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement));
        }
        return elementsList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        SrType srcVolId;
        String key = element.getSnmpKey().toString();
        int index = key.indexOf(".");
        if (index > -1) {
            theLogger.warn(SrLogCategories.LEGACY, "readDiscoverPostOperation of VolumeOperationConfigurator - snmp key is not a number! key is: ", key);
            key = key.substring(index + 1);
            theLogger.warn(SrLogCategories.LEGACY, "readDiscoverPostOperation of VolumeOperationConfigurator - snmp key is not a number! manipulated key is: ", key);
        }
        Integer operIndex = new Integer(key);
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        this.setOperIndex(operIndex, agentIndex);
        VolumeOperationAdminStatusConstant adminStat = (VolumeOperationAdminStatusConstant)list.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (adminStat == null) {
            adminStat = (VolumeOperationAdminStatusConstant)element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        }
        VolumeOperationType operType = null;
        if (adminStat != null) {
            operType = this.getVolOperFromAdminStat(adminStat);
            element.setValue(ParameterCode.COPY_OPERATION_TYPE, operType);
        }
        if ((srcVolId = VolumeOperationConfigurator.getVarBindValueFromList(list, MibItem.VOLUME_OPERATION_FROM)) != null) {
            CommKeyClassId srcVolData = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(list.getSnmpAgentIndex(), "1." + ((Object)srcVolId).toString());
            if (srcVolData == null) {
                srcVolData = new CommKeyClassId(new SnmpCommKey("1." + ((Object)srcVolId).toString(), list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcVolData);
        }
        SrType dstVolId = VolumeOperationConfigurator.getVarBindValueFromList(list, MibItem.VOLUME_OPERATION_TO);
        if (srcVolId != null) {
            CommKeyClassId dstVolData = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(list.getSnmpAgentIndex(), "1." + ((Object)dstVolId).toString());
            if (dstVolData == null) {
                dstVolData = new CommKeyClassId(new SnmpCommKey("1." + ((Object)dstVolId).toString(), list.getSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_DST, dstVolData);
        }
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        VolumeOperationType operType = (VolumeOperationType)element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            element.removeParameter(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
            MirrorVolumeSyncConfigurator mirrConfig = new MirrorVolumeSyncConfigurator();
            mirrConfig.internalChange(element);
            mirrConfig.readAfterCreate(element);
        } else if (operType.isAbortRestore()) {
            ConfigElementData readElement = new ConfigElementData(element.getCommKeyClassId());
            readElement.addParameter(new Parameter(ParameterCode.VOLUME_OPERATION_OPER_STATUS));
            this.internalReadFields(readElement);
            VolumeOperationOperStatusConstant operStatus = (VolumeOperationOperStatusConstant)readElement.getValue(ParameterCode.VOLUME_OPERATION_OPER_STATUS);
            if (operStatus != null && operStatus.isActive()) {
                element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, this.getAdminStatFromOperType(operType));
                super.internalChange(element);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    theLogger.logAndAssert(SrLogCategories.EXCEPTION, ie);
                }
                this.readAfterChange(element);
            } else {
                element.removeAll();
                this.readAfterChange(readElement);
                element.addParameter(readElement.getParametersList());
            }
        } else {
            element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, this.getAdminStatFromOperType(operType));
            super.internalChange(element);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, ie);
            }
            this.readAfterChange(element);
        }
        theLogger.info(SrLogCategories.LEGACY, "Operation was Changed ", operType);
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)this);
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        VolumeOperationType operType = (VolumeOperationType)element.getValue(ParameterCode.COPY_OPERATION_TYPE);
        if (operType != null) {
            if (operType.isMirrSyncOper()) {
                MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
                mirrSyncConfig.internalRemove(element);
                return;
            }
            if (operType.isOfflineCopy()) {
                this.removeCopyOper(element);
                return;
            }
            if (operType.isRestore()) {
                this.removeRestoreOper(element);
                return;
            }
        }
        super.internalRemove(element);
    }

    private void removeCopyOper(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId srcVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dstVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        super.internalRemove(element);
    }

    public void removeRestoreOper(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId srcVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dstVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        super.internalRemove(element);
    }

    private CommKeyClassId getVolumeData(CommKeyClassId volOrStorage, char agentIndex) {
        if (volOrStorage.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || volOrStorage.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            String volId = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, volOrStorage);
            if (volId == null) {
                return null;
            }
            if (volId.indexOf(".") < 0) {
                volId = "1." + volId;
            }
            return new CommKeyClassId(new SnmpCommKey(volId, agentIndex), ClassID.GENERAL_VOLUME);
        }
        return CommKeyUtil.getSpecificCommKeyClassId(volOrStorage, agentIndex);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        SimpleVolumeConfigurator simpleCnf;
        Object operType = element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
            element.removeParameter(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
            mirrSyncConfig.internalCreate(element);
            return;
        }
        char agentIndex = element.getSnmpAgentFromParameter();
        Integer newIndex = new Integer(this.getNextOperIndex(agentIndex));
        element.setCommKey(new SnmpCommKey(newIndex.toString(), agentIndex));
        CommKeyClassId src = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        String srcVolId = null;
        String dstVolId = null;
        boolean srcSimpleWasCreated = false;
        boolean dstSimpleWasCreated = false;
        if (src.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || src.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            srcVolId = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, src);
            if (srcVolId == null) {
                simpleCnf = new SimpleVolumeConfigurator();
                SnmpCommKey srcCommKey = simpleCnf.createSimpleVolume(src, vSwitch);
                srcVolId = srcCommKey.getKey();
                srcSimpleWasCreated = true;
            }
        } else {
            srcVolId = CommKeyUtil.getSpecificSnmpKey(src, agentIndex).getKey();
        }
        if (srcVolId.indexOf(".") >= 0) {
            srcVolId = srcVolId.substring(srcVolId.indexOf(".") + 1);
        }
        element.setValue(ParameterCode.VOLUME_OPERATION_SRC, new SrInteger(srcVolId));
        if (dst != null) {
            if (dst.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || dst.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                dstVolId = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, dst);
                if (dstVolId == null) {
                    simpleCnf = new SimpleVolumeConfigurator();
                    SnmpCommKey dstCommKey = simpleCnf.createSimpleVolume(dst, vSwitch);
                    dstVolId = dstCommKey.getKey();
                    dstSimpleWasCreated = true;
                }
            } else {
                dstVolId = CommKeyUtil.getSpecificSnmpKey(dst, agentIndex).getKey();
            }
            if (dstVolId.indexOf(".") >= 0) {
                dstVolId = dstVolId.substring(dstVolId.indexOf(".") + 1);
            }
            element.setValue(ParameterCode.VOLUME_OPERATION_DST, new SrInteger(dstVolId));
        }
        try {
            super.internalCreate(element);
        }
        catch (SrCommException e) {
            theLogger.error(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
            SimpleVolumeConfigurator simpleCnf2 = new SimpleVolumeConfigurator();
            if (srcSimpleWasCreated) {
                simpleCnf2.removeSimpleVolume(srcVolId, agentIndex);
            }
            if (dstSimpleWasCreated) {
                simpleCnf2.removeSimpleVolume(dstVolId, agentIndex);
            }
            throw e;
        }
    }

    public void operate(ConfigElementData element, VolumeOperationType operType) throws SrCommException {
        element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, operType);
        if (element.getClassId().equals(ClassID.COPY_OPERATION)) {
            element.setValue(ParameterCode.COPY_OPERATION_TYPE, operType);
            this.internalChange(element);
            return;
        }
        if (operType.equals(VolumeOperationType.VOL_OPER_ADD_MIRROR)) {
            this.addMirror(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_COPY)) {
            this.abortCopy(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_BREAK_MIRROR)) {
            this.breakMirror(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_EXPAND)) {
            this.expandVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_OFFLINE_COPY)) {
            this.offlineCopy(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_REPLACE_VOLUME)) {
            this.replaceVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RESIZE)) {
            this.resizeVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RETRACT)) {
            this.retractVolume(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ADD_CHILD)) {
            this.addChild(element, element.getClassId());
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_MIRROR_SYNC) || operType.equals(VolumeOperationType.VOL_OPER_MIRROR_SYNC)) {
            MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
            mirrSyncConfig.operate(element, operType);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RESTORE)) {
            this.restore(element);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            this.abortRestore(element);
        }
    }

    public void postOperate(ConfigElementData element, VolumeOperationType operType) throws SrCommException {
        if (operType.equals(VolumeOperationType.VOL_OPER_BREAK_MIRROR)) {
            char snmpAgent = element.getMyFirstSnmpAgentIndex();
            CommKeyClassId vswitchData = CommKeyUtil.getVSwitchData(snmpAgent);
            CheckListConfigElementData checkList = new CheckListConfigElementData(ClassID.COPY_OPERATION, new ArrayList<CommKeyClassId>());
            checkList.setValue(ParameterCode.VSWITCH_ID, vswitchData);
            MirrorVolumeSyncConfigurator mirrVolOperationConfigurator = new MirrorVolumeSyncConfigurator();
            ConfigElementDataList elements = mirrVolOperationConfigurator.refreshTable(snmpAgent, null, checkList);
            SrEventHandler.getEventMgr().sendRefreshElementEvent(elements, (Object)this);
            SrEventHandler.getEventMgr().sendCheckListEvent(checkList, this);
        } else if (operType.equals(VolumeOperationType.VOL_OPER_EXPAND) && element.getClassId().equals(ClassID.MIRROR_VOLUME)) {
            ConfigElementData newElement = new ConfigElementData(element.getCommKeyClassId());
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_ACTUAL_NUM_OF_BLOCKS, (SrType)null);
            newElement.setValue(ParameterCode.VIRTUAL_VOLUME_POTENTIAL_NUM_OF_BLOCKS, (SrType)null);
            this.internalReadFields(newElement);
            SrEventHandler.getEventMgr().sendReadElementEvent(newElement, this);
        }
    }

    private ConfigElementData upgradeVolume(ConfigElementData element, ClassID newVolType) throws SrCommException {
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        SrString newVolAlias = (SrString)element.getValue(ParameterCode.VOLUME_ALIAS);
        ConfigElementData newVol = element instanceof MirrVolConfigElementData ? new MirrVolConfigElementData(newVolType, vSwitchData, ((MirrVolConfigElementData)element).getAutoSync()) : new ConfigElementData(newVolType);
        newVol.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        newVol.setValue(ParameterCode.VOLUME_ALIAS, newVolAlias);
        ElementConfigurator volConfig = DataMgrAOImpl.getElementConfigFromClassID(newVolType);
        volConfig.internalCreate(newVol);
        CommKeyClassId newVolData = new CommKeyClassId(newVol.getCommKey(), newVolType);
        CommKeyClassId oldVolData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
        oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, oldVolData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_DST, newVolData);
        oper.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_UPGRADE);
        SrInteger formerParentId = this.getParentId(oper, ParameterCode.VOLUME_OPERATION_SRC);
        try {
            this.internalCreate(oper);
        }
        catch (SrCommException e) {
            if (!this.checkUpgradeSuccess(oper, formerParentId)) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
                volConfig.internalRemove(newVol);
            }
            theLogger.error(SrLogCategories.INFORMATIVE, e, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, bottom line success.", element));
        }
        try {
            volConfig.readAfterCreate(newVol);
        }
        catch (SrCommException e) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "NOT rolling back after: ", e.getMessage());
        }
        Parameter parentsChildren = null;
        Parameter newVolParent = null;
        CommKeyClassId parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
        if (parentData != null) {
            CommKeyClassId[] parentChildren = (CommKeyClassId[])element.getValue(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN);
            CommKeyClassId[] newChildrenList = new CommKeyClassId[parentChildren.length];
            for (int i = 0; i < parentChildren.length; ++i) {
                newChildrenList[i] = parentChildren[i].equals(oldVolData) ? newVolData : parentChildren[i];
            }
            parentsChildren = new Parameter(ParameterCode.VOLUME_CHILDREN, newChildrenList);
            newVolParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_PARENT, parentData);
        } else {
            parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_LU);
            if (parentData != null) {
                parentsChildren = new Parameter(ParameterCode.LU_VOLUME_ID, newVolData);
            }
            newVolParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_LU, parentData);
        }
        CommKeyClassId[] childData = new CommKeyClassId[]{oldVolData};
        newVol.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childData));
        newVol.addParameter(newVolParent);
        SrEventHandler.getEventMgr().sendAddElementEvent(newVol, (Object)this);
        ConfigElementData oldVol = new ConfigElementData(oldVolData);
        oldVol.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, newVolData);
        oldVol.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        SrEventHandler.getEventMgr().sendChangeElementEvent(oldVol, (Object)this);
        this.readVolumePosition(childData, newVolData);
        if (parentData != null) {
            ConfigElementData parentElement = new ConfigElementData(parentData.getCommKeys(), parentData.getClassID());
            parentElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
            parentElement.addParameter(parentsChildren);
            SrEventHandler.getEventMgr().sendChangeElementEvent(parentElement, (Object)this);
        }
        theLogger.info(SrLogCategories.LEGACY, "Volume ", oldVolData.getClassID(), " Was upgraded to ", newVolAlias);
        return newVol;
    }

    private boolean checkUpgradeSuccess(ConfigElementData aOperationCed, SrInteger aFormerParentId) throws SrCommException {
        SrInteger currentParentId = this.getParentId(aOperationCed, ParameterCode.VOLUME_OPERATION_SRC);
        return !Util.equalsWithNull(currentParentId, aFormerParentId);
    }

    private boolean checkAddChildSuccess(ConfigElementData aOperationCed) throws SrCommException {
        return this.getParentId(aOperationCed, ParameterCode.VOLUME_OPERATION_DST) != null;
    }

    private SrInteger getParentId(ConfigElementData aOperationCed, ParameterCode aChildIdCode) throws SrCommException {
        SrType[] parentId;
        SrType childId = (SrType)aOperationCed.getValue(aChildIdCode);
        if (childId instanceof CommKeyClassId) {
            String oidIndex = ((CommKeyClassId)childId).getSnmpCommKey().getKey();
            childId = new SrInteger(oidIndex.substring(oidIndex.lastIndexOf(46) + 1));
        }
        if ((parentId = this.readTableCells("1." + childId, aOperationCed.getSnmpAgentFromParameter(), MibItem.VIRTUAL_VOLUME_PARENT_ID)).length > 0) {
            return (SrInteger)parentId[0];
        }
        return null;
    }

    private void resizeVolume(ConfigElementData element) throws SrCommException {
        if (element.getClassId().equals(ClassID.CONCAT_VOLUME)) {
            this.addChild(element, ClassID.CONCAT_VOLUME);
        } else {
            this.addChild(element, ClassID.CUBE_VOLUME);
        }
    }

    private void addMirror(ConfigElementData element) throws SrCommException {
        this.addChild(element, ClassID.MIRROR_VOLUME);
    }

    private void addChild(ConfigElementData element, ClassID parentType) throws SrCommException {
        CommKeyClassId[] parentVolChildren;
        char agentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        CommKeyClassId parentVol = null;
        ConfigElementData parentVolElement = null;
        if (!element.getClassId().equals(parentType)) {
            parentVolElement = this.upgradeVolume(element, parentType);
            parentVol = new CommKeyClassId(parentVolElement.getCommKey(), parentVolElement.getClassId());
        } else {
            parentVol = new CommKeyClassId(element.getCommKey(), element.getClassId());
            parentVolElement = element;
        }
        CommKeyClassId newChild = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
        oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, parentVol);
        oper.setValue(ParameterCode.VOLUME_OPERATION_DST, newChild);
        oper.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ADD_CHILD);
        try {
            this.internalCreate(oper);
        }
        catch (SrCommException e) {
            if (!this.checkAddChildSuccess(oper)) {
                throw e;
            }
            theLogger.error(SrLogCategories.INFORMATIVE, e, new SrDebugLogObject("ERROR HANDLING, silently dropping failure, bottom line success.", element));
        }
        CommKeyClassId childVolData = this.getVolumeData(newChild, agentIndex);
        ConfigElementData chilVolElement = new ConfigElementData(childVolData);
        ElementConfigurator config = DataMgrAOImpl.getElementConfigFromClassID(childVolData.getClassID());
        chilVolElement.addParameter(config.getListOfParams());
        chilVolElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        config.internalRead(chilVolElement);
        chilVolElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, parentVol);
        chilVolElement.setCommKeyClassId(newChild);
        SrEventHandler.getEventMgr().sendChangeElementEvent(chilVolElement, (Object)this);
        ConfigElementData volElement = new ConfigElementData(parentVol.getCommKeys(), parentVol.getClassID());
        volElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        CommKeyClassId[] parentVolNewChildrenList = parentVolChildren = (CommKeyClassId[])parentVolElement.getValue(ParameterCode.VOLUME_CHILDREN);
        boolean alreadyExist = false;
        for (int i = 0; i < parentVolChildren.length; ++i) {
            if (!newChild.equals(parentVolChildren[i])) continue;
            alreadyExist = true;
            break;
        }
        if (!alreadyExist) {
            parentVolNewChildrenList = new CommKeyClassId[parentVolChildren.length + 1];
            System.arraycopy(parentVolChildren, 0, parentVolNewChildrenList, 0, parentVolChildren.length);
            parentVolNewChildrenList[parentVolChildren.length] = newChild;
        }
        volElement.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, parentVolNewChildrenList));
        theLogger.info(SrLogCategories.LEGACY, "Add Child:  ", newChild.getClassID(), " to: ", parentVol.getClassID());
        ConfigElementData syncCed = null;
        if (element instanceof MirrVolConfigElementData && ((MirrVolConfigElementData)element).getAutoSync()) {
            MirrorVolumeSyncConfigurator mirSyncCfg = new MirrorVolumeSyncConfigurator();
            syncCed = new ConfigElementData(newChild.getClassID());
            syncCed.setCommKeyClassId(newChild);
            syncCed.addParameter(ParameterCode.VSWITCH_ID, vSwitchData);
            syncCed.addParameter(ParameterCode.VOLUME_OPERATION_SRC, ((MirrVolConfigElementData)element).getValue(ParameterCode.VOLUME_OPERATION_SRC));
            syncCed.addParameter(ParameterCode.VOLUME_OPERATION_DST, newChild);
            syncCed.addParameter(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationType.VOL_OPER_MIRROR_SYNC);
            CommKeyClassId cedActiveVS = ((MirrVolConfigElementData)element).getActiveVswitch();
            CommKeyClassId syncCedVS = syncCed.getVswitchId();
            if (cedActiveVS == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "There is no active VS in the mirror CED: ", element);
            } else if (cedActiveVS.equals(syncCedVS)) {
                mirSyncCfg.operate(element, VolumeOperationType.VOL_OPER_MIRROR_SYNC);
            } else {
                theLogger.trace(SrLogCategories.INFORMATIVE, "The sync operation for mirror ", element, " is not performed by the vs ", syncCedVS, " because the active VS is ", cedActiveVS);
            }
        }
        this.readVolumePosition(parentVolNewChildrenList, parentVolElement.getCommKeyClassId());
        SrEventHandler.getEventMgr().sendChangeElementEvent(volElement, (Object)this);
        if (syncCed != null) {
            SrEventHandler.getEventMgr().sendAddElementEvent(syncCed, (Object)this);
        }
    }

    private void breakMirror(ConfigElementData element) throws SrCommException {
        this.removeChildren(element);
    }

    private void retractVolume(ConfigElementData element) throws SrCommException {
        this.removeChildren(element);
    }

    private void removeChildren(ConfigElementData element) throws SrCommException {
        CommKeyClassId parentVolData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        CommKeyClassId[] childrenToRemove = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId[] allVolumeChildren = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        ArrayList<CommKeyClassId> allChildren = new ArrayList<CommKeyClassId>(Arrays.asList(allVolumeChildren));
        ConfigElementDataList childrenToRemoveElements = new ConfigElementDataList();
        for (int i = 0; i < childrenToRemove.length; ++i) {
            CommKeyClassId currentChild = childrenToRemove[i];
            allChildren.remove(currentChild);
            ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
            oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REMOVE_CHILD);
            oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, parentVolData);
            oper.setValue(ParameterCode.VOLUME_OPERATION_DST, currentChild);
            oper.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            this.internalCreate(oper);
            this.internalRemove(oper);
            ConfigElementData currChildElement = new ConfigElementData(currentChild);
            currChildElement.setValue(ParameterCode.VOLUME_POSITION, (SrType)null);
            currChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)null);
            currChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            childrenToRemoveElements.add(currChildElement);
        }
        ConfigElementData parentNewData = new ConfigElementData(parentVolData.getCommKeys(), parentVolData.getClassID());
        CommKeyClassId[] childrenNewList = new CommKeyClassId[allChildren.size()];
        allChildren.toArray(childrenNewList);
        parentNewData.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, childrenNewList));
        parentNewData.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        SrEventHandler.getEventMgr().sendChangeElementEvent(parentNewData, (Object)this);
        SrEventHandler.getEventMgr().sendChangeElementEvent(childrenToRemoveElements, (Object)this);
        boolean elementWasRemoved = false;
        if (allChildren.size() == 1) {
            element.setValue(ParameterCode.VOLUME_CHILDREN, allChildren.get(0));
            elementWasRemoved = this.downgrade(element);
        }
        if (!elementWasRemoved) {
            this.readVolumePosition(childrenNewList, parentVolData);
        }
        theLogger.info(SrLogCategories.LEGACY, "Remove Child to:  ", parentVolData.getClassID());
    }

    private boolean downgrade(ConfigElementData element) throws SrCommException {
        boolean wasRemoved = false;
        CommKeyClassId lastChild = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_CHILDREN);
        CommKeyClassId volData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        CommKeyClassId vSwitch = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        ConfigElementData downgrade = new ConfigElementData(ClassID.VOLUME_OPERATION);
        downgrade.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_DOWNGRADE);
        downgrade.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        downgrade.setValue(ParameterCode.VOLUME_OPERATION_SRC, lastChild);
        downgrade.setValue(ParameterCode.VOLUME_OPERATION_DST, volData);
        this.internalCreate(downgrade);
        this.internalRemove(downgrade);
        Parameter parentsChildren = null;
        Parameter lastChildNewParent = new Parameter(ParameterCode.LU_VOLUME_ID, null);
        CommKeyClassId parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
        if (parentData != null) {
            CommKeyClassId[] parentChildren = (CommKeyClassId[])element.getValue(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN);
            CommKeyClassId[] newChildrenList = new CommKeyClassId[parentChildren.length];
            for (int i = 0; i < parentChildren.length; ++i) {
                newChildrenList[i] = parentChildren[i].equals(volData) ? lastChild : parentChildren[i];
            }
            parentsChildren = new Parameter(ParameterCode.VOLUME_CHILDREN, newChildrenList);
            lastChildNewParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_PARENT, parentData);
        } else {
            parentData = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_LU);
            if (parentData != null) {
                parentsChildren = new Parameter(ParameterCode.LU_VOLUME_ID, lastChild);
                lastChildNewParent = new Parameter(ParameterCode.VIRTUAL_VOLUME_LU, parentData);
            }
        }
        ConfigElementData lastChildElement = new ConfigElementData(lastChild);
        lastChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitch);
        if (parentData != null) {
            ConfigElementData parentElement = new ConfigElementData(parentData.getCommKeys(), parentData.getClassID());
            parentElement.setValue(ParameterCode.VSWITCH_ID, vSwitch);
            parentElement.addParameter(parentsChildren);
            SrEventHandler.getEventMgr().sendChangeElementEvent(parentElement, (Object)this);
            lastChildElement.addParameter(lastChildNewParent);
        } else {
            lastChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_LU, (SrType)null);
            lastChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)null);
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(lastChildElement, (Object)this);
        SrEventHandler.getEventMgr().sendRemoveElementEvent(element, this);
        theLogger.info(SrLogCategories.LEGACY, "Downgrade from:  ", volData.getClassID(), "to: ", lastChild.getClassID());
        return wasRemoved;
    }

    private void replaceVolume(ConfigElementData element) throws SrCommException {
        char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
        CommKeyClassId oldVol = new CommKeyClassId(element.getCommKey(), element.getClassId());
        CommKeyClassId newVol = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        ConfigElementData operation = new ConfigElementData(ClassID.VOLUME_OPERATION);
        operation.setValue(ParameterCode.VOLUME_OPERATION_SRC, oldVol);
        operation.setValue(ParameterCode.VOLUME_OPERATION_DST, newVol);
        operation.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        operation.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REPLACE_VOLUME);
        this.internalCreate(operation);
        this.internalRemove(operation);
        CommKeyClassId volParent = (CommKeyClassId)element.getValue(ParameterCode.VIRTUAL_VOLUME_PARENT);
        if (volParent == null) {
            throw new UnsupportedOperationException("Replace volume is Not supported to a head of volume's tree");
        }
        volParent = CommKeyUtil.getSpecificCommKeyClassId(volParent, snmpAgentIndex);
        ConfigElementData parent = new ConfigElementData(volParent);
        CommKeyClassId[] parentChildrenList = (CommKeyClassId[])element.getValue(ParameterCode.VIRTUAL_VOLUME_MY_PARENTS_CHILDREN);
        SrType[] newParentChildrenList = new CommKeyClassId[parentChildrenList.length];
        for (int i = 0; i < parentChildrenList.length; ++i) {
            newParentChildrenList[i] = oldVol.equals(parentChildrenList[i]) ? newVol : parentChildrenList[i];
        }
        parent.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        parent.setValues(ParameterCode.VOLUME_CHILDREN, newParentChildrenList);
        SrEventHandler.getEventMgr().sendChangeElementEvent(parent, (Object)this);
        ConfigElementData oldChildElement = new ConfigElementData(oldVol);
        oldChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        oldChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, (SrType)null);
        oldChildElement.setValue(ParameterCode.VOLUME_POSITION, (SrType)null);
        SrEventHandler.getEventMgr().sendChangeElementEvent(oldChildElement, (Object)this);
        ConfigElementData newChildElement = new ConfigElementData(newVol);
        newChildElement.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
        newChildElement.setValue(ParameterCode.VIRTUAL_VOLUME_PARENT, volParent);
        SrEventHandler.getEventMgr().sendChangeElementEvent(newChildElement, (Object)this);
        CommKeyClassId[] newChildData = new CommKeyClassId[]{newVol};
        this.readVolumePosition(newChildData, volParent);
    }

    private void offlineCopy(ConfigElementData element) throws SrCommException {
        element.setClassId(ClassID.COPY_OPERATION);
        element.setCommKeys(null);
        element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME);
        this.internalCreate(element);
        this.readAfterCreate(element);
        CommKeyClassId src = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
        CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        char agentIndex = element.getSnmpAgentFromParameter();
        SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)this);
    }

    private void restore(ConfigElementData element) throws SrCommException {
        element.setClassId(ClassID.COPY_OPERATION);
        element.setCommKeys(null);
        element.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE);
        this.internalCreate(element);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, ie, "The sleeping thread was interrupted. The sleep itself is a patch.");
        }
        this.readAfterCreate(element);
        CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
        char agentIndex = element.getSnmpAgentFromParameter();
        SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)this);
    }

    private void abortCopy(ConfigElementData element) {
    }

    private void abortRestore(ConfigElementData element) {
    }

    private void expandVolume(ConfigElementData element) throws SrCommException {
        ConfigElementData oper = new ConfigElementData(ClassID.VOLUME_OPERATION);
        oper.setValue(ParameterCode.VSWITCH_ID, (SrType)element.getValue(ParameterCode.VSWITCH_ID));
        CommKeyClassId srcData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        oper.setValue(ParameterCode.VOLUME_OPERATION_SRC, srcData);
        oper.setValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS, VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_EXPAND_VOLUME);
        this.internalCreate(oper);
        this.internalRemove(oper);
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 5: {
                return MibItem.VOLUME_OPERATION_OPER_STATUS;
            }
            case 4: {
                return MibItem.VIRTUAL_VOLUME_MIRROR_SYNC_OPER_STATUS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        switch (trap.getTrapType().getTrapId()) {
            case 4: 
            case 5: {
                element.setClassId(ClassID.COPY_OPERATION);
                this.readDiscoverPostOperation(element, trap.getVarBindList());
                theLogger.trace(SrLogCategories.LEGACY, "Changed by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
            }
        }
    }

    private VolumeOperationAdminStatusConstant getAdminStatFromOperType(VolumeOperationType operType) {
        VolumeOperationAdminStatusConstant val = null;
        if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_COPY)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ADD_MIRROR)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ADD_CHILD;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_BREAK_MIRROR)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REMOVE_CHILD;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_EXPAND)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_EXPAND_VOLUME;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_OFFLINE_COPY)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_REPLACE_VOLUME)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_REPLACE_VOLUME;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_RESTORE)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE;
        } else if (operType.equals(VolumeOperationType.VOL_OPER_ABORT_RESTORE)) {
            val = VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_RESTORE;
        }
        return val;
    }

    private VolumeOperationType getVolOperFromAdminStat(VolumeOperationAdminStatusConstant adminStat) {
        if (adminStat == null) {
            return null;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME)) {
            return VolumeOperationType.VOL_OPER_OFFLINE_COPY;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY)) {
            return VolumeOperationType.VOL_OPER_ABORT_COPY;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_IDLE)) {
            return VolumeOperationType.VOL_OPER_NONE;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE)) {
            return VolumeOperationType.VOL_OPER_RESTORE;
        }
        if (adminStat.equals(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_RESTORE)) {
            return VolumeOperationType.VOL_OPER_ABORT_RESTORE;
        }
        return null;
    }

    @Override
    public ConfigElementDataList refreshTableFields(ConfigElementData fieldsData) throws SrCommException {
        MirrorVolumeSyncConfigurator mirrSyncConfig = new MirrorVolumeSyncConfigurator();
        ConfigElementDataList mirrSyncData = mirrSyncConfig.refreshTableFields(fieldsData);
        ConfigElementDataList tableOfElements = super.refreshTableFields(fieldsData);
        tableOfElements.addAll(mirrSyncData);
        return tableOfElements;
    }

    @Override
    public void postCreateOperation(ConfigElementData element) throws SrCommException {
        VolumeOperationAdminStatusConstant adminStatus = (VolumeOperationAdminStatusConstant)element.getValue(ParameterCode.VOLUME_OPERATION_ADMIN_STATUS);
        if (adminStatus != null) {
            VolumeConfigurator volumeConfigurator = new VolumeConfigurator();
            VolumeOperationType operType = this.getVolOperFromAdminStat(adminStatus);
            if (operType.isRestore()) {
                CommKeyClassId src = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_SRC);
                ConfigElementData srcVolumeElement = new ConfigElementData(src);
                volumeConfigurator.internalRead(srcVolumeElement);
                CommKeyClassId dst = (CommKeyClassId)element.getValue(ParameterCode.VOLUME_OPERATION_DST);
                ConfigElementData dstVolumeElement = new ConfigElementData(dst);
                volumeConfigurator.internalRead(dstVolumeElement);
                ConfigElementDataList list = new ConfigElementDataList();
                list.add(srcVolumeElement);
                list.add(dstVolumeElement);
                SrEventHandler.getEventMgr().sendRefreshElementEvent(element, (Object)this);
            }
        }
    }

    @Override
    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList elements = this.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        if (checkListElement == null) {
            checkListElement = new CheckListConfigElementData(ClassID.COPY_OPERATION);
        }
        this.buildCheckListElement(elements, checkListElement, snmpAgentIndex, null);
        checkListElement.setCheckList(elements.getAllCommkeyClassIDsInList());
        SrEventHandler.getEventMgr().sendRefreshElementEvent(elements, (Object)this);
        SrEventHandler.getEventMgr().sendCheckListEvent(checkListElement, this);
        return elements;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return VolumeOperationConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }

    static {
        copyOperAdminStatusList.add(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_ABORT_COPY);
        copyOperAdminStatusList.add(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_COPY_VOLUME);
        copyOperAdminStatusList.add(VolumeOperationAdminStatusConstant.VOLUME_OPERATION_ADMIN_STATUS_RESTORE);
    }
}

