/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeChildrenConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.RowStatusConstants;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;
import java.util.List;

public class VirtualVolumeConfigurator
extends VolumeConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    protected VirtualVolumeConfigurator(ClassID classId, String tableName, MibItem rs, VolumeTypeConstants volType) {
        super(classId, tableName, rs, volType);
    }

    protected VirtualVolumeConfigurator(ClassID classId, String tableName, MibItem rs, MibItem lastUpdateMib, VolumeTypeConstants volType) {
        super(classId, tableName, rs, lastUpdateMib, volType);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        CommKey[][] allChildrenCommKey = this.createVolumeNoAttachVolume(element);
        if (allChildrenCommKey != null) {
            this.attachVolumeToChildren(element, allChildrenCommKey);
            CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
            this.readVolumePosition(children, element.getCommKeyClassId());
        }
    }

    protected CommKey[][] createVolumeNoAttachVolume(ConfigElementData element) throws SrCommException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        CommKey[][] allChildrenCommKey = null;
        if (children != null) {
            int child;
            for (int i = 0; i < children.length; ++i) {
                SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(children[i].getCommKeys(), snmpAgentIndex);
                if (snmpKey != null) continue;
                throw new MissingValueException(element.getClassId().toString() + " Create - Missing Data of Children for Agent: " + CommKeyUtil.getIpFromIndex(snmpAgentIndex));
            }
            allChildrenCommKey = new CommKey[children.length][];
            CommKeyClassId vSwithcData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
            boolean error = false;
            Object commExp = null;
            for (child = 0; child < children.length && !error; ++child) {
                if (children[child].getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || children[child].getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
                    SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
                    allChildrenCommKey[child] = new CommKey[]{simpleCnf.createSimpleVolume(children[child], vSwithcData)};
                    continue;
                }
                allChildrenCommKey[child] = children[child].getCommKeys();
            }
            if (error) {
                this.removeMySimpleVolumeChildren(children, snmpAgentIndex, child);
                throw commExp;
            }
        }
        super.internalCreate(element);
        return allChildrenCommKey;
    }

    protected void attachVolumeToChildren(ConfigElementData element, CommKey[][] childrenData) throws SrCommException {
        block3: {
            SnmpCommKey parentKey = element.getSnmpKey();
            String parentIndex = parentKey.toString();
            CommVarBindList newChildrenList = new CommVarBindList();
            char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
            for (int i = 0; i < childrenData.length; ++i) {
                SnmpCommKey snmpKey = CommKeyUtil.getSpecificSnmpKey(childrenData[i], snmpAgentIndex);
                String childIndex = snmpKey.toString();
                String childId = childIndex.substring(childIndex.indexOf("."));
                SrOid oid = new SrOid(MibItem.VIRTUAL_VOLUME_CHILDREN_RS.toString(), parentIndex + childId);
                newChildrenList.add(new SrSnmpVarBind(oid, (SrType)RowStatusConstants.ROW_STATUS_CREATE_AND_GO));
            }
            try {
                this.commSetList(newChildrenList, snmpAgentIndex);
            }
            catch (SrCommException e) {
                theLogger.error(SrLogCategories.LEGACY, "Failed to attach volume to children: ", element, e.getMessage());
                if (this.isCreationInChildrenTableSucceed(newChildrenList, snmpAgentIndex)) break block3;
                throw e;
            }
        }
    }

    private boolean isCreationInChildrenTableSucceed(CommVarBindList aNewChildrenList, char aAgentIndex) throws SrCommException {
        List<CommVarBindList> listOfEntries = DsnmpUtil.breakVarBindListByIndices(aNewChildrenList);
        VolumeChildrenConfigurator volChildConf = new VolumeChildrenConfigurator();
        ConfigElementDataList allChildren = volChildConf.getAll(aAgentIndex, null, null);
        HashMap<SnmpCommKey, ElementData> existingElements = this.createMapFromList(allChildren);
        for (CommVarBindList sentPdu : listOfEntries) {
            theLogger.logAndAssert(SrLogCategories.ERROR, sentPdu.size() > 0, new Object[]{"Zero length CommVarBindList"});
            SnmpCommKey sentEntryIndex = new SnmpCommKey(((CommVarBind)sentPdu.get(0)).getVarBindKey().getIndex(), aAgentIndex);
            if (existingElements.containsKey(sentEntryIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        super.internalRemove(element);
        if (children != null) {
            ConfigElementDataList childrenData = new ConfigElementDataList();
            CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
            for (int i = 0; i < children.length; ++i) {
                ConfigElementData child = new ConfigElementData(children[i]);
                child.setValue(ParameterCode.VSWITCH_ID, vSwitchData);
                child.setValue(ParameterCode.VOLUME_POSITION, (SrType)null);
                childrenData.add(child);
            }
            SrEventHandler.getEventMgr().sendChangeElementEvent(childrenData, (Object)this);
        }
        VolumeOperationConfigurator volumeOperCfg = new VolumeOperationConfigurator();
        volumeOperCfg.refreshTable(element.getMyFirstSnmpAgentIndex(), null, new CheckListConfigElementData(ClassID.COPY_OPERATION));
    }

    protected void removeMySimpleVolumeChildren(CommKeyClassId[] children, char agentIndex, int endIndex) throws SrCommException {
        int lastIndexToRemove = endIndex;
        if (children != null && (endIndex > children.length || endIndex < 0)) {
            lastIndexToRemove = children.length;
        }
        for (int i = 0; i < lastIndexToRemove; ++i) {
            CommKeyClassId child = children[i];
            SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
            simpleCnf.removeSimpleVolume(child, agentIndex);
        }
    }

    @Override
    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
    }
}

