/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.VirtualVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;

public class StripeVolumeConfigurator
extends VirtualVolumeConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public StripeVolumeConfigurator() {
        super(ClassID.STRIPE_VOLUME, "srVirtVolSpecStrippedTable", MibItem.VIRTUAL_VOLUME_RS, VolumeTypeConstants.VOLUME_TYPE_STRIPE);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        Object stripSize = element.getValue(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
        if (stripSize == null) {
            throw new MissingValueException("Stripe Size is missing for the new volume");
        }
        element.removeParameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE);
        CommKey[][] allChildrenCommKey = this.createVolumeNoAttachVolume(element);
        element.addParameter(new Parameter(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, stripSize));
        ConfigElementData changeStripeSizeCED = new ConfigElementData(element.getCommKeyClassId());
        changeStripeSizeCED.setValue(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, (SrType)stripSize);
        this.internalChange(changeStripeSizeCED);
        this.attachVolumeToChildren(element, allChildrenCommKey);
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        this.readVolumePosition(children, element.getCommKeyClassId());
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = super.getListOfParams();
        paramList.put(ParameterCode.VIRTUAL_VOLUME_STRIPE_SIZE, null);
        return paramList;
    }
}

