/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.exception.SrConnectionException;
import com.sanrad.nms.server.comm.exception.SrUnknownException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.VirtualVolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.nms.server.util.types.constants.SnapshotConfigFlagsConstant;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;

public class SnapshotVolumeConfigurator
extends VirtualVolumeConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SnapshotVolumeConfigurator() {
        super(ClassID.SNAPSHOT_VOLUME, "srVirtVolSpecSnapshotTable", MibItem.VIRTUAL_VOLUME_RS, MibItem.VIRTUAL_VOLUME_MIRROR_TBL_LAST_UPDATE, VolumeTypeConstants.VOLUME_TYPE_SNAPSHOT);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        Object sourceId = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        Object threshold = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH);
        SnapshotConfigFlagsConstant flags = (SnapshotConfigFlagsConstant)element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS);
        CommKeyClassId vSwitchData = (CommKeyClassId)element.getValue(ParameterCode.VSWITCH_ID);
        if (sourceId == null) {
            throw new MissingValueException("Source volume is missing for the new Snapshot volume");
        }
        CommKeyClassId sourceData = (CommKeyClassId)sourceId;
        ClassID classId = sourceData.getClassID();
        String key = "";
        boolean simpleWasCreatedOverSource = false;
        if (classId.equals(ClassID.DIRECT_ACCESS_DEVICE) || classId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            int ind;
            key = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, sourceData);
            if (key == null) {
                SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
                SnmpCommKey commKey = simpleCnf.createSimpleVolume(sourceData, vSwitchData);
                key = commKey.getKey();
                simpleWasCreatedOverSource = true;
            }
            if ((ind = key.indexOf(".")) != -1) {
                key = key.substring(ind + 1);
            }
        } else {
            key = CommKeyUtil.getSpecificSnmpKey(sourceData.getCommKeys(), agentIndex).getKey();
            key = key.substring(key.indexOf(".") + 1);
        }
        Integer srcId = new Integer(key);
        try {
            super.internalCreate(element);
        }
        catch (SrCommException e) {
            if (simpleWasCreatedOverSource) {
                theLogger.error(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
                SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
                simpleCnf.removeSimpleVolume(sourceData, agentIndex);
            }
            throw e;
        }
        SrSnmpVarBindList list = new SrSnmpVarBindList();
        SnmpCommKey volumeKey = element.getSnmpKey();
        theLogger.logAndAssert(SrLogCategories.ERROR, volumeKey != null, new Object[]{"The comm key of the element ", element, " should not be null."});
        SrOid sourceOid = new SrOid(MibItem.SNAPSHOT_VOLUME_SOURCE.toString(), volumeKey.toString());
        SrSnmpVarBind sourceVarBind = new SrSnmpVarBind(sourceOid, (SrType)new SrInteger(srcId));
        list.add(sourceVarBind);
        if (threshold != null) {
            SrOid threshOid = new SrOid(MibItem.SNAPSHOT_VOLUME_PERCENT_THRESH.toString(), volumeKey.toString());
            SrSnmpVarBind threshVarBind = new SrSnmpVarBind(threshOid, (SrType)((SrInteger)threshold));
            list.add(threshVarBind);
        }
        if (flags != null) {
            Parameter tmpParam = new Parameter(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, flags);
            list.add(this.createCommVarBinds(element.getCommKey(), tmpParam));
        }
        try {
            this.commSetList(list, agentIndex);
        }
        catch (SrConnectionException e) {
            theLogger.error(SrLogCategories.ERROR, "Failed to set Source volume to Snapshot ", volumeKey.toDisplayString(), e.getMessage());
            SrString alias = (SrString)element.getValue(ParameterCode.VOLUME_ALIAS);
            throw new SrUnknownException(agentIndex, list, "Failed to monitor snapshot volume '" + alias + "' creation. Please rediscover to check operation success.");
        }
        catch (SrCommException e) {
            theLogger.error(SrLogCategories.ERROR, "Failed to set Source volume to Snapshot ", volumeKey.toDisplayString(), e.getMessage());
            if (simpleWasCreatedOverSource) {
                SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
                simpleCnf.removeSimpleVolumeIfNeed(sourceData, vSwitchData);
            }
            this.internalRemove(element);
            throw e;
        }
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, sourceId));
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, threshold));
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        Object value = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        super.readAfterCreate(element);
        element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, value));
        return false;
    }

    @Override
    public void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommException {
        SrInteger activationState;
        super.readDiscoverPostOperation(element, rowList);
        Object source = element.removeParameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        if (source != null) {
            String key = ((SrInteger)source).toString();
            key = "1." + key;
            CommKeyClassId commKeyClassId = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(element.getMyFirstSnmpAgentIndex(), key);
            if (commKeyClassId == null) {
                commKeyClassId = new CommKeyClassId(new SnmpCommKey(key, element.getMyFirstSnmpAgentIndex()), ClassID.GENERAL_VOLUME);
            }
            element.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, commKeyClassId));
        }
        Object activationVal = element.removeParameter(ParameterCode.SNAPSHOT_ACTIVATE);
        if (source != null && (activationState = (SrInteger)activationVal) != null) {
            SnapshotActivateTypeConstants av = activationState.equals(1) ? SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE : SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE;
            element.addParameter(new Parameter(ParameterCode.SNAPSHOT_ACTIVATE, av));
        }
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = super.getListOfParams();
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_DATE_AND_TIME, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_SOURCE, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_LOAD, null);
        paramList.put(ParameterCode.SNAPSHOT_ACTIVATE, null);
        paramList.put(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, null);
        return paramList;
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        try {
            super.trapProccessingPostOperation(element, trap);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        if (trap.getTrapType().getTrapId() == 35) {
            char agentIndex;
            String index = element.getSnmpKey().getKey();
            SrType[] val = this.readTableCells(index, agentIndex = element.getSnmpKey().getSnmpAgentIndex(), MibItem.SNAPSHOT_ACTIVATE);
            if (val[0] == null) {
                return;
            }
            SnapshotActivateTypeConstants av = val[0].equals(1) ? SnapshotActivateTypeConstants.SNAPSHOT_INACTIVE : SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE;
            element.addParameter(ParameterCode.SNAPSHOT_ACTIVATE, av);
        }
        if (trap.getTrapType().getTrapId() != 13 && trap.getTrapType().getTrapId() != 35) {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        ConfigElementData setFlagsCed = new ConfigElementData(element.getCommKeyClassId(), ConfigOperation.CHANGE);
        setFlagsCed.setValue(ParameterCode.SNAPSHOT_VOLUME_CONFIG_FLAGS, SnapshotConfigFlagsConstant.NONE);
        super.internalChange(setFlagsCed);
        super.internalRemove(element);
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 13: {
                return MibItem.SNAPSHOT_VOLUME_PERCENT_UTIL;
            }
            case 35: {
                return MibItem.SNAPSHOT_VOLUME_DATE_AND_TIME;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }
}

