/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import java.util.HashMap;

public class SnapshotSchedulerConfigurator
extends ElementConfigurator {
    private static HashMap<ParameterCodes, Object> theParamList = new HashMap();

    public SnapshotSchedulerConfigurator() {
        super(ClassID.SNAPSHOT_SCHEDULER, "srSnapshotSchedulerTable", MibItem.SNAPSHOT_SCHEDULER_ROW_STATUS, MibItem.SNAPSHOT_SCHEDULER_LAST_UPDATE);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return theParamList;
    }

    @Override
    public void internalCreate(ConfigElementData aElement) throws SrCommException {
        CommKeyClassId sourceVolKey = (CommKeyClassId)aElement.removeValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE);
        if (sourceVolKey.getClassID().isVolume()) {
            aElement.setCommKey(sourceVolKey.getSnmpCommKey());
        } else if (sourceVolKey.getClassID().isStorage()) {
            SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
            SnmpCommKey simpleVolumeKey = simpleCnf.createSimpleVolume(sourceVolKey, (CommKeyClassId)aElement.getValue(ParameterCode.VSWITCH_ID));
            aElement.setCommKey(simpleVolumeKey);
        }
        super.internalCreate(aElement);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return aElement.getCommKeyClassId();
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        CommKeyClassId id = element.getCommKeyClassId();
        SnmpCommKey snmpId = id.getSnmpCommKey();
        String index = snmpId.getKey();
        CommKeyClassId sourceVolId = VolumeConfigurator.getCkidByVolumeIndex(index, element.getMyFirstSnmpAgentIndex());
        element.setValue(ParameterCode.SNAPSHOT_VOLUME_SOURCE, sourceVolId);
    }

    static {
        theParamList.put(ParameterCode.SNAPSHOT_SCHEDULER_PERIOD, null);
        theParamList.put(ParameterCode.SNAPSHOT_SCHEDULER_SNAP_COUNT, null);
        theParamList.put(ParameterCode.SNAPSHOT_SCHEDULER_START_AT, null);
        theParamList.put(ParameterCode.SNAPSHOT_SCHEDULER_STATE, null);
        theParamList.put(ParameterCode.SNAPSHOT_SCHEDULER_SNAPSHOT_SIZE, null);
    }
}

