/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import junit.framework.TestCase;

public class SimpleVolumeMgrStripeTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateStripe1() {
        SubDirectAccessDeviceImpl clean2;
        SubDirectAccessDeviceImpl clean1;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrStripeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            String firstSimple = null;
            String secondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "stripe1", new BigInteger("5000"));
                if (stripe == null) {
                    SimpleVolumeMgrStripeTest.fail((String)"Could not create the stripe");
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrStripeTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
            if (stripe != null) {
                this.myTestUtils.removeStripe(this.myDefCluster, stripe);
            }
            clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block13: {
                if (stripe != null) {
                    this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                }
                SubDirectAccessDeviceImpl clean12 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl clean22 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(clean12);
                    this.myTestUtils.removeSubDisk(clean22);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(clean2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateStripe2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrStripeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("10000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("10000000"));
            String firstSimple = null;
            String secondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "testStipe", new BigInteger("5000"));
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrStripeTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeStripe(this.myDefCluster, stripe);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateStripe3() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrStripeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "source", new BigInteger("10000"));
            String firstSimple = null;
            String secondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{secondDisk.getCommKeyClassId(), sub1.getCommKeyClassId()};
                stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "stripe3", new BigInteger("5000"));
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrStripeTest.fail((String)"Could not find the simple volumes for the sub disk and the disk.");
            }
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block12: {
                try {
                    this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                    this.myTestUtils.removeSubDisk(sub1);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeStripe(this.myDefCluster, stripe);
            this.myTestUtils.removeSubDisk(sub1);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveStripe1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrStripeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            String firstSimple = null;
            String secondSimple = null;
            String newFirstSimple = null;
            String newSecondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "stripe1", new BigInteger("5000"));
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                newFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                newSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrStripeTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source disk should still have a simple volume over it after the stripe removal.", newFirstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target disk should still have a simple volume over it after the stripe removal.", newSecondSimple);
            SimpleVolumeMgrStripeTest.assertEquals((String)"The source simple volume should not change because of the stripe removal.", firstSimple, newFirstSimple);
            SimpleVolumeMgrStripeTest.assertEquals((String)"The target simple volume should not change because of the stripe removal.", secondSimple, newSecondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                    SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                    this.myTestUtils.removeSubDisk(clean2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the cleanup.");
                }
            }
            throw throwable;
        }
        try {
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(clean2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the cleanup.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveStripe2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrStripeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            String firstSimple = null;
            String secondSimple = null;
            String newFirstSimple = null;
            String newSecondSimple = null;
            try {
                sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("10000000"));
                sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("10000000"));
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "stripe1", new BigInteger("5000"));
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                newFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                newSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrStripeTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", secondSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source sub disk should still have a simple volume over it after the stripe removal.", newFirstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target sub disk should still have a simple volume over it after the stripe removal.", newSecondSimple);
            SimpleVolumeMgrStripeTest.assertEquals((String)"The source simple volume should not change because of the stripe removal.", firstSimple, newFirstSimple);
            SimpleVolumeMgrStripeTest.assertEquals((String)"The target simple volume should not change because of the stripe removal.", secondSimple, newSecondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"The cleanup could not be completed");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The cleanup could not be completed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveStripe3() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrStripeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            String firstSimple = null;
            String secondSimple = null;
            String newFirstSimple = null;
            String newSecondSimple = null;
            try {
                sub1 = this.myTestUtils.createSubDisk(secondDisk, "sub1", new BigInteger("10000000"));
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), firstDisk.getCommKeyClassId()};
                stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "stripe1", new BigInteger("5000"));
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                newFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                newSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrStripeTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", secondSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The source disk should still have a simple volume over it after the stripe removal.", newFirstSimple);
            SimpleVolumeMgrStripeTest.assertNotNull((String)"The target sub disk should still have a simple volume over it after the stripe removal.", newSecondSimple);
            SimpleVolumeMgrStripeTest.assertEquals((String)"The source simple volume should not change because of the stripe removal.", firstSimple, newFirstSimple);
            SimpleVolumeMgrStripeTest.assertEquals((String)"The target simple volume should not change because of the stripe removal.", secondSimple, newSecondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(clean1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }
}

