/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;

public class SimpleVolumeMgrStorageTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpose1() {
        Target newTarget = null;
        DirectAccessDevice noSimpleDisk = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            noSimpleDisk = disks.get(0);
            newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
            if (newTarget == null) {
                SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
            }
            try {
                this.myTestUtils.exposeVolume((VolumeNode)noSimpleDisk, 0, newTarget);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            try {
                String newSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, noSimpleDisk.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertNotNull((String)"The simple was not created", (Object)newSimple);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not get the CKCI for the disk.");
            }
        }
        catch (Throwable throwable) {
            block15: {
                try {
                    if (newTarget != null) {
                        this.myTestUtils.removeTarget(newTarget);
                    }
                    SubDirectAccessDeviceImpl sub1 = this.myTestUtils.createSubDisk(noSimpleDisk, "sub1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"The cleanup could not be completed");
                }
            }
            throw throwable;
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            SubDirectAccessDeviceImpl sub1 = this.myTestUtils.createSubDisk(noSimpleDisk, "sub1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
        }
        catch (RemoteException e) {
            assert (false) : "The cleanup could not be completed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpose2() {
        DirectAccessDevice simpleDisk = null;
        Target newTarget = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not find an unused disk.");
            }
            simpleDisk = disks.get(0);
            String oldSimpleVol = null;
            try {
                newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                if (newTarget == null) {
                    SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
                }
                this.myTestUtils.exposeVolume((VolumeNode)simpleDisk, 0, "test");
                oldSimpleVol = SrTestUtils.getInstance().getSimpleVolByPhysStor(this.myDefCluster, simpleDisk.getCommKeyClassId());
                if (oldSimpleVol == null || oldSimpleVol.equals("")) {
                    SimpleVolumeMgrStorageTest.fail((String)"The simple volume is invalid.");
                }
                this.myTestUtils.removeTarget(newTarget);
                newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "new");
                if (newTarget == null) {
                    SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
                }
                this.myTestUtils.exposeVolume((VolumeNode)simpleDisk, 0, "new");
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            try {
                String newSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, simpleDisk.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertNotNull((Object)"The simple volume was not found.");
                SimpleVolumeMgrStorageTest.assertEquals((String)"The simple volume that was used was not the existing one", (String)newSimple, oldSimpleVol);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not get the CKCI for the disk.");
            }
        }
        catch (Throwable throwable) {
            try {
                if (newTarget != null) {
                    this.myTestUtils.removeTarget(newTarget);
                }
                SubDirectAccessDeviceImpl sub1 = null;
                sub1 = this.myTestUtils.createSubDisk(simpleDisk, "sub1", new BigInteger("1000000000"));
                if (sub1 != null) {
                    this.myTestUtils.removeSubDisk(sub1);
                }
            }
            catch (RemoteException e1) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not create\remove the sub disk.");
            }
            throw throwable;
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            SubDirectAccessDeviceImpl sub1 = null;
            sub1 = this.myTestUtils.createSubDisk(simpleDisk, "sub1", new BigInteger("1000000000"));
            if (sub1 != null) {
                this.myTestUtils.removeSubDisk(sub1);
            }
        }
        catch (RemoteException e1) {
            SimpleVolumeMgrStorageTest.fail((String)"Could not create\remove the sub disk.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testExpose3() {
        LogicObject noSimpleSub = null;
        Target newTarget = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getAllDisks(this.myDefCluster);
            for (DirectAccessDeviceImpl curDisk : disks) {
                if (this.myTestUtils.isDiskUsed(curDisk)) continue;
                noSimpleSub = this.myTestUtils.createSubDisk(curDisk, "testSub", new BigInteger("10000000"));
                break;
            }
            if (noSimpleSub == null) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not find a sub disk with no simple volume.");
            }
            if ((newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test")) == null) {
                SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
            }
            try {
                this.myDefCluster.getStorage().exposeVolume(0, noSimpleSub.getCommKeyClassId(), newTarget.getCommKeyClassId()).get();
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            catch (IllegalValueException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not perform the expose because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrStorageTest.fail((String)("Could not perform the expose because of the following error: " + exp));
            }
            try {
                String newSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, noSimpleSub.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertNotNull((String)"The simple was not created.", (Object)newSimple);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not get the CKCI for the disk.");
            }
        }
        catch (Throwable throwable) {
            try {
                if (newTarget != null) {
                    this.myTestUtils.removeTarget(newTarget);
                }
                if (noSimpleSub == null) throw throwable;
                this.myTestUtils.removeSubDisk((SubDirectAccessDevice)noSimpleSub);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"Could not complete the clean up.");
            }
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            if (noSimpleSub == null) return;
            this.myTestUtils.removeSubDisk((SubDirectAccessDevice)noSimpleSub);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testExpose4() {
        LogicObject simpleSub = null;
        Target tmpTarget = null;
        Target newTarget = null;
        try {
            String oldSimple = null;
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getAllDisks(this.myDefCluster);
            for (DirectAccessDeviceImpl curDisk : disks) {
                if (this.myTestUtils.isDiskUsed(curDisk)) continue;
                simpleSub = this.myTestUtils.createSubDisk(curDisk, "testSub", new BigInteger("10000000"));
                break;
            }
            if (simpleSub == null) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not create a sub disk.");
            }
            if ((tmpTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "tmp")) != null) {
                try {
                    this.myDefCluster.getStorage().exposeVolume(0, simpleSub.getCommKeyClassId(), tmpTarget.getCommKeyClassId()).get();
                    oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, simpleSub.getCommKeyClassId());
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrStorageTest.fail((String)"Could not expose the sub disk.");
                }
                catch (IllegalValueException e) {
                    SimpleVolumeMgrStorageTest.fail((String)"Could not expose the sub disk.");
                }
                catch (InterruptedException exp) {
                    SimpleVolumeMgrStorageTest.fail((String)"Could not perform the expose because the operation was interrupted.");
                }
                catch (ExecutionException exp) {
                    SimpleVolumeMgrStorageTest.fail((String)("Could not perform the expose because of the following error: " + exp));
                }
            } else {
                SimpleVolumeMgrStorageTest.fail((String)"Could not create the target in order to expose the sub disk.");
            }
            this.myTestUtils.removeTarget(tmpTarget);
            newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
            if (newTarget == null) {
                SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
            }
            try {
                this.myDefCluster.getStorage().exposeVolume(0, simpleSub.getCommKeyClassId(), newTarget.getCommKeyClassId());
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            catch (IllegalValueException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            try {
                String newSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, simpleSub.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertEquals((String)("The existing simple volume was not used. The old volume is " + oldSimple + " and the new volume is " + newSimple), (String)newSimple, (String)oldSimple);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not get the CKCI for the disk.");
            }
        }
        catch (Throwable throwable) {
            try {
                if (newTarget != null) {
                    this.myTestUtils.removeTarget(newTarget);
                }
                if (simpleSub == null) throw throwable;
                this.myTestUtils.removeSubDisk((SubDirectAccessDevice)simpleSub);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"Could not complete the clean up.");
            }
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            if (simpleSub == null) return;
            this.myTestUtils.removeSubDisk((SubDirectAccessDevice)simpleSub);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testUnexpose1() {
        SubDirectAccessDeviceImpl clean;
        DirectAccessDevice testDisk = null;
        Target newTarget = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            testDisk = disks.get(0);
            newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
            if (newTarget == null) {
                SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
            }
            try {
                this.myTestUtils.exposeVolume((VolumeNode)testDisk, 0, "test");
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the disk.");
            }
            this.myTestUtils.removeTarget(newTarget);
            try {
                String newSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, testDisk.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertNotNull((String)"The simple was not created", (Object)newSimple);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not get the CKCI for the disk.");
            }
            clean = this.myTestUtils.createSubDisk(testDisk, "clean", new BigInteger("100000000"));
        }
        catch (Throwable throwable) {
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(testDisk, "clean", new BigInteger("100000000"));
            try {
                if (clean2 == null) throw throwable;
                this.myTestUtils.removeSubDisk(clean2);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"Could not complete the cleanup");
            }
        }
        try {
            if (clean == null) return;
            this.myTestUtils.removeSubDisk(clean);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the cleanup";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testUnexpose2() {
        LogicObject testSubDisk = null;
        Target newTarget = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getAllDisks(this.myDefCluster);
            for (DirectAccessDeviceImpl curDisk : disks) {
                if (this.myTestUtils.isDiskUsed(curDisk)) continue;
                testSubDisk = this.myTestUtils.createSubDisk(curDisk, "testSub", new BigInteger("10000000"));
                break;
            }
            if (testSubDisk == null) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not find an unused sub disk.");
            }
            if ((newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test")) == null) {
                SimpleVolumeMgrStorageTest.fail((String)"A target could not be created");
            }
            try {
                this.myDefCluster.getStorage().exposeVolume(0, testSubDisk.getCommKeyClassId(), newTarget.getCommKeyClassId()).get();
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the sub disk.");
            }
            catch (IllegalValueException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not expose the sub disk.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not perform the expose because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrStorageTest.fail((String)("Could not perform the expose because of the following error: " + exp));
            }
            this.myTestUtils.removeTarget(newTarget);
            try {
                String newSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, testSubDisk.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertNotNull((String)"The simple was not created", (Object)newSimple);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not get the CKCI for the disk.");
            }
        }
        catch (Throwable throwable) {
            try {
                if (testSubDisk == null) throw throwable;
                this.myTestUtils.removeSubDisk((SubDirectAccessDevice)testSubDisk);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"Could not complete the clean up.");
            }
        }
        try {
            if (testSubDisk == null) return;
            this.myTestUtils.removeSubDisk((SubDirectAccessDevice)testSubDisk);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void testTransparent1() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void testCreateSubDisk1() {
        block12: {
            disk1 = null;
            sub1 = null;
            try {
                disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrStorageTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                disk1 = disks.get(0);
                sub1 = this.myTestUtils.createSubDisk(disk1, "sub1", new BigInteger("1000000000"));
                simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                SimpleVolumeMgrStorageTest.assertNull((String)"There should not be a simple volume for the subdisk", (Object)simple);
                ** try [egrp 1[TRYBLOCK] [0 : 83->94)] { 
            }
            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not complete the simple volume query.");
                break block12;
            }
            finally {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrStorageTest.fail((String)"Could not complete the clean up.");
                }
            }
lbl-1000:
            // 1 sources

            {
                this.myTestUtils.removeSubDisk(sub1);
            }
lbl14:
            // 1 sources

            catch (RemoteException e) {
                SimpleVolumeMgrStorageTest.fail((String)"Could not complete the clean up.");
            }
            {
            }
        }
    }
}

