/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;

public class SimpleVolumeMgrSnapshotTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSnapshot1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, firstDisk, secondDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            try {
                if (snapshot != null) {
                    this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                }
                SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                if (clean1 != null) {
                    this.myTestUtils.removeSubDisk(clean1);
                }
                if (clean2 != null) {
                    this.myTestUtils.removeSubDisk(clean2);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (snapshot != null) {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            }
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
            if (clean1 != null) {
                this.myTestUtils.removeSubDisk(clean1);
            }
            if (clean2 != null) {
                this.myTestUtils.removeSubDisk(clean2);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testCreateSnapshot2() {
        VolumeNode snapshot = null;
        DirectAccessDevice firstDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "source", new BigInteger("10000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "target", new BigInteger("10000000"));
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, sub1, sub2, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            try {
                if (snapshot != null) {
                    this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                }
                if (sub1 != null) {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                if (sub2 == null) throw throwable;
                this.myTestUtils.removeSubDisk(sub2);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"Could not complete the clean up.");
            }
        }
        try {
            if (snapshot != null) {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            }
            if (sub1 != null) {
                this.myTestUtils.removeSubDisk(sub1);
            }
            if (sub2 == null) return;
            this.myTestUtils.removeSubDisk(sub2);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testCreateSnapshot3() {
        String secondSimple;
        String firstSimple;
        block17: {
            SubDirectAccessDeviceImpl sub1;
            DirectAccessDevice secondDisk;
            block16: {
                VolumeNode snapshot;
                block15: {
                    DirectAccessDevice firstDisk = null;
                    secondDisk = null;
                    sub1 = null;
                    snapshot = null;
                    firstSimple = null;
                    secondSimple = null;
                    try {
                        List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
                        if (disks == null) {
                            SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                        }
                        firstDisk = disks.get(0);
                        secondDisk = disks.get(1);
                        sub1 = this.myTestUtils.createSubDisk(firstDisk, "target", new BigInteger("4000000000"));
                        snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, secondDisk, sub1, "testSnap");
                        try {
                            firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                            secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                            SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disk and the disk.");
                        }
                        if (snapshot != null) break block15;
                        if ($assertionsDisabled) break block16;
                        throw new AssertionError((Object)"The snapshot volume was not found.");
                    }
                    catch (Throwable throwable) {
                        if (snapshot == null) {
                            assert (false) : "The snapshot volume was not found.";
                        } else {
                            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                        }
                        try {
                            SubDirectAccessDeviceImpl clean1;
                            if (sub1 != null) {
                                this.myTestUtils.removeSubDisk(sub1);
                            }
                            if ((clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"))) == null) throw throwable;
                            this.myTestUtils.removeSubDisk(clean1);
                            throw throwable;
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                            if ($assertionsDisabled) throw throwable;
                            throw new AssertionError((Object)"Could not complete the clean up.");
                        }
                    }
                }
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            }
            try {
                SubDirectAccessDeviceImpl clean1;
                if (sub1 != null) {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                if ((clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"))) != null) {
                    this.myTestUtils.removeSubDisk(clean1);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block17;
                throw new AssertionError((Object)"Could not complete the clean up.");
            }
        }
        SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
        SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", (Object)secondSimple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSnapshot4() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "source", new BigInteger("1000000000"));
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, sub1, secondDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disk and the disk.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
        }
        catch (Throwable throwable) {
            block10: {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSnapshot5() {
        DirectAccessDevice unexposedDisk = null;
        DirectAccessDevice exposedDisk = null;
        Target tmpTarget = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            unexposedDisk = disks.get(0);
            exposedDisk = disks.get(1);
            tmpTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "tmp");
            if (tmpTarget != null) {
                try {
                    this.myDefCluster.getStorage().exposeVolume(0, exposedDisk.getCommKeyClassId(), tmpTarget.getCommKeyClassId()).get();
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrSnapshotTest.fail((String)"Could not expose the disk.");
                }
                catch (IllegalValueException e) {
                    SimpleVolumeMgrSnapshotTest.fail((String)"Could not expose the disk.");
                }
                catch (InterruptedException exp) {
                    SimpleVolumeMgrSnapshotTest.fail((String)"Could not perform the expose because the operation was interrupted.");
                }
                catch (ExecutionException exp) {
                    SimpleVolumeMgrSnapshotTest.fail((String)("Could not perform the expose because of the following error: " + exp));
                }
            } else {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not expose the disk.");
            }
            String oldSimple = null;
            try {
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedDisk.getCommKeyClassId());
            }
            catch (RemoteException e1) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not complete the simple volume query for the disk.");
            }
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, exposedDisk, unexposedDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, unexposedDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertEquals((String)"The source disk should use the old simple volume instead of creating a new simple volume.", secondSimple, (String)oldSimple);
        }
        catch (Throwable throwable) {
            block19: {
                try {
                    this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                    this.myTestUtils.removeTarget(tmpTarget);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(exposedDisk, "clean1", new BigInteger("1000000000"));
                    SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(unexposedDisk, "clean2", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                    this.myTestUtils.removeSubDisk(clean2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block19;
                    throw new AssertionError((Object)"Could not complete the clean up");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            this.myTestUtils.removeTarget(tmpTarget);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(exposedDisk, "clean1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(unexposedDisk, "clean2", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(clean2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSnapshot6() {
        SubDirectAccessDeviceImpl unexposedSubDisk = null;
        LogicObject exposedSubDisk = null;
        Target tmpTarget = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getAllDisks(this.myDefCluster);
            for (DirectAccessDeviceImpl curDisk : disks) {
                if (this.myTestUtils.isDiskUsed(curDisk)) continue;
                unexposedSubDisk = this.myTestUtils.createSubDisk(curDisk, "test_sub1", new BigInteger("10000000"));
                exposedSubDisk = this.myTestUtils.createSubDisk(curDisk, "test_sub2", new BigInteger("10000000"));
                break;
            }
            if (unexposedSubDisk == null || exposedSubDisk == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not create the required two sub disks.");
            }
            String oldSimple = null;
            try {
                tmpTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "exp");
                this.myDefCluster.getStorage().exposeVolume(0, exposedSubDisk.getCommKeyClassId(), tmpTarget.getCommKeyClassId()).get();
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedSubDisk.getCommKeyClassId());
            }
            catch (RemoteException e1) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not complete the simple volume query for the disk.");
            }
            catch (IllegalValueException e) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not expose the sub disk.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not perform the expose because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrSnapshotTest.fail((String)("Could not perform the expose because of the following error: " + exp));
            }
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, (VolumeNode)exposedSubDisk, unexposedSubDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, unexposedSubDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedSubDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertEquals((String)"The source sub disk should use the old simple volume instead of creating a new simple volume.", secondSimple, (String)oldSimple);
        }
        catch (Throwable throwable) {
            try {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                this.myTestUtils.removeTarget(tmpTarget);
                this.myTestUtils.removeSubDisk((SubDirectAccessDevice)exposedSubDisk);
                this.myTestUtils.removeSubDisk(unexposedSubDisk);
            }
            catch (RemoteException e) {
                assert (false) : "The clean up could not be completed.";
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            this.myTestUtils.removeTarget(tmpTarget);
            this.myTestUtils.removeSubDisk((SubDirectAccessDevice)exposedSubDisk);
            this.myTestUtils.removeSubDisk(unexposedSubDisk);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSnapshot7() {
        DirectAccessDevice tmpDisk = null;
        DirectAccessDevice exposedDisk = null;
        SubDirectAccessDeviceImpl unexposedSubDisk = null;
        Target tmpTarget = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            tmpDisk = disks.get(0);
            exposedDisk = disks.get(1);
            unexposedSubDisk = this.myTestUtils.createSubDisk(tmpDisk, "testSub", new BigInteger("1000000000"));
            if (unexposedSubDisk == null || exposedDisk == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the required disk and sub disk.");
            }
            String oldSimple = null;
            try {
                tmpTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "tmp");
                this.myDefCluster.getStorage().exposeVolume(0, exposedDisk.getCommKeyClassId(), tmpTarget.getCommKeyClassId()).get();
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedDisk.getCommKeyClassId());
            }
            catch (RemoteException e1) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not complete the simple volume query for the disk.");
                e1.printStackTrace();
            }
            catch (IllegalValueException e) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not expose the disk");
                e.printStackTrace();
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not perform the expose because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrSnapshotTest.fail((String)("Could not perform the expose because of the following error: " + exp));
            }
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, exposedDisk, unexposedSubDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, unexposedSubDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertEquals((String)"The source sub disk should use the old simple volume instead of creating a new simple volume.", secondSimple, (String)oldSimple);
        }
        catch (Throwable throwable) {
            block16: {
                try {
                    this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                    this.myTestUtils.removeTarget(tmpTarget);
                    this.myTestUtils.removeSubDisk(unexposedSubDisk);
                    SubDirectAccessDeviceImpl clean = this.myTestUtils.createSubDisk(exposedDisk, "tmpSub", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            this.myTestUtils.removeTarget(tmpTarget);
            this.myTestUtils.removeSubDisk(unexposedSubDisk);
            SubDirectAccessDeviceImpl clean = this.myTestUtils.createSubDisk(exposedDisk, "tmpSub", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSnapshot8() {
        DirectAccessDevice tmpDisk = null;
        DirectAccessDevice unexposedDisk = null;
        SubDirectAccessDeviceImpl exposedSubDisk = null;
        Target tmpTarget = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            tmpDisk = disks.get(0);
            unexposedDisk = disks.get(1);
            exposedSubDisk = this.myTestUtils.createSubDisk(tmpDisk, "testSub", new BigInteger("1000000000"));
            if (exposedSubDisk == null || unexposedDisk == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the required disk and sub disk.");
            }
            String oldSimple = null;
            try {
                tmpTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                this.myDefCluster.getStorage().exposeVolume(0, exposedSubDisk.getCommKeyClassId(), tmpTarget.getCommKeyClassId()).get();
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedSubDisk.getCommKeyClassId());
            }
            catch (RemoteException e1) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not complete the simple volume query for the disk.");
            }
            catch (IllegalValueException e) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not expose the sub disk.");
                e.printStackTrace();
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not perform the expose because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrSnapshotTest.fail((String)("Could not perform the expose because of the following error: " + exp));
            }
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, exposedSubDisk, unexposedDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, unexposedDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, exposedSubDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertEquals((String)"The source sub disk should use the old simple volume instead of creating a new simple volume.", secondSimple, (String)oldSimple);
        }
        catch (Throwable throwable) {
            try {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                this.myTestUtils.removeTarget(tmpTarget);
                this.myTestUtils.removeSubDisk(exposedSubDisk);
                SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(unexposedDisk, "clean1", new BigInteger("1000000000"));
                this.myTestUtils.removeSubDisk(clean1);
            }
            catch (RemoteException e) {
                assert (false) : "Could not complete the clean up";
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            this.myTestUtils.removeTarget(tmpTarget);
            this.myTestUtils.removeSubDisk(exposedSubDisk);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(unexposedDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            assert (false) : "Could not complete the clean up";
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveSnapshot1() {
        SubDirectAccessDeviceImpl clean2;
        SubDirectAccessDeviceImpl clean1;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, firstDisk, secondDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
            clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block10: {
                SubDirectAccessDeviceImpl clean12 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl clean22 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(clean12);
                    this.myTestUtils.removeSubDisk(clean22);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the cleanup.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(clean2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the cleanup.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveSnapshot2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "source", new BigInteger("10000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "target", new BigInteger("10000000"));
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, sub1, sub2, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveSnapshot3() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "source", new BigInteger("10000000"));
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, sub1, secondDisk, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            try {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disk and the disk.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveSnapshot4() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode snapshot = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "source", new BigInteger("1000000000"));
            snapshot = this.myTestUtils.createSnapshot(this.myDefCluster, secondDisk, sub1, "testSnap");
            String firstSimple = null;
            String secondSimple = null;
            this.myTestUtils.removeSnapshot(this.myDefCluster, snapshot);
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrSnapshotTest.fail((String)"Could not find the simple volumes for the sub disk and the disk.");
            }
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrSnapshotTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block10: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block10;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }
}

