/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import junit.framework.TestCase;

public class SimpleVolumeMgrOfflineCopyTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy1() {
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            try {
                this.myTestUtils.createOfflineCopy(firstDisk, secondDisk);
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple1 == null || simple2 == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                } else {
                    SimpleVolumeMgrOfflineCopyTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, firstDisk, secondDisk);
            if (copyOp != null) {
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block14: {
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, firstDisk, secondDisk);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                SubDirectAccessDeviceImpl sub12 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub12);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy2() {
        DirectAccessDevice firstDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            try {
                this.myTestUtils.createOfflineCopy(sub1, sub2);
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                if (simple1 == null || simple2 == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                } else {
                    SimpleVolumeMgrOfflineCopyTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, sub2);
                    if (copyOp != null) {
                        this.myTestUtils.removeCopyOperation(copyOp);
                    }
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, sub2);
            if (copyOp != null) {
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy3() {
        SubDirectAccessDeviceImpl sub2;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            try {
                this.myTestUtils.createOfflineCopy(sub1, secondDisk);
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple1 == null || simple2 == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                } else {
                    SimpleVolumeMgrOfflineCopyTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, secondDisk);
            if (copyOp != null) {
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block14: {
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, secondDisk);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy4() {
        SubDirectAccessDeviceImpl sub2;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            try {
                this.myTestUtils.createOfflineCopy(secondDisk, sub1);
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple1 == null || simple2 == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                } else {
                    SimpleVolumeMgrOfflineCopyTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, secondDisk, sub1);
            if (copyOp != null) {
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block14: {
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, secondDisk, sub1);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy5() {
        Target newTarget;
        DirectAccessDevice secondDisk;
        DirectAccessDevice firstDisk;
        block18: {
            firstDisk = null;
            secondDisk = null;
            newTarget = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
                if (disks == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                firstDisk = disks.get(0);
                secondDisk = disks.get(1);
                newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "new");
                if (newTarget == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the target needed for the test.");
                }
                try {
                    this.myTestUtils.exposeVolume((VolumeNode)firstDisk, 0, newTarget);
                }
                catch (RemoteException e1) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not expose the disk.");
                }
                try {
                    String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                    this.myTestUtils.createOfflineCopy(firstDisk, secondDisk);
                    String newSimple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                    String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                    if (simple1 == null || simple2 == null) {
                        SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                    } else {
                        SimpleVolumeMgrOfflineCopyTest.assertEquals((String)"The exposed disk should retain its simple volume.", (String)simple1, (String)newSimple1);
                    }
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
                }
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, firstDisk, secondDisk);
                if (copyOp == null) break block18;
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            catch (Throwable throwable) {
                block19: {
                    CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, firstDisk, secondDisk);
                    if (copyOp != null) {
                        this.myTestUtils.removeCopyOperation(copyOp);
                    }
                    try {
                        if (newTarget != null) {
                            this.myTestUtils.removeTarget(newTarget);
                        }
                        SubDirectAccessDeviceImpl sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                        SubDirectAccessDeviceImpl sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                        this.myTestUtils.removeSubDisk(sub1);
                        this.myTestUtils.removeSubDisk(sub2);
                    }
                    catch (RemoteException e) {
                        if ($assertionsDisabled) break block19;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
                throw throwable;
            }
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            SubDirectAccessDeviceImpl sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy6() {
        Target newTarget;
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        block16: {
            DirectAccessDevice firstDisk = null;
            sub1 = null;
            sub2 = null;
            newTarget = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                firstDisk = disks.get(0);
                sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
                newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "new");
                if (newTarget == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The target needed for the test could not be created.");
                }
                try {
                    this.myTestUtils.exposeVolume((VolumeNode)sub1, 0, newTarget);
                    String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                    this.myTestUtils.createOfflineCopy(sub1, sub2);
                    String newSimple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                    String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                    if (simple1 == null || simple2 == null) {
                        SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                    } else {
                        SimpleVolumeMgrOfflineCopyTest.assertEquals((String)"The exposed sub disk should retain its old simple volume.", (String)simple1, (String)newSimple1);
                    }
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
                }
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, sub2);
                if (copyOp == null) break block16;
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            catch (Throwable throwable) {
                block17: {
                    CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, sub2);
                    if (copyOp != null) {
                        this.myTestUtils.removeCopyOperation(copyOp);
                    }
                    try {
                        if (newTarget != null) {
                            this.myTestUtils.removeTarget(newTarget);
                        }
                        this.myTestUtils.removeSubDisk(sub1);
                        this.myTestUtils.removeSubDisk(sub2);
                    }
                    catch (RemoteException e) {
                        if ($assertionsDisabled) break block17;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
                throw throwable;
            }
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy7() {
        SubDirectAccessDeviceImpl sub2;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        Target newTarget = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "new");
            if (newTarget == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"The target needed for the test could not be created.");
            }
            try {
                this.myTestUtils.exposeVolume((VolumeNode)sub1, 0, newTarget);
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                this.myTestUtils.createOfflineCopy(sub1, secondDisk);
                String newSimple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple1 == null || simple2 == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                } else {
                    SimpleVolumeMgrOfflineCopyTest.assertEquals((String)"The sub disk should retain its simple volume.", (String)simple1, (String)newSimple1);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, secondDisk);
            if (copyOp != null) {
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block15: {
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, sub1, secondDisk);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeTarget(newTarget);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeTarget(newTarget);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOfflineCopy8() {
        SubDirectAccessDeviceImpl sub2;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        Target newTarget = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "new");
            if (newTarget == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"The target needed for the test could not be created.");
            }
            try {
                this.myTestUtils.exposeVolume((VolumeNode)secondDisk, 0, newTarget);
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                this.myTestUtils.createOfflineCopy(secondDisk, sub1);
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String newSimple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple1 == null || simple2 == null) {
                    SimpleVolumeMgrOfflineCopyTest.fail((String)"The simple volumes were not created.");
                } else {
                    SimpleVolumeMgrOfflineCopyTest.assertEquals((String)"The disk should retain its simple volume.", (String)simple2, (String)newSimple2);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, secondDisk, sub1);
            if (copyOp != null) {
                this.myTestUtils.removeCopyOperation(copyOp);
            }
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block15: {
                CopyOperation copyOp = this.myTestUtils.getCopyOperation(this.myDefCluster, secondDisk, sub1);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeTarget(newTarget);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeTarget(newTarget);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveOfflineCopy1() {
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            try {
                CopyOperation copyOp = this.myTestUtils.createOfflineCopy(firstDisk, secondDisk);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                SimpleVolumeMgrOfflineCopyTest.assertNotNull((String)"The simple volumes were not created.", (Object)simple1);
                SimpleVolumeMgrOfflineCopyTest.assertNotNull((String)"The simple volumes were not created.", (Object)simple2);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block11: {
                SubDirectAccessDeviceImpl sub12 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub12);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveOfflineCopy2() {
        DirectAccessDevice firstDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            try {
                CopyOperation copyOp = this.myTestUtils.createOfflineCopy(sub1, sub2);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                SimpleVolumeMgrOfflineCopyTest.assertNotNull((String)"The simple volumes were not created.", (Object)simple1);
                SimpleVolumeMgrOfflineCopyTest.assertNotNull((String)"The simple volumes were not created.", (Object)simple2);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
        }
        catch (Throwable throwable) {
            block11: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveOfflineCopy3() {
        SubDirectAccessDeviceImpl sub2;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            try {
                CopyOperation copyOp = this.myTestUtils.createOfflineCopy(sub1, secondDisk);
                if (copyOp != null) {
                    this.myTestUtils.removeCopyOperation(copyOp);
                }
                String simple1 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String simple2 = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                SimpleVolumeMgrOfflineCopyTest.assertNotNull((String)"The simple volumes were not created.", (Object)simple1);
                SimpleVolumeMgrOfflineCopyTest.assertNotNull((String)"The simple volumes were not created.", (Object)simple2);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrOfflineCopyTest.fail((String)"Could not create the offline copy required for the test.");
            }
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block11: {
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "The clean up could not be completed.";
        }
    }
}

