/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import junit.framework.TestCase;

public class SimpleVolumeMgrMirrorTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMirror1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode mirror = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            String firstSimple = null;
            String secondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                mirror = this.myTestUtils.createMirror(this.myDefCluster, children, "mirror1");
                if (mirror == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The source disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The target disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block13: {
                try {
                    if (mirror != null) {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror);
                    }
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                    SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                    this.myTestUtils.removeSubDisk(clean2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            if (mirror != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror);
            }
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(clean2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMirror2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode mirror = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not create the sub disks for the test.");
            }
            String firstSimple = null;
            String secondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                mirror = this.myTestUtils.createMirror(this.myDefCluster, children, "mirror1");
                if (mirror == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The first sub disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The second sub disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    if (mirror != null) {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror);
                    }
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            if (mirror != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror);
            }
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMirror3() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode mirror = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(secondDisk, "sub1", new BigInteger("1000000000"));
            if (sub1 == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"The sub disk required to run the test could not be created.");
            }
            String firstSimple = null;
            String secondSimple = null;
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), sub1.getCommKeyClassId()};
                mirror = this.myTestUtils.createMirror(this.myDefCluster, children, "mirror1");
                if (mirror == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the disk and the sub disk.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The disk should have a simple volume over it.", firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The sub disk should have a simple volume over it.", secondSimple);
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    if (mirror != null) {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror);
                    }
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            if (mirror != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror);
            }
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(sub1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testCreateMirror4() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        DirectAccessDevice thirdDisk = null;
        VolumeNode mirror1 = null;
        Target target = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 3);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            thirdDisk = disks.get(2);
            String oldSimple = null;
            try {
                CommKeyClassId[] child = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), thirdDisk.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                target = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                try {
                    this.myTestUtils.exposeVolume((VolumeNode)firstDisk, 0, "test");
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not expose the volume.");
                }
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                this.myTestUtils.addChildToMirror(mirror1, secondDisk.getCommKeyClassId(), false);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The source disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The simple volume for the source should be the same before and after the child addition.", oldSimple, (String)firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The target disk should have a simple volume over it.", (Object)secondSimple);
        }
        catch (Throwable throwable) {
            try {
                if (mirror1 != null) {
                    this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                }
                if (target != null) {
                    this.myTestUtils.removeTarget(target);
                }
                SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl clean3 = this.myTestUtils.createSubDisk(thirdDisk, "clean3", new BigInteger("1000000000"));
                if (clean1 != null) {
                    this.myTestUtils.removeSubDisk(clean1);
                }
                if (clean2 != null) {
                    this.myTestUtils.removeSubDisk(clean2);
                }
                if (clean3 == null) throw throwable;
                this.myTestUtils.removeSubDisk(clean3);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"The clean up could not be completed.");
            }
        }
        try {
            if (mirror1 != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
            }
            if (target != null) {
                this.myTestUtils.removeTarget(target);
            }
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean3 = this.myTestUtils.createSubDisk(thirdDisk, "clean3", new BigInteger("1000000000"));
            if (clean1 != null) {
                this.myTestUtils.removeSubDisk(clean1);
            }
            if (clean2 != null) {
                this.myTestUtils.removeSubDisk(clean2);
            }
            if (clean3 == null) return;
            this.myTestUtils.removeSubDisk(clean3);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMirror5() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        Target target = null;
        VolumeNode mirror1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not create the sub disks needed for the test.");
            }
            String oldSimple = null;
            try {
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                CommKeyClassId[] child = new CommKeyClassId[]{sub1.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                target = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                try {
                    this.myTestUtils.exposeVolume((VolumeNode)firstDisk, 0, "test");
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not expose the disk.");
                }
                this.myTestUtils.addChildToMirror(mirror1, sub2.getCommKeyClassId(), false);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The simple volume for the source should be the same before and after the child addition.", (String)oldSimple, (String)firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", (Object)secondSimple);
        }
        catch (Throwable throwable) {
            block20: {
                try {
                    if (mirror1 != null) {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                    }
                    if (target != null) {
                        this.myTestUtils.removeTarget(target);
                    }
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block20;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            if (mirror1 != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
            }
            if (target != null) {
                this.myTestUtils.removeTarget(target);
            }
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMirror6() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        Target target = null;
        VolumeNode mirror1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            if (sub1 == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not create the sub disk needed for the test.");
            }
            String oldSimple = null;
            try {
                CommKeyClassId[] child = new CommKeyClassId[]{secondDisk.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                target = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                this.myTestUtils.exposeVolume((VolumeNode)secondDisk, 0, "test");
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                this.myTestUtils.addChildToMirror(mirror1, sub1.getCommKeyClassId(), false);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The simple volume for the source should be the same before and after the child addition.", oldSimple, (String)firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", (Object)secondSimple);
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    if (mirror1 != null) {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                    }
                    if (target != null) {
                        this.myTestUtils.removeTarget(target);
                    }
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            if (mirror1 != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
            }
            if (target != null) {
                this.myTestUtils.removeTarget(target);
            }
            this.myTestUtils.removeSubDisk(sub1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateMirror7() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode mirror1 = null;
        Target target = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            if (sub1 == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not create the sub disk needed for the test.");
            }
            String oldSimple = null;
            try {
                oldSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                CommKeyClassId[] child = new CommKeyClassId[]{sub1.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
                target = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                try {
                    this.myTestUtils.exposeVolume((VolumeNode)sub1, 0, "test");
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not expose the sub disk.");
                }
                this.myTestUtils.addChildToMirror(mirror1, secondDisk.getCommKeyClassId(), false);
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String firstSimple = null;
            String secondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the sub disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The source sub disk should have a simple volume over it.", (Object)firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The simple volume for the source should be the same before and after the child addition.", (String)oldSimple, (String)firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"The target sub disk should have a simple volume over it.", (Object)secondSimple);
        }
        catch (Throwable throwable) {
            block20: {
                try {
                    if (mirror1 != null) {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                    }
                    if (target != null) {
                        this.myTestUtils.removeTarget(target);
                    }
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block20;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            if (mirror1 != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
            }
            if (target != null) {
                this.myTestUtils.removeTarget(target);
            }
            this.myTestUtils.removeSubDisk(sub1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakMirror1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode mirror1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            try {
                CommKeyClassId[] child = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String oldFirstSimple = null;
            String oldSecondSimple = null;
            String firstSimple = null;
            String secondSimple = null;
            try {
                oldFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                oldSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (mirror1 != null) {
                    this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the first disk before the mirror break.", (Object)oldFirstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the second disk before the mirror break.", oldSecondSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the first disk after the mirror break.", firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the second disk after the mirror break.", secondSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The first disk's simple volume should be the same as before the mirror break", (String)oldFirstSimple, firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The second disk's simple volume should be the same as before the mirror break", (String)oldSecondSimple, secondSimple);
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    SubDirectAccessDeviceImpl sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                    SubDirectAccessDeviceImpl sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            SubDirectAccessDeviceImpl sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakMirror2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode mirror1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            try {
                CommKeyClassId[] child = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String oldFirstSimple = null;
            String oldSecondSimple = null;
            String firstSimple = null;
            String secondSimple = null;
            try {
                oldFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                oldSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                if (mirror1 != null) {
                    this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the first sub disk before the mirror break.", (Object)oldFirstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the second sub disk before the mirror break.", oldSecondSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the first sub disk after the mirror break.", firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the second sub disk after the mirror break.", secondSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The first disk's simple volume should be the same as before the mirror break", (String)oldFirstSimple, firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The second disk's simple volume should be the same as before the mirror break", (String)oldSecondSimple, secondSimple);
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakMirror3() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode mirror1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            try {
                CommKeyClassId[] child = new CommKeyClassId[]{sub1.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                mirror1 = this.myTestUtils.createMirror(this.myDefCluster, child, "mirror1");
                if (mirror1 == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror");
                }
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"The mirror creation could not be completed.");
            }
            String oldFirstSimple = null;
            String oldSecondSimple = null;
            String firstSimple = null;
            String secondSimple = null;
            try {
                oldFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                oldSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (mirror1 != null) {
                    this.myTestUtils.removeMirror(this.myDefCluster, mirror1);
                }
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find the simple volumes for the disks.");
            }
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the first disk before the mirror break.", (Object)oldFirstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the second disk before the mirror break.", oldSecondSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the first disk after the mirror break.", firstSimple);
            SimpleVolumeMgrMirrorTest.assertNotNull((String)"There should be a simple volume for the second disk after the mirror break.", secondSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The first disk's simple volume should be the same as before the mirror break", (String)oldFirstSimple, firstSimple);
            SimpleVolumeMgrMirrorTest.assertEquals((String)"The second disk's simple volume should be the same as before the mirror break", (String)oldSecondSimple, secondSimple);
        }
        catch (Throwable throwable) {
            block14: {
                try {
                    SubDirectAccessDeviceImpl sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError((Object)"The clean up could not be completed.");
                }
            }
            throw throwable;
        }
        try {
            SubDirectAccessDeviceImpl sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChildToMirror1() {
        VolumeNode mirror = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrMirrorTest.fail((String)"Could not create the subdisks needed for the test.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                mirror = this.myTestUtils.createMirror(this.myDefCluster, children, "mirror1");
                this.myTestUtils.addChildToMirror(mirror, secondDisk.getCommKeyClassId(), false);
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrMirrorTest.fail((String)"There was no simple volume created for the child added to the mirror.");
                } else {
                    SimpleVolumeMgrMirrorTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrMirrorTest.fail((String)"Could not create the mirror.");
            }
        }
        catch (Throwable throwable) {
            block13: {
                try {
                    this.myTestUtils.removeMirror(this.myDefCluster, mirror);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(clean1);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeMirror(this.myDefCluster, mirror);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * Exception decompiling
     */
    public void testAddChildToMirror2() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

