/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import java.rmi.RemoteException;
import java.util.List;
import junit.framework.TestCase;

public class SimpleVolumeMgrMappingTest
extends TestCase {
    private ClusterImpl myDefCluster;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveSimpleToPhysMapping1() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            String oldVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, tmpVS.getCommKeyClassId());
            SimpleVolumeMgrMappingTest.assertNotNull((String)"The simple was not added to the mapping.", (Object)oldVal);
            SimpleVolumeMgr.getInstance().removeSimpleToPhysMapping(agentIndex, tmpVS.getCommKeyClassId());
            String newVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, tmpVS.getCommKeyClassId());
            SimpleVolumeMgrMappingTest.assertNull((String)"The mapping entry was not removed.", (Object)newVal);
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveSimpleToPhysMapping2() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            String oldVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, tmpVS.getCommKeyClassId());
            SimpleVolumeMgrMappingTest.assertNotNull((String)"The simple was not added to the mapping.", (Object)oldVal);
            SimpleVolumeMgr.getInstance().removeSimpleToPhysMapping(agentIndex, "test");
            String newVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, tmpVS.getCommKeyClassId());
            SimpleVolumeMgrMappingTest.assertNull((String)"The mapping entry was not removed.", (Object)newVal);
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSimpleVolByPhysStor1() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            String oldVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, tmpVS.getCommKeyClassId());
            SimpleVolumeMgrMappingTest.assertEquals((String)"The simple was not added to the mapping.", (String)oldVal, (String)"test");
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSimpleVolByPhysStor2() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            String oldVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(agentIndex, this.myDefCluster.getCommKeyClassId());
            SimpleVolumeMgrMappingTest.assertNull((String)"The simple was found in the mapping.", (Object)oldVal);
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPhysStorBySimpleVol1() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            CommKeyClassId oldVal = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(agentIndex, "test");
            SimpleVolumeMgrMappingTest.assertEquals((String)"The simple was not found in the mapping.", (Object)oldVal, (Object)tmpVS.getCommKeyClassId());
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPhysStorBySimpleVol2() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            CommKeyClassId oldVal = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(agentIndex, "test2");
            SimpleVolumeMgrMappingTest.assertNull((String)"The simple was not found in the mapping.", (Object)oldVal);
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddSimpleToPhysMapping1() {
        try {
            VSwitchImpl tmpVS = this.myDefCluster.getActiveVswitch();
            char agentIndex = CommKeyUtil.getSnmpAgentIndex(tmpVS.getCommKeys());
            SimpleVolumeMgr.getInstance().addAgentToSimpleMgrMapping(tmpVS.getCommKeyClassId());
            SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(agentIndex, "test", tmpVS.getCommKeyClassId());
            CommKeyClassId oldVal = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(agentIndex, "test2");
            SimpleVolumeMgrMappingTest.assertNull((String)"The simple was not found in the mapping.", (Object)oldVal);
        }
        catch (IllegalArgumentException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        catch (RemoteException e) {
            SimpleVolumeMgrMappingTest.fail((String)"Can not invoke the method.");
        }
        finally {
            SimpleVolumeMgr.getInstance().clear();
        }
    }
}

