/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;

public class SimpleVolumeMgrLogicValidTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testLogicValid1() {
        VolumeNode trans;
        Target newTarget;
        DirectAccessDevice firstDisk;
        block14: {
            firstDisk = null;
            newTarget = null;
            trans = null;
            try {
                block13: {
                    List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                    if (disks == null) {
                        SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                    }
                    firstDisk = disks.get(0);
                    newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "tmp");
                    try {
                        this.myTestUtils.exposeVolume((VolumeNode)firstDisk, 0, newTarget);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError((Object)"The expose operation could not be completed.");
                    }
                }
                boolean excpThrown = false;
                trans = this.myTestUtils.createTransparent(this.myDefCluster, "trans1", firstDisk);
                if (excpThrown) break block14;
                SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
            }
            catch (Throwable throwable) {
                try {
                    SubDirectAccessDeviceImpl clean1;
                    if (trans != null) {
                        this.myTestUtils.removeTransparent(this.myDefCluster, trans);
                    }
                    if (newTarget != null) {
                        this.myTestUtils.removeTarget(newTarget);
                    }
                    if ((clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"))) == null) throw throwable;
                    this.myTestUtils.removeSubDisk(clean1);
                    throw throwable;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) throw throwable;
                    throw new AssertionError((Object)"The cleanup operation could not be completed.");
                }
            }
        }
        try {
            SubDirectAccessDeviceImpl clean1;
            if (trans != null) {
                this.myTestUtils.removeTransparent(this.myDefCluster, trans);
            }
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            if ((clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"))) == null) return;
            this.myTestUtils.removeSubDisk(clean1);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The cleanup operation could not be completed.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testLogicValid2() {
        VolumeNode trans;
        VolumeNode snap;
        DirectAccessDevice secondDisk;
        DirectAccessDevice firstDisk;
        block14: {
            firstDisk = null;
            secondDisk = null;
            snap = null;
            trans = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
                if (disks == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                if ((snap = this.myTestUtils.createSnapshot(this.myDefCluster, firstDisk = (DirectAccessDevice)disks.get(0), secondDisk = (DirectAccessDevice)disks.get(1), "testSnap")) == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the snapshot");
                }
                boolean excpThrown = false;
                trans = this.myTestUtils.createTransparent(this.myDefCluster, "trans", firstDisk);
                if (excpThrown) break block14;
                SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
            }
            catch (Throwable throwable) {
                try {
                    if (trans != null) {
                        this.myTestUtils.removeTransparent(this.myDefCluster, trans);
                    }
                    if (snap != null) {
                        this.myTestUtils.removeSnapshot(this.myDefCluster, snap);
                    }
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                    SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                    if (clean1 != null) {
                        this.myTestUtils.removeSubDisk(clean1);
                    }
                    if (clean2 == null) throw throwable;
                    this.myTestUtils.removeSubDisk(clean2);
                    throw throwable;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) throw throwable;
                    throw new AssertionError((Object)"The clean up operation could not be completed.");
                }
            }
        }
        try {
            if (trans != null) {
                this.myTestUtils.removeTransparent(this.myDefCluster, trans);
            }
            if (snap != null) {
                this.myTestUtils.removeSnapshot(this.myDefCluster, snap);
            }
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
            if (clean1 != null) {
                this.myTestUtils.removeSubDisk(clean1);
            }
            if (clean2 == null) return;
            this.myTestUtils.removeSubDisk(clean2);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up operation could not be completed.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testLogicValid3() {
        Target newTarget;
        SubDirectAccessDeviceImpl sub1;
        block14: {
            sub1 = null;
            newTarget = null;
            try {
                DirectAccessDevice firstDisk;
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                if ((sub1 = this.myTestUtils.createSubDisk(firstDisk = (DirectAccessDevice)disks.get(0), "sub1", new BigInteger("1000000000"))) == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the sub disk.");
                }
                newTarget = this.myTestUtils.createNewTarget(this.myDefCluster, "test");
                try {
                    this.myTestUtils.exposeVolume((VolumeNode)sub1, 0, "test");
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not expose the volume.");
                }
                boolean excpThrown = false;
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e1) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
                if (excpThrown) break block14;
                SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
            }
            catch (Throwable throwable) {
                try {
                    if (newTarget != null) {
                        this.myTestUtils.removeTarget(newTarget);
                    }
                    if (sub1 == null) throw throwable;
                    this.myTestUtils.removeSubDisk(sub1);
                    throw throwable;
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) throw throwable;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
        }
        try {
            if (newTarget != null) {
                this.myTestUtils.removeTarget(newTarget);
            }
            if (sub1 == null) return;
            this.myTestUtils.removeSubDisk(sub1);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogicValid4() {
        VolumeNode mirror;
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        block15: {
            sub1 = null;
            sub2 = null;
            mirror = null;
            try {
                SubDirectAccessDevice tmpSub;
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                DirectAccessDevice firstDisk = disks.get(0);
                sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
                if (sub1 == null || sub2 == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the sub disks.");
                }
                CommKeyClassId[] children = null;
                try {
                    children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not get the CKCI for the mirror children");
                }
                mirror = this.myTestUtils.createMirror(this.myDefCluster, children, "testMir");
                boolean excpThrown = false;
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
                if (!excpThrown) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
                if ((tmpSub = this.myTestUtils.getSubDiskByAlias(this.myDefCluster, "sub1")) == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The sub disk should not have been removed.");
                    break block15;
                }
                SimpleVolumeMgrLogicValidTest.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                block16: {
                    try {
                        this.myTestUtils.removeMirror(this.myDefCluster, mirror);
                        this.myTestUtils.removeSubDisk(sub1);
                        this.myTestUtils.removeSubDisk(sub2);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block16;
                        throw new AssertionError((Object)"Could not complete the clean up.");
                    }
                }
                throw throwable;
            }
        }
        try {
            this.myTestUtils.removeMirror(this.myDefCluster, mirror);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogicValid5() {
        VolumeNode concat;
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        block15: {
            DirectAccessDevice firstDisk = null;
            sub1 = null;
            sub2 = null;
            concat = null;
            try {
                SubDirectAccessDevice tmpSub;
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                firstDisk = disks.get(0);
                sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub11", new BigInteger("1000000000"));
                sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub21", new BigInteger("1000000000"));
                if (sub1 == null || sub2 == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the sub disks.");
                }
                CommKeyClassId[] children = null;
                try {
                    children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not get the CKCI for the concat children");
                }
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "testConcat");
                boolean excpThrown = false;
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
                if (!excpThrown) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
                if ((tmpSub = this.myTestUtils.getSubDiskByAlias(this.myDefCluster, "sub11")) == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The sub disk should not have been removed.");
                    break block15;
                }
                SimpleVolumeMgrLogicValidTest.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                block16: {
                    try {
                        this.myTestUtils.removeConcat(this.myDefCluster, concat);
                        this.myTestUtils.removeSubDisk(sub1);
                        this.myTestUtils.removeSubDisk(sub2);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block16;
                        throw new AssertionError((Object)"Could not complete the clean up.");
                    }
                }
                throw throwable;
            }
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogicValid6() {
        DirectAccessDevice firstDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode stripe = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the sub disks.");
            }
            CommKeyClassId[] children = null;
            try {
                children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not get the CKCI for the stripe children");
            }
            stripe = this.myTestUtils.createStripe(this.myDefCluster, children, "testStripe", new BigInteger("5000"));
            boolean excpThrown = false;
            try {
                this.myTestUtils.removeSubDisk(sub1);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
            }
            finally {
                if (!excpThrown) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
            }
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    this.myTestUtils.removeStripe(this.myDefCluster, stripe);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeStripe(this.myDefCluster, stripe);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogicValid7() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        SubDirectAccessDeviceImpl sub3 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            sub3 = this.myTestUtils.createSubDisk(firstDisk, "sub3", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null || sub3 == null) {
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the sub disks.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                concat.resize(sub3.getCommKeyClassId(), "concat1").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the concat volume.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not resize the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrLogicValidTest.fail((String)"Could not resize because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrLogicValidTest.fail((String)("Could not resize because of the following error: " + exp));
            }
            boolean excpThrown = false;
            try {
                this.myTestUtils.removeSubDisk(sub3);
            }
            catch (RemoteException e) {
                SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
            }
            finally {
                if (!excpThrown) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
            }
        }
        catch (Throwable throwable) {
            block21: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(sub3);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block21;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(sub3);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogicValid8() {
        SimpleVolumeMgrLogicValidTest.fail((String)"This test is not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogicValid9() {
        VolumeNode snap1;
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        block11: {
            sub1 = null;
            sub2 = null;
            snap1 = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                DirectAccessDevice firstDisk = disks.get(0);
                sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
                if (sub1 == null || sub2 == null) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"Could not create the sub disks.");
                }
                snap1 = this.myTestUtils.createSnapshot(this.myDefCluster, sub1, sub2, "snap1");
                boolean excpThrown = false;
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                catch (RemoteException e) {
                    SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
                }
                if (excpThrown) break block11;
                SimpleVolumeMgrLogicValidTest.fail((String)"The logic did not block the action.");
            }
            catch (Throwable throwable) {
                block12: {
                    try {
                        this.myTestUtils.removeSnapshot(this.myDefCluster, snap1);
                        this.myTestUtils.removeSubDisk(sub1);
                        this.myTestUtils.removeSubDisk(sub2);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError((Object)"Could not complete the clean up.");
                    }
                }
                throw throwable;
            }
        }
        try {
            this.myTestUtils.removeSnapshot(this.myDefCluster, snap1);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }
}

