/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import junit.framework.TestCase;

public class SimpleVolumeMgrJournalTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateJournal1() {
        VolumeNode journal;
        DirectAccessDeviceImpl firstDisk;
        block10: {
            firstDisk = null;
            journal = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                if ((journal = this.myTestUtils.createJournal(this.myDefCluster, firstDisk = disks.get(0), "testJournal", 80)) == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"The journal could not be created.");
                }
                String simple = null;
                simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                if (simple == null || simple.equals("")) {
                    SimpleVolumeMgrJournalTest.fail((String)"There was no simple volume created for the disk.");
                    break block10;
                }
                SimpleVolumeMgrJournalTest.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                block11: {
                    try {
                        this.myTestUtils.removeJournal(this.myDefCluster, journal);
                        SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                        this.myTestUtils.removeSubDisk(clean1);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
                throw throwable;
            }
        }
        try {
            this.myTestUtils.removeJournal(this.myDefCluster, journal);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateJournal2() {
        VolumeNode journal;
        SubDirectAccessDeviceImpl sub1;
        block10: {
            sub1 = null;
            journal = null;
            try {
                DirectAccessDeviceImpl firstDisk;
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                if ((journal = this.myTestUtils.createJournal(this.myDefCluster, sub1 = this.myTestUtils.createSubDisk(firstDisk = disks.get(0), "sub1", new BigInteger("1000000000")), "testJournal", 80)) == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"The journal could not be created.");
                }
                String simple = null;
                simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                if (simple == null || simple.equals("")) {
                    SimpleVolumeMgrJournalTest.fail((String)"There was no simple volume created for the sub disk.");
                    break block10;
                }
                SimpleVolumeMgrJournalTest.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                block11: {
                    try {
                        this.myTestUtils.removeJournal(this.myDefCluster, journal);
                        this.myTestUtils.removeSubDisk(sub1);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
                throw throwable;
            }
        }
        try {
            this.myTestUtils.removeJournal(this.myDefCluster, journal);
            this.myTestUtils.removeSubDisk(sub1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveJournal1() {
        DirectAccessDeviceImpl firstDisk;
        block11: {
            firstDisk = null;
            VolumeNode journal = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                if ((journal = this.myTestUtils.createJournal(this.myDefCluster, firstDisk = disks.get(0), "testJournal", 80)) == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"The journal could not be created.");
                }
                String startSimple = null;
                startSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                if (startSimple == null || startSimple.equals("")) {
                    SimpleVolumeMgrJournalTest.fail((String)"There was no simple volume created for the disk.");
                }
                String endSimple = null;
                this.myTestUtils.removeJournal(this.myDefCluster, journal);
                endSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                if (endSimple == null || endSimple.equals("") || !endSimple.equals(startSimple)) {
                    SimpleVolumeMgrJournalTest.fail((String)("The simple volume was deleted or did not match the previous simple volume. The old simple volume is: " + startSimple + " and the new simple volume is: " + endSimple));
                    break block11;
                }
                SimpleVolumeMgrJournalTest.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                block12: {
                    try {
                        SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                        this.myTestUtils.removeSubDisk(clean1);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
                throw throwable;
            }
        }
        try {
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveJournal2() {
        SubDirectAccessDeviceImpl sub1;
        block12: {
            sub1 = null;
            try {
                DirectAccessDevice firstDisk;
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
                if (disks == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                if ((sub1 = this.myTestUtils.createSubDisk(firstDisk = (DirectAccessDevice)disks.get(0), "sub1", new BigInteger("1000000000"))) == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"The sub disk required for the test could not be created.");
                }
                VolumeNode journal = null;
                journal = this.myTestUtils.createJournal(this.myDefCluster, sub1, "testJournal", 80);
                if (journal == null) {
                    SimpleVolumeMgrJournalTest.fail((String)"The journal could not be created.");
                }
                String startSimple = null;
                startSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                if (startSimple == null || startSimple.equals("")) {
                    SimpleVolumeMgrJournalTest.fail((String)"There was no simple volume created for the disk.");
                }
                this.myTestUtils.removeJournal(this.myDefCluster, journal);
                String endSimple = null;
                endSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                if (endSimple == null || endSimple.equals("") || !endSimple.equals(startSimple)) {
                    SimpleVolumeMgrJournalTest.fail((String)("The simple volume was deleted or did not match the previous simple volume. The old simple volume is: " + startSimple + " and the new simple volume is: " + endSimple));
                    break block12;
                }
                SimpleVolumeMgrJournalTest.assertTrue((boolean)true);
            }
            catch (Throwable throwable) {
                block13: {
                    try {
                        this.myTestUtils.removeSubDisk(sub1);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
                throw throwable;
            }
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
        }
    }
}

