/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;

public class SimpleVolumeMgrCubeTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
        ClusterImpl clusterImpl = this.myDefCluster;
        synchronized (clusterImpl) {
            this.myDefCluster.wait(30000L);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateCube1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the sub disks.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                concat.resize(secondDisk.getCommKeyClassId(), "concat1").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the concat volume.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrCubeTest.fail((String)("Could not resize because of the following error: " + exp));
            }
            try {
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrCubeTest.fail((String)"The simple volume for the disk was not created.");
                } else {
                    SimpleVolumeMgrCubeTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrCubeTest.fail((String)"The logic did not block the action.");
            }
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    SubDirectAccessDeviceImpl sub3 = this.myTestUtils.createSubDisk(secondDisk, "sub3", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(sub3);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            SubDirectAccessDeviceImpl sub3 = this.myTestUtils.createSubDisk(secondDisk, "sub3", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(sub3);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateCube2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        SubDirectAccessDeviceImpl sub3 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            sub3 = this.myTestUtils.createSubDisk(firstDisk, "sub3", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null || sub3 == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the sub disks.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                concat.resize(sub3.getCommKeyClassId(), "concat1").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the concat volume.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrCubeTest.fail((String)("Could not resize because of the following error: " + exp));
            }
            try {
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub3.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrCubeTest.fail((String)"The simple volume for the disk was not created.");
                } else {
                    SimpleVolumeMgrCubeTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrCubeTest.fail((String)"The logic did not block the action.");
            }
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(sub3);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(sub3);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRetract1() {
        DirectAccessDevice disk1 = null;
        DirectAccessDevice disk2 = null;
        SubDirectAccessDeviceImpl subMir1 = null;
        SubDirectAccessDeviceImpl subMir2 = null;
        VolumeNode mir1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            disk1 = disks.get(0);
            disk2 = disks.get(1);
            subMir1 = this.myTestUtils.createSubDisk(disk2, "subMir1", new BigInteger("10000000"));
            subMir2 = this.myTestUtils.createSubDisk(disk2, "subMir2", new BigInteger("10000000"));
            CommKeyClassId[] children = new CommKeyClassId[]{subMir1.getCommKeyClassId(), subMir2.getCommKeyClassId()};
            mir1 = this.myTestUtils.createMirror(this.myDefCluster, children, "mir1");
            this.myTestUtils.resizeVolume(subMir1, disk1, "cube1");
            this.myTestUtils.retractVolume(this.myDefCluster, "cube1");
            if (mir1 == null) return;
        }
        catch (RemoteException e) {
            SimpleVolumeMgrCubeTest.fail((String)"Could not create the mirror needed for the test.");
            return;
        }
        try {
            this.myTestUtils.removeMirror(this.myDefCluster, mir1);
            this.myTestUtils.removeSubDisk(subMir1);
            this.myTestUtils.removeSubDisk(subMir2);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(disk1, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
            return;
        }
        catch (RemoteException e) {
            assert (false) : "Could not complete the clean up.";
            return;
        }
        finally {
            block13: {
                if (mir1 != null) {
                    try {
                        this.myTestUtils.removeMirror(this.myDefCluster, mir1);
                        this.myTestUtils.removeSubDisk(subMir1);
                        this.myTestUtils.removeSubDisk(subMir2);
                        SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(disk1, "clean1", new BigInteger("1000000000"));
                        this.myTestUtils.removeSubDisk(clean1);
                    }
                    catch (RemoteException e) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError((Object)"Could not complete the clean up.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRetract2() {
        DirectAccessDevice disk1 = null;
        SubDirectAccessDeviceImpl subMir1 = null;
        SubDirectAccessDeviceImpl subMir2 = null;
        SubDirectAccessDeviceImpl subMir3 = null;
        VolumeNode mir1 = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            disk1 = disks.get(0);
            subMir1 = this.myTestUtils.createSubDisk(disk1, "subMir1", new BigInteger("10000000"));
            subMir2 = this.myTestUtils.createSubDisk(disk1, "subMir2", new BigInteger("10000000"));
            CommKeyClassId[] children = new CommKeyClassId[]{subMir1.getCommKeyClassId(), subMir2.getCommKeyClassId()};
            mir1 = this.myTestUtils.createMirror(this.myDefCluster, children, "mir1");
            subMir3 = this.myTestUtils.createSubDisk(disk1, "subMir3", new BigInteger("10000000"));
            this.myTestUtils.resizeVolume(subMir1, subMir3, "cube1");
            this.myTestUtils.retractVolume(this.myDefCluster, "cube1");
            if (mir1 == null) return;
        }
        catch (RemoteException e) {
            SimpleVolumeMgrCubeTest.fail((String)"Could not create the mirror needed for the test.");
            return;
        }
        try {
            if (mir1 != null) {
                this.myTestUtils.removeMirror(this.myDefCluster, mir1);
            }
            if (subMir1 != null) {
                this.myTestUtils.removeSubDisk(subMir1);
            }
            if (subMir2 != null) {
                this.myTestUtils.removeSubDisk(subMir2);
            }
            if (subMir3 == null) return;
            this.myTestUtils.removeSubDisk(subMir3);
            return;
        }
        catch (RemoteException e) {
            assert (false) : "Could not complete the clean up.";
            return;
        }
        finally {
            block20: {
                if (mir1 != null) {
                    try {
                        if (mir1 != null) {
                            this.myTestUtils.removeMirror(this.myDefCluster, mir1);
                        }
                        if (subMir1 != null) {
                            this.myTestUtils.removeSubDisk(subMir1);
                        }
                        if (subMir2 != null) {
                            this.myTestUtils.removeSubDisk(subMir2);
                        }
                        if (subMir3 != null) {
                            this.myTestUtils.removeSubDisk(subMir3);
                        }
                    }
                    catch (RemoteException e) {
                        if ($assertionsDisabled) break block20;
                        throw new AssertionError((Object)"Could not complete the clean up.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChildToCube1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        DirectAccessDevice thirdDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 3);
            if (disks == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            thirdDisk = disks.get(2);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the sub disks.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                concat.resize(secondDisk.getCommKeyClassId(), "concat1").get();
                concat.resize(thirdDisk.getCommKeyClassId(), "concat1").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the concat volume.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrCubeTest.fail((String)("Could not resize because of the following error: " + exp));
            }
            try {
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, thirdDisk.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrCubeTest.fail((String)"The simple volume for the disk was not created.");
                } else {
                    SimpleVolumeMgrCubeTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrCubeTest.fail((String)"The logic did not block the action.");
            }
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    SubDirectAccessDeviceImpl sub3 = this.myTestUtils.createSubDisk(secondDisk, "sub3", new BigInteger("1000000000"));
                    SubDirectAccessDeviceImpl sub4 = this.myTestUtils.createSubDisk(thirdDisk, "sub4", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(sub3);
                    this.myTestUtils.removeSubDisk(sub4);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            SubDirectAccessDeviceImpl sub3 = this.myTestUtils.createSubDisk(secondDisk, "sub3", new BigInteger("1000000000"));
            SubDirectAccessDeviceImpl sub4 = this.myTestUtils.createSubDisk(thirdDisk, "sub4", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(sub3);
            this.myTestUtils.removeSubDisk(sub4);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChildToCube2() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        SubDirectAccessDeviceImpl sub3 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            sub3 = this.myTestUtils.createSubDisk(firstDisk, "sub3", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null || sub3 == null) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the sub disks.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                concat.resize(secondDisk.getCommKeyClassId(), "concat1").get();
                concat.resize(sub3.getCommKeyClassId(), "concat1").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not create the concat volume.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrCubeTest.fail((String)"Could not resize because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrCubeTest.fail((String)("Could not resize because of the following error: " + exp));
            }
            try {
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub3.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrCubeTest.fail((String)"The simple volume for the disk was not created.");
                } else {
                    SimpleVolumeMgrCubeTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrCubeTest.fail((String)"The logic did not block the action.");
            }
        }
        catch (Throwable throwable) {
            block18: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    SubDirectAccessDeviceImpl sub4 = this.myTestUtils.createSubDisk(secondDisk, "sub4", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(sub3);
                    this.myTestUtils.removeSubDisk(sub4);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            SubDirectAccessDeviceImpl sub4 = this.myTestUtils.createSubDisk(secondDisk, "sub4", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(sub3);
            this.myTestUtils.removeSubDisk(sub4);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }
}

