/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.SrTestUtils;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.util.CommKeyClassId;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;

public class SimpleVolumeMgrConcatTest
extends TestCase {
    private ClusterImpl myDefCluster;
    private SrTestUtils myTestUtils;

    protected void setUp() throws Exception {
        super.setUp();
        this.myTestUtils = SrTestUtils.getInstance();
        List<ClusterImpl> clusters = SrTestUtils.getInstance().getClusters();
        if (clusters.size() > 0) {
            this.myDefCluster = clusters.get(0);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateConcat1() {
        block12: {
            DirectAccessDevice firstDisk = null;
            DirectAccessDevice secondDisk = null;
            VolumeNode concat = null;
            try {
                List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
                if (disks == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
                }
                firstDisk = disks.get(0);
                secondDisk = disks.get(1);
                try {
                    CommKeyClassId[] children = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                    concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                    String firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                    String secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                    if (firstSimple == null || secondSimple == null) {
                        SimpleVolumeMgrConcatTest.fail((String)"The simple volumes for the disks were not created.");
                        break block12;
                    }
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat volume.");
                }
            }
            finally {
                block13: {
                    try {
                        if (concat != null) {
                            this.myTestUtils.removeConcat(this.myDefCluster, concat);
                        }
                        SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(firstDisk, "clean1", new BigInteger("1000000000"));
                        SubDirectAccessDeviceImpl clean2 = this.myTestUtils.createSubDisk(secondDisk, "clean2", new BigInteger("1000000000"));
                        this.myTestUtils.removeSubDisk(clean1);
                        this.myTestUtils.removeSubDisk(clean2);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError((Object)"The clean up could not be completed.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testCreateConcat2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                String firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                if (firstSimple == null || secondSimple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes for the sub disks were not created.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat volume.");
            }
        }
        catch (Throwable throwable) {
            try {
                if (concat != null) {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                }
                if (sub1 != null) {
                    this.myTestUtils.removeSubDisk(sub1);
                }
                if (sub2 == null) throw throwable;
                this.myTestUtils.removeSubDisk(sub2);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"The clean up could not be completed.");
            }
        }
        try {
            if (concat != null) {
                this.myTestUtils.removeConcat(this.myDefCluster, concat);
            }
            if (sub1 != null) {
                this.myTestUtils.removeSubDisk(sub1);
            }
            if (sub2 == null) return;
            this.myTestUtils.removeSubDisk(sub2);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testCreateConcat3() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            if (sub1 == null) {
                SimpleVolumeMgrConcatTest.fail((String)"The sub disk required for this test could not be created.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "concat1");
                String firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                String secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (firstSimple == null || secondSimple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes for the sub disks were not created.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat volume.");
            }
        }
        catch (Throwable throwable) {
            try {
                SubDirectAccessDeviceImpl clean1;
                if (concat != null) {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                }
                if ((clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"))) != null) {
                    this.myTestUtils.removeSubDisk(clean1);
                }
                if (sub1 == null) throw throwable;
                this.myTestUtils.removeSubDisk(sub1);
                throw throwable;
            }
            catch (RemoteException e) {
                e.printStackTrace();
                if ($assertionsDisabled) throw throwable;
                throw new AssertionError((Object)"The clean up could not be completed.");
            }
        }
        try {
            SubDirectAccessDeviceImpl clean1;
            if (concat != null) {
                this.myTestUtils.removeConcat(this.myDefCluster, concat);
            }
            if ((clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"))) != null) {
                this.myTestUtils.removeSubDisk(clean1);
            }
            if (sub1 == null) return;
            this.myTestUtils.removeSubDisk(sub1);
            return;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "The clean up could not be completed.";
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChildToConcat1() {
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null) {
                SimpleVolumeMgrConcatTest.fail((String)"The sub disks required for this test could not be created.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "testConcat");
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat volume");
            }
            try {
                concat.resize(secondDisk.getCommKeyClassId(), "testConcat").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not add the disk to the concat.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not add the disk to the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not add the disk to the concat because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrConcatTest.fail((String)("Could not add the disk to the concat because of the following error: " + exp));
            }
            try {
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"A simple volume for the disk was not found.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not complete the simple volume query");
            }
        }
        catch (Throwable throwable) {
            block20: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
                    this.myTestUtils.removeSubDisk(clean1);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block20;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            SubDirectAccessDeviceImpl clean1 = this.myTestUtils.createSubDisk(secondDisk, "clean1", new BigInteger("1000000000"));
            this.myTestUtils.removeSubDisk(clean1);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChildToConcat2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        SubDirectAccessDeviceImpl sub3 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            sub3 = this.myTestUtils.createSubDisk(firstDisk, "sub3", new BigInteger("1000000000"));
            if (sub1 == null || sub2 == null || sub3 == null) {
                SimpleVolumeMgrConcatTest.fail((String)"The sub disks required for this test could not be created.");
            }
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "testConcat");
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat volume");
            }
            try {
                concat.resize(sub3.getCommKeyClassId(), "testConcat").get();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not add the disk to the concat.");
            }
            catch (IllegalValueException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not add the disk to the concat.");
            }
            catch (InterruptedException exp) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not add the disk to the concat because the operation was interrupted.");
            }
            catch (ExecutionException exp) {
                SimpleVolumeMgrConcatTest.fail((String)("Could not add the disk to the concat because of the following error: " + exp));
            }
            try {
                String simple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub3.getCommKeyClassId());
                if (simple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"A simple volume for the disk was not found.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
                SimpleVolumeMgrConcatTest.fail((String)"Could not complete the simple volume query");
            }
        }
        catch (Throwable throwable) {
            block20: {
                try {
                    this.myTestUtils.removeConcat(this.myDefCluster, concat);
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                    this.myTestUtils.removeSubDisk(sub3);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block20;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeConcat(this.myDefCluster, concat);
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
            this.myTestUtils.removeSubDisk(sub3);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakConcat1() {
        SubDirectAccessDeviceImpl sub2;
        SubDirectAccessDeviceImpl sub1;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{firstDisk.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "testConcat");
            }
            catch (RemoteException e) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat.");
            }
            String firstSimple = null;
            String secondSimple = null;
            String newFirstSimple = null;
            String newSecondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (firstSimple == null || secondSimple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes were not created with the concat.");
                }
                this.myTestUtils.removeConcat(this.myDefCluster, concat);
                newFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, firstDisk.getCommKeyClassId());
                newSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (!firstSimple.equals(newFirstSimple) || !secondSimple.equals(newSecondSimple)) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes should not have changed as a result of the concat removal.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not complete the simple volume query.");
            }
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block15: {
                SubDirectAccessDeviceImpl sub12 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub12);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakConcat2() {
        SubDirectAccessDeviceImpl sub1 = null;
        SubDirectAccessDeviceImpl sub2 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 1);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            DirectAccessDevice firstDisk = disks.get(0);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            sub2 = this.myTestUtils.createSubDisk(firstDisk, "sub2", new BigInteger("1000000000"));
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), sub2.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "testConcat");
            }
            catch (RemoteException e) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat.");
            }
            String firstSimple = null;
            String secondSimple = null;
            String newFirstSimple = null;
            String newSecondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                if (firstSimple == null || secondSimple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes were not created with the concat.");
                }
                this.myTestUtils.removeConcat(this.myDefCluster, concat);
                newFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                newSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub2.getCommKeyClassId());
                if (!firstSimple.equals(newFirstSimple) || !secondSimple.equals(newSecondSimple)) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes should not have changed as a result of the concat removal.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not complete the simple volume query.");
            }
        }
        catch (Throwable throwable) {
            block15: {
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub2);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "Could not complete the clean up.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakConcat3() {
        SubDirectAccessDeviceImpl sub2;
        DirectAccessDevice firstDisk = null;
        DirectAccessDevice secondDisk = null;
        SubDirectAccessDeviceImpl sub1 = null;
        VolumeNode concat = null;
        try {
            List<DirectAccessDeviceImpl> disks = this.myTestUtils.getUnusedDisks(this.myDefCluster, 2);
            if (disks == null) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not find a disk with no simple volume and no sub disks.");
            }
            firstDisk = disks.get(0);
            secondDisk = disks.get(1);
            sub1 = this.myTestUtils.createSubDisk(firstDisk, "sub1", new BigInteger("1000000000"));
            try {
                CommKeyClassId[] children = new CommKeyClassId[]{sub1.getCommKeyClassId(), secondDisk.getCommKeyClassId()};
                concat = this.myTestUtils.createConcat(this.myDefCluster, children, "testConcat");
            }
            catch (RemoteException e) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not create the concat.");
            }
            String firstSimple = null;
            String secondSimple = null;
            String newFirstSimple = null;
            String newSecondSimple = null;
            try {
                firstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                secondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (firstSimple == null || secondSimple == null) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes were not created with the concat.");
                }
                this.myTestUtils.removeConcat(this.myDefCluster, concat);
                newFirstSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, sub1.getCommKeyClassId());
                newSecondSimple = this.myTestUtils.getSimpleVolByPhysStor(this.myDefCluster, secondDisk.getCommKeyClassId());
                if (!firstSimple.equals(newFirstSimple) || !secondSimple.equals(newSecondSimple)) {
                    SimpleVolumeMgrConcatTest.fail((String)"The simple volumes should not have changed as a result of the concat removal.");
                } else {
                    SimpleVolumeMgrConcatTest.assertTrue((boolean)true);
                }
            }
            catch (RemoteException e) {
                SimpleVolumeMgrConcatTest.fail((String)"Could not complete the simple volume query.");
            }
            sub2 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
        }
        catch (Throwable throwable) {
            block15: {
                SubDirectAccessDeviceImpl sub22 = this.myTestUtils.createSubDisk(secondDisk, "sub2", new BigInteger("1000000000"));
                try {
                    this.myTestUtils.removeSubDisk(sub1);
                    this.myTestUtils.removeSubDisk(sub22);
                }
                catch (RemoteException e) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)"Could not complete the clean up.");
                }
            }
            throw throwable;
        }
        try {
            this.myTestUtils.removeSubDisk(sub1);
            this.myTestUtils.removeSubDisk(sub2);
        }
        catch (RemoteException e) {
            assert (false) : "Could not complete the clean up.";
        }
    }
}

