/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class SimpleVolumeMgr {
    private static SimpleVolumeMgr theInstance = new SimpleVolumeMgr();
    private static SrLogger theLogger = SrLogger.getLogger();
    private HashMap<Character, VSwitchSimpleVolumeMgr> myAgentIndexToVsSimpleMgrMap = new HashMap();

    public static SimpleVolumeMgr getInstance() {
        return theInstance;
    }

    protected SimpleVolumeMgr() {
    }

    public synchronized void clear() {
        theLogger.traceEntering(null, new Object[0]);
        this.myAgentIndexToVsSimpleMgrMap.clear();
        theLogger.traceExiting(null, new Object[0]);
    }

    public synchronized void addAgentToSimpleMgrMapping(CommKeyClassId aVswitchId) {
        theLogger.traceEntering(null, aVswitchId);
        char agentIndex = aVswitchId.getMyFirstSnmpAgentIndex();
        VSwitchSimpleVolumeMgr newMgr = new VSwitchSimpleVolumeMgr(agentIndex);
        this.myAgentIndexToVsSimpleMgrMap.put(Character.valueOf(agentIndex), newMgr);
        theLogger.traceExiting(null, new Object[0]);
    }

    public synchronized void removeAgentFromSimpleMgrMapping(char aAgentId) {
        theLogger.traceEntering(null, Character.valueOf(aAgentId));
        this.myAgentIndexToVsSimpleMgrMap.remove(Character.valueOf(aAgentId));
        theLogger.traceExiting(null, new Object[0]);
    }

    private synchronized VSwitchSimpleVolumeMgr getMgrByAgent(char aAgentId) {
        theLogger.traceEntering(null, Character.valueOf(aAgentId));
        VSwitchSimpleVolumeMgr retVal = this.myAgentIndexToVsSimpleMgrMap.get(Character.valueOf(aAgentId));
        theLogger.traceExiting(null, retVal);
        return retVal;
    }

    public void addSimpleToPhysMapping(char aAgentId, String aSimpleVolId, CommKeyClassId aPhysStor) {
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), " could not be found.");
        }
        curMgr.addSimpleToPhysMapping(aSimpleVolId, aPhysStor);
    }

    public CommKeyClassId getPhysStorBySimpleVol(char aAgentId, String aSimpleVolId) {
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS " + aAgentId, " could not be found.");
            return null;
        }
        return curMgr.getPhysStorBySimpleVol(aSimpleVolId);
    }

    public String getSimpleVolByPhysStor(char aAgentId, CommKeyClassId aPhysStorData) {
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), " could not be found.");
            return null;
        }
        return curMgr.getSimpleVolByPhysStor(aPhysStorData);
    }

    void removeSimpleToPhysMapping(char aAgentId, CommKeyClassId aPhysStor) {
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), " could not be found.");
        }
        curMgr.removeSimpleToPhysMapping(aPhysStor);
    }

    void removeSimpleToPhysMapping(char aAgentId, String aVolId) {
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), "could not be found.");
        }
        curMgr.removeSimpleToPhysMapping(aVolId);
    }

    public synchronized void clear(char aAgentId) {
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), "could not be found.");
        }
        curMgr.clear();
    }

    public Set<CommKeyClassId> getAllPhysicalStorages(char aAgentId) {
        theLogger.traceEntering("", Character.valueOf(aAgentId));
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), "could not be found.");
            theLogger.traceExiting("Exiting because the manager for the given VS was not found", Collections.EMPTY_SET);
            return Collections.EMPTY_SET;
        }
        Set<CommKeyClassId> retValue = curMgr.myPhysStorToSimpleVolMap.keySet();
        theLogger.traceExiting("Normal exit", retValue);
        return retValue;
    }

    public Set<String> getAllSimpleVolumes(char aAgentId) {
        theLogger.traceEntering("", Character.valueOf(aAgentId));
        VSwitchSimpleVolumeMgr curMgr = this.getMgrByAgent(aAgentId);
        if (curMgr == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The simple manager for the VS ", Character.valueOf(aAgentId), "could not be found.");
            theLogger.traceExiting("Exiting because the manager for the given VS was not found", Collections.EMPTY_SET);
            return Collections.EMPTY_SET;
        }
        Set<String> retValue = curMgr.mySimpleVolToPhysStorMap.keySet();
        theLogger.traceExiting("Normal exit", retValue);
        return retValue;
    }

    private class VSwitchSimpleVolumeMgr {
        private HashMap<String, CommKeyClassId> mySimpleVolToPhysStorMap;
        private HashMap<CommKeyClassId, String> myPhysStorToSimpleVolMap = new HashMap();
        private char myAgentId;

        public VSwitchSimpleVolumeMgr(char aAgentId) {
            this.mySimpleVolToPhysStorMap = new HashMap();
            this.myAgentId = aAgentId;
        }

        synchronized void removeSimpleToPhysMapping(String aVolId) {
            theLogger.traceEntering(null, aVolId);
            if (aVolId == null || aVolId.equals("")) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given volume id should not be null or an empty string.");
                return;
            }
            CommKeyClassId physStor = this.mySimpleVolToPhysStorMap.remove(aVolId);
            if (physStor == null) {
                return;
            }
            String simpleVol = this.myPhysStorToSimpleVolMap.remove(physStor);
            if (simpleVol == null) {
                throw new IllegalStateException("The simple-physical mapping entry was found in one map but not in the opposite map.");
            }
            if (simpleVol.equals("")) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The simple volume found is an empty string.");
            }
            theLogger.trace(SrLogCategories.INFORMATIVE, "Removed simple volume ", simpleVol, " which was associated to physical storage ", aVolId);
            theLogger.traceExiting(null, new Object[0]);
        }

        synchronized void removeSimpleToPhysMapping(CommKeyClassId aPhysStor) {
            theLogger.traceEntering(null, aPhysStor);
            if (aPhysStor == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given volume should not be null.");
                return;
            }
            String simpleVol = this.myPhysStorToSimpleVolMap.remove(aPhysStor);
            if (simpleVol == null) {
                return;
            }
            CommKeyClassId phys = this.mySimpleVolToPhysStorMap.remove(simpleVol);
            if (phys == null) {
                throw new IllegalStateException("The simple-physical mapping entry was found in one map but not in the opposite map.");
            }
            theLogger.trace(SrLogCategories.INFORMATIVE, "Removed simple volume ", simpleVol, " which was associated to physical storage ", phys);
            theLogger.traceExiting(null, new Object[0]);
        }

        public synchronized String getSimpleVolByPhysStor(CommKeyClassId aPhysStorData) {
            theLogger.traceEntering(null, aPhysStorData);
            if (aPhysStorData == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given physical storage should not be null.");
                return null;
            }
            CommKeyClassId physStor = CommKeyUtil.getSpecificCommKeyClassId(aPhysStorData, this.myAgentId);
            String retVal = this.myPhysStorToSimpleVolMap.get(physStor);
            theLogger.traceExiting(null, retVal);
            if ((retVal == null || retVal.equals("")) && retVal != null) {
                throw new IllegalStateException("The simple volume inserted to the mapping is an empty string.");
            }
            return retVal;
        }

        public synchronized CommKeyClassId getPhysStorBySimpleVol(String aSimpleVolId) {
            theLogger.traceEntering(null, aSimpleVolId);
            if (aSimpleVolId == null) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given simple volume should not be null.");
                return null;
            }
            CommKeyClassId retVal = this.mySimpleVolToPhysStorMap.get(aSimpleVolId);
            theLogger.traceExiting(null, retVal);
            return retVal;
        }

        public synchronized void addSimpleToPhysMapping(String aSimpleVolId, CommKeyClassId aPhysStor) {
            theLogger.traceEntering(null, aSimpleVolId, aPhysStor);
            if (aSimpleVolId == null || aPhysStor == null || aSimpleVolId.equals("")) {
                theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters are null or an empty string instead of the ", "simple volume index.");
                return;
            }
            if (aSimpleVolId.equals("1.0")) {
                theLogger.warn(SrLogCategories.INFORMATIVE, "The volume is 0 therefore the simple will not be added to the mapping.");
                return;
            }
            CommKeyClassId physStorSpecificData = CommKeyUtil.getSpecificCommKeyClassId(aPhysStor, this.myAgentId);
            this.mySimpleVolToPhysStorMap.put(aSimpleVolId, physStorSpecificData);
            this.myPhysStorToSimpleVolMap.put(physStorSpecificData, aSimpleVolId);
            theLogger.traceExiting(null, new Object[0]);
        }

        public synchronized void clear() {
            theLogger.traceEntering(null, new Object[0]);
            this.myPhysStorToSimpleVolMap.clear();
            this.mySimpleVolToPhysStorMap.clear();
            theLogger.traceExiting(null, new Object[0]);
        }
    }
}

