/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.NonVirtualVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeStateConstant;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;

public class SimpleVolumeConfigurator
extends NonVirtualVolumeConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SimpleVolumeConfigurator() {
        super(ClassID.SIMPLE_VOLUME, "srVirtVolTable", MibItem.VIRTUAL_VOLUME_RS, VolumeTypeConstants.VOLUME_TYPE_SIMPLE);
    }

    public SnmpCommKey createSimpleVolume(CommKeyClassId aPhysStorData, CommKeyClassId aVSwitchData) throws SrCommException {
        theLogger.traceEntering(null, aPhysStorData, aVSwitchData);
        if (aPhysStorData == null || aVSwitchData == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters are null: aPhysStorData = ", aPhysStorData, "; aVSwitchData = ", aVSwitchData);
            return null;
        }
        char snmpAgentIndex = aVSwitchData.getMyFirstSnmpAgentIndex();
        CommKeyClassId physStorSpecificData = CommKeyUtil.getSpecificCommKeyClassId(aPhysStorData, snmpAgentIndex);
        String volId = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(snmpAgentIndex, physStorSpecificData);
        if (volId != null) {
            theLogger.trace(SrLogCategories.INFORMATIVE, "Simple volume already exists returning the existing one.");
            return new SnmpCommKey(volId, snmpAgentIndex);
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, "Creating a new simple volume.");
        CommKeyClassId[] dataInArray = new CommKeyClassId[]{physStorSpecificData};
        ConfigElementData newSimpleVolumeCed = new ConfigElementData(ClassID.SIMPLE_VOLUME);
        newSimpleVolumeCed.addParameter(new Parameter(ParameterCode.VOLUME_CHILDREN, dataInArray));
        CommKeyClassId[] vSwitchDataInArray = new CommKeyClassId[]{aVSwitchData};
        newSimpleVolumeCed.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vSwitchDataInArray));
        this.internalCreate(newSimpleVolumeCed);
        SnmpCommKey volCommKey = newSimpleVolumeCed.getSnmpKey();
        theLogger.trace(SrLogCategories.INFORMATIVE, "Adding a new simple volume mapping: simple = ", volCommKey.getKey(), "; physical = physStorSpecificData");
        SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(physStorSpecificData.getMyFirstSnmpAgentIndex(), volCommKey.getKey(), physStorSpecificData);
        return volCommKey;
    }

    public boolean removeSimpleVolumeIfNeed(CommKeyClassId aVol, CommKeyClassId aVSwitch) throws SrCommException {
        if (aVol == null || aVSwitch == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters are invalid. aVol = ", aVol, "; aVSwitch = ", aVSwitch);
            return false;
        }
        if (aVol.getClassID().equals(ClassID.DIRECT_ACCESS_DEVICE) || aVol.getClassID().equals(ClassID.SUB_DIRECT_ACCESS_DEVICE)) {
            this.removeSimpleVolume(aVol, aVSwitch.getMyFirstSnmpAgentIndex());
            return true;
        }
        return false;
    }

    public void removeSimpleVolume(String aVolId, char aSnmpAgentIndex) throws SrCommException {
        if (aVolId == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters are invalid. aVolId = ", aVolId, "; aSnmpAgentIndex = ", Character.valueOf(aSnmpAgentIndex));
            return;
        }
        String volIndex = aVolId;
        if (aVolId.indexOf(".") < 0) {
            volIndex = new String("1." + aVolId);
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, "Removing the simple volume ", volIndex);
        ConfigElementData simpleVolumeData = new ConfigElementData(new SnmpCommKey(volIndex, aSnmpAgentIndex), ClassID.SIMPLE_VOLUME);
        this.internalRemove(simpleVolumeData);
        CommKeyClassId physStor = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(aSnmpAgentIndex, volIndex);
        ConfigElementData physStorData = new ConfigElementData(physStor);
        physStorData.setValue(ParameterCode.VOLUME_STATE, VolumeStateConstant.VOLUME_STATE_NONE);
        physStorData.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(aSnmpAgentIndex));
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStorData, (Object)this);
        CommKeyClassId curPhysStorData = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(aSnmpAgentIndex, aVolId);
        theLogger.trace(SrLogCategories.INFORMATIVE, "Removing the simple-physical mapping: ", aVolId, "-", curPhysStorData);
        ConfigElementData physStorElement = new ConfigElementData(curPhysStorData.getCommKeys(), curPhysStorData.getClassID());
        CommKeyClassId vsData = CommKeyUtil.getVSwitchData(aSnmpAgentIndex);
        CommKeyUtil.getVSwitchData(aSnmpAgentIndex);
        physStorElement.setValue(ParameterCode.VSWITCH_ID, vsData);
        physStorElement.setValue(ParameterCode.VOLUME_STATE, (SrType)null);
        SrEventHandler.getEventMgr().sendChangeElementEvent(physStorElement, (Object)this);
        SimpleVolumeMgr.getInstance().removeSimpleToPhysMapping(aSnmpAgentIndex, aVolId);
        theLogger.trace(SrLogCategories.LEGACY, "Remove element ", simpleVolumeData.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(simpleVolumeData.getCommKey()));
    }

    public void removeSimpleVolume(CommKeyClassId aPhysStorData, char aSnmpAgentIndex) throws SrCommException {
        if (aPhysStorData == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters are invalid. aPhysStorData = ", aPhysStorData, "; aSnmpAgentIndex = ", Character.valueOf(aSnmpAgentIndex));
            return;
        }
        CommKeyClassId specificPhysStorData = CommKeyUtil.getSpecificCommKeyClassId(aPhysStorData, aSnmpAgentIndex);
        String volId = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(aSnmpAgentIndex, specificPhysStorData);
        if (volId == null) {
            return;
        }
        this.removeSimpleVolume(volId, aSnmpAgentIndex);
    }

    protected void readDiscoverPostOperation(ConfigElementData aElement) throws SrCommException {
        if (aElement == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "The given parameters are invalid. aElement = ", aElement);
            return;
        }
        char agentIndex = aElement.getMyFirstSnmpAgentIndex();
        String volId = aElement.getSnmpKey().getKey();
        CommKeyClassId physStorData = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(agentIndex, volId);
        if (physStorData == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "There was no physical storage found for the simple volume.");
            return;
        }
        aElement.setClassId(physStorData.getClassID());
        aElement.setCommKeys(physStorData.getCommKeys());
    }
}

