/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.exception.SrUnknownException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;

public class NonVirtualVolumeConfigurator
extends VolumeConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    protected NonVirtualVolumeConfigurator(ClassID classId, String tableName, MibItem rs, VolumeTypeConstants volType) {
        super(classId, tableName, rs, volType);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        CommKeyClassId[] obj = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        if (obj.length > 1) {
            throw new TypeMismatchException("For Non Virtual Volume, only one child is expected.");
        }
        CommKeyClassId physStoregeData = obj[0];
        SnmpCommKey physStorSnmpKey = CommKeyUtil.getSpecificSnmpKey(physStoregeData, element.getSnmpAgentFromParameter());
        if (physStorSnmpKey == null) {
            throw new MissingValueException("Non Virtual Volume Create - Missing Data of Physical Storage for Agent: " + CommKeyUtil.getIpFromIndex(element.getMyFirstSnmpAgentIndex()));
        }
        ClassID childClassId = physStoregeData.getClassID();
        boolean isChildDisk = childClassId.equals(ClassID.DIRECT_ACCESS_DEVICE) || childClassId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE) || childClassId.equals(ClassID.GENERAL_SCSI_DEVICE);
        boolean isChildSubdisk = childClassId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE);
        if (!isChildDisk && !isChildSubdisk) {
            theLogger.error(SrLogCategories.LEGACY, physStoregeData.getClassID(), " is not a valid child for non-virtual volume - " + childClassId);
            return;
        }
        CommKeyClassId alreadyExistsVolumeId = this.getVolumeOfPhysElement(new CommKeyClassId(physStorSnmpKey, physStoregeData.getClassID()));
        if (alreadyExistsVolumeId != null) {
            if (element.getClassId().equals(alreadyExistsVolumeId.getClassID())) {
                element.setCommKeyClassId(alreadyExistsVolumeId);
                return;
            }
            String msg = "The " + childClassId + " is already used by another volume";
            throw new SrUnknownException(element.getSnmpAgentFromParameter(), new CommVarBindList(), msg);
        }
        super.internalCreate(element);
        ConfigElementData physElementCED = new ConfigElementData(physStorSnmpKey, physStoregeData.getClassID());
        SnmpCommKey snmpVolKey = CommKeyUtil.getSnmpCommKey(element.getCommKey());
        String volIndex = snmpVolKey.getKey();
        String volIdStr = volIndex.substring(volIndex.indexOf(".") + 1);
        SrInteger volId = new SrInteger(volIdStr);
        if (isChildDisk) {
            physElementCED.addParameter(ParameterCode.PHYSICAL_STORAGE_VOLUME_ID, volId);
        } else if (isChildSubdisk) {
            physElementCED.addParameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_VOL_ID, volId);
        }
        ElementConfigurator physElementConf = DataMgrAOImpl.getElementConfigFromClassID(childClassId);
        physElementConf.internalChange(physElementCED);
    }

    private CommKeyClassId getVolumeOfPhysElement(CommKeyClassId physId) throws SrCommException {
        boolean isChildSubdisk;
        ClassID childClassId = physId.getClassID();
        boolean isChildDisk = childClassId.equals(ClassID.DIRECT_ACCESS_DEVICE) || childClassId.equals(ClassID.SEQUENTIAL_ACCESS_DEVICE) || childClassId.equals(ClassID.GENERAL_SCSI_DEVICE);
        if (isChildDisk == (isChildSubdisk = childClassId.equals(ClassID.SUB_DIRECT_ACCESS_DEVICE))) {
            theLogger.error(SrLogCategories.LEGACY, physId.getClassID(), " is not valid child for non-virtual volume");
            return null;
        }
        ElementConfigurator physElementConf = DataMgrAOImpl.getElementConfigFromClassID(childClassId);
        ConfigElementData physReadCED = new ConfigElementData(physId);
        ParameterCode volIdParameterCode = null;
        if (isChildDisk) {
            volIdParameterCode = ParameterCode.PHYSICAL_STORAGE_VOLUME_ID;
        } else if (isChildSubdisk) {
            volIdParameterCode = ParameterCode.SUB_DIRECT_ACCESS_DEVICE_VOL_ID;
        }
        physReadCED.addParameter(volIdParameterCode, null);
        physElementConf.read(physReadCED);
        SrInteger volId = (SrInteger)physReadCED.getValue(volIdParameterCode);
        if (volId.intValue() == 0) {
            return null;
        }
        SrType[] volType = this.readTableCells("1." + volId, physId.getMyFirstSnmpAgentIndex(), MibItem.VIRTUAL_VOLUME_TYPE);
        ClassID volClassId = VolumeConfigurator.getClassIdFromVolumeType(volType[0]);
        SnmpCommKey volSnmpKey = new SnmpCommKey("1." + volId, physId.getMyFirstSnmpAgentIndex());
        return new CommKeyClassId(volSnmpKey, volClassId);
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        super.internalRemove(element);
        VolumeOperationConfigurator volumeOperCfg = new VolumeOperationConfigurator();
        volumeOperCfg.refreshTable(element.getMyFirstSnmpAgentIndex(), null, new CheckListConfigElementData(ClassID.COPY_OPERATION));
    }
}

