/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCodes;
import java.util.HashMap;

public class MirrVolConfigElementData
extends ConfigElementData {
    private static SrLogger theLogger = SrLogger.getLogger();
    private boolean myAutoMirrSync = true;
    private CommKeyClassId myActiveVswitch = null;

    public MirrVolConfigElementData(CommKey[] key, ClassID classId, CommKeyClassId aActiveVS, boolean aAutoSync) {
        super(key, classId);
        this.assertForIllegalArgs(aActiveVS, aAutoSync);
        this.myAutoMirrSync = aAutoSync;
        this.myActiveVswitch = aActiveVS;
    }

    private void assertForIllegalArgs(CommKeyClassId aActiveVS, boolean aAutoSync) {
        if (aAutoSync && aActiveVS == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "An auto mirror sync was requested but a null active VS was given.");
        }
    }

    public MirrVolConfigElementData(ClassID classId, CommKeyClassId aActiveVS, boolean aAutoSync) {
        super(classId);
        this.assertForIllegalArgs(aActiveVS, aAutoSync);
        this.myAutoMirrSync = aAutoSync;
        this.myActiveVswitch = aActiveVS;
    }

    private MirrVolConfigElementData(CommKey[] key, ClassID classId, HashMap<ParameterCodes, Object> parameters, CommKeyClassId operInvoker, CommKeyClassId aActiveVS, boolean aAutoSync) {
        super(key, classId, parameters, operInvoker);
        this.assertForIllegalArgs(aActiveVS, aAutoSync);
        this.myAutoMirrSync = aAutoSync;
        this.myActiveVswitch = aActiveVS;
    }

    public boolean getAutoSync() {
        return this.myAutoMirrSync;
    }

    @Override
    public Object clone() {
        MirrVolConfigElementData newElement = new MirrVolConfigElementData(this.getCommKey(), this.getClassId(), this.getParametersList(), this.getOperationInvoker(), this.myActiveVswitch, this.getAutoSync());
        return newElement;
    }

    public CommKeyClassId getActiveVswitch() {
        return this.myActiveVswitch;
    }
}

