/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.volume;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.volume.VirtualVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.VolumeConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.JournalVolumeActivityConstants;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;

public class JournalVolumeConfigurator
extends VirtualVolumeConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public JournalVolumeConfigurator() {
        super(ClassID.JOURNAL_VOLUME, "srVirtVolSpecJournalTable", MibItem.VIRTUAL_VOLUME_RS, null, VolumeTypeConstants.VOLUME_TYPE_JOURNAL);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = super.getListOfParams();
        paramList.put(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_PRECENT_UTILIZATION, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_ACTIVITY, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_DATE_AND_TIME, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_OPER_STATUS, null);
        paramList.put(ParameterCode.JOURNAL_VOLUME_ERROR_STATUS, null);
        return paramList;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getSnmpAgentFromParameter();
        Object threshold = element.removeParameter(ParameterCode.JOURNAL_VOLUME_PRECENT_THRESH);
        Object activityState = element.removeParameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        if (threshold == null) {
            throw new MissingValueException("Journal Volume threshold precentage is missing for the new volume");
        }
        if (activityState == null) {
            throw new MissingValueException("Journal Volume activity state is missing for the new volume");
        }
        CommKey[][] allChildrenCommKey = this.createVolumeNoAttachVolume(element);
        SrSnmpVarBindList list = new SrSnmpVarBindList();
        SnmpCommKey actVolumeKey = element.getSnmpKey();
        SrOid activityStateOid = new SrOid(MibItem.JOURNAL_VOLUME_ACTIVITY.toString(), actVolumeKey.toString());
        SrSnmpVarBind activityStateVarBind = new SrSnmpVarBind(activityStateOid, (SrType)new SrInteger(((JournalVolumeActivityConstants)activityState).intValue()));
        list.add(activityStateVarBind);
        try {
            this.commSetList(list, agentIndex);
        }
        catch (SrCommException e) {
            theLogger.error(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
            this.internalRemove(element);
            throw e;
        }
        list.clear();
        this.attachVolumeToChildren(element, allChildrenCommKey);
        CommKeyClassId[] children = (CommKeyClassId[])element.getValue(ParameterCode.VOLUME_CHILDREN);
        this.readVolumePosition(children, element.getCommKeyClassId());
        SnmpCommKey volumeKey = element.getSnmpKey();
        SrOid thresholdOid = new SrOid(MibItem.JOURNAL_VOLUME_PRECENT_THRESH.toString(), volumeKey.toString());
        SrSnmpVarBind thresholdVarBind = new SrSnmpVarBind(thresholdOid, (SrType)((SrInteger)threshold));
        list.add(thresholdVarBind);
        try {
            this.commSetList(list, agentIndex);
        }
        catch (SrCommException e) {
            theLogger.error(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
            this.internalRemove(element);
            throw e;
        }
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        CommKeyClassId vswitchCommKeyClassId = CommKeyUtil.getVSwitchData(element.getMyFirstSnmpAgentIndex());
        if (element.containsParameter(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID)) {
            CommKeyClassId vswitchActiveOnCommKeyClassId = (CommKeyClassId)element.removeParameter(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID);
            if (vswitchCommKeyClassId.equals(vswitchActiveOnCommKeyClassId)) {
                element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY, JournalVolumeActivityConstants.ACTIVE));
            } else {
                element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVITY, JournalVolumeActivityConstants.INACTIVE));
            }
        }
        super.internalChange(element);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommException {
        super.readDiscoverPostOperation(element, rowList);
        JournalVolumeActivityConstants activeState = (JournalVolumeActivityConstants)element.getValue(ParameterCode.JOURNAL_VOLUME_ACTIVITY);
        if (activeState != null && activeState.equals(JournalVolumeActivityConstants.ACTIVE)) {
            element.addParameter(new Parameter(ParameterCode.JOURNAL_VOLUME_ACTIVE_ON_VSWITCH_ID, CommKeyUtil.getVSwitchData(element.getMyFirstSnmpAgentIndex())));
        }
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        try {
            super.trapProccessingPostOperation(element, trap);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (trap.getTrapType().getTrapId() != 24) {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
        theLogger.trace(SrLogCategories.LEGACY, "JournalVolumeConfigurator: Journal volume load above threshold !");
        SrEventHandler.getEventMgr().sendChangeElementEvent(element, (Object)trap);
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 24: {
                return MibItem.JOURNAL_VOLUME_PRECENT_UTILIZATION;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    public ConfigElementDataList refreshJournalVolumesTable(char snmpAgentIndex) throws SrCommException {
        ConfigElementDataList virtVolList = new ConfigElementDataList();
        VolumeConfigurator volumeConfigurator = new VolumeConfigurator();
        virtVolList = volumeConfigurator.getAllExtended(snmpAgentIndex, null, CheckListConfigElementData.NO_CHECK_LIST_NEEDED);
        if (virtVolList.size() > 0) {
            this.removeNonJournalVolumesFromList(virtVolList);
        }
        return virtVolList;
    }

    private void removeNonJournalVolumesFromList(ConfigElementDataList virtVolList) {
        ConfigElementDataList journalVolList = new ConfigElementDataList();
        for (int index = 0; index < virtVolList.size(); ++index) {
            ConfigElementData element = (ConfigElementData)virtVolList.getElementDataAt(index);
            if (!element.getClassId().equals(ClassID.JOURNAL_VOLUME)) continue;
            journalVolList.add(element);
        }
        virtVolList.clear();
        virtVolList.addAll(journalVolList);
    }
}

