/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.target;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrCounter32;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.constants.ISCSITargetLoginFailureTypeConstant;
import java.util.HashMap;

public class IscsiTargetLoginFailureConfigurator
extends ElementConfigurator {
    public IscsiTargetLoginFailureConfigurator() {
        super(ClassID.ISCSI_TARGET, "iscsiTargetAttributesTable", null, null);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE, null);
        paramList.put(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, null);
        paramList.put(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, null);
        paramList.put(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, null);
        paramList.put(ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        super.readDiscoverPostOperation(element, list);
        SrCounter32 numOfLoginFailures = (SrCounter32)element.getValue(ParameterCode.ISCSI_TARGET_NUM_OF_LOGIN_FAILURE);
        boolean noFailureHasHappenInThePast = numOfLoginFailures.longValue() == 0L;
        SrTimeTicks lastLoginFailureTimeTicks = (SrTimeTicks)element.getValue(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME);
        SrDateAndTime dateAndTimeLastLoginFailure = this.getDate(element.getSnmpAgentFromParameter(), lastLoginFailureTimeTicks);
        element.setValue(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TIME, dateAndTimeLastLoginFailure);
        SrOidType targetLoginFailureTypeOid = (SrOidType)element.getValue(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE);
        ISCSITargetLoginFailureTypeConstant targetLoginFailureTypeConst = ISCSITargetLoginFailureTypeConstant.getFailureType(targetLoginFailureTypeOid);
        element.setValue(ParameterCode.ISCSI_TARGET_LAST_FAILURE_TYPE, targetLoginFailureTypeConst);
        if (noFailureHasHappenInThePast) {
            element.setValue(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME, new SrString("N/A"));
            element.setValue(ParameterCode.ISCSI_TARGET_LAST_FAILED_INITIATOR_IP, new SrString("N/A"));
        }
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) {
        throw new IllegalStateException(this.getClass() + "doesn't supply an index-next");
    }
}

