/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.DsnmpUtil;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ScsiPortConfigurator;
import com.sanrad.nms.server.mgr.ScsiTargetDeviceConfigurator;
import com.sanrad.nms.server.mgr.ScsiTransportConfigurator;
import com.sanrad.nms.server.mgr.acl.TargetAuthorizationConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredAttrExtentConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsConfigurator;
import com.sanrad.nms.server.mgr.identity.CHAPCredentialsExtensionConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityConfigurator;
import com.sanrad.nms.server.mgr.identity.IdentityXConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTargetLoginFailureConfigurator;
import com.sanrad.nms.server.mgr.target.ScsiTargetPortsConfigurator;
import com.sanrad.nms.server.mgr.target.TargetConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrOidType;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;

public class IscsiTargetConfigurator
extends TargetConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public IscsiTargetConfigurator() {
        super(ClassID.ISCSI_TARGET, "srIscsiTgtTable", MibItem.ISCSI_TARGET_RS, MibItem.ISCSI_TARGET_TBL_LAST_UPDATE);
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        ScsiTargetPortsConfigurator portConfig = new ScsiTargetPortsConfigurator();
        portConfig.stimulateRefresh(element.getSnmpAgentFromParameter());
        if (element.getValue(ParameterCode.ISCSI_TARGET_NAME) == null) {
            throw new MissingValueException("IscsI Target must have a target WWUI name");
        }
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        SrOid nextIndexOid = new SrOid(MibItem.ISCSI_TARGET_NEXT_INDEX.toString(), "0");
        SrSnmpVarBind nextIndexVarBind = new SrSnmpVarBind(nextIndexOid, null);
        CommVarBindList vbList = new CommVarBindList();
        vbList.add(nextIndexVarBind);
        this.commGetList(vbList, snmpAgentIndex);
        int index = vbList.indexOf(nextIndexVarBind);
        Integer nextIndex = (Integer)((SrInteger)((SrSnmpVarBind)vbList.elementAt(index)).getValue()).value();
        SnmpCommKey key = new SnmpCommKey("1.1." + nextIndex.toString(), snmpAgentIndex);
        element.setCommKey(key);
        Object alias = element.getValue(ParameterCode.ISCSI_TARGET_ALIAS);
        if (alias == null || alias.equals("")) {
            SrString newAlias = new SrString("Tgt_" + key.toString().substring(key.toString().lastIndexOf(".") + 1));
            element.setValue(ParameterCode.ISCSI_TARGET_ALIAS, newAlias);
        }
        Object defaultAccess = element.removeParameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS);
        super.internalCreate(element);
        if (defaultAccess != null) {
            element.addParameter(new Parameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS, defaultAccess));
        }
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_TARGET_ALIAS, null);
        paramList.put(ParameterCode.ISCSI_TARGET_DEFAULT_EXPOSE_ON, null);
        paramList.put(ParameterCode.ISCSI_TARGET_NAME, null);
        paramList.put(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, null);
        return paramList;
    }

    @Override
    public boolean readAfterCreate(ConfigElementData element) throws SrCommException {
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        if (element.getClassId().equals(ClassID.ISCSI_TARGET)) {
            super.readAfterCreate(element);
            this.readSCSITargetId(element);
            this.readSCSITargetData(element);
            this.readTargetLoginFailureData(element);
            Object vswitchId = element.getValue(ParameterCode.VSWITCH_ID);
            ConfigElementData identityParent = this.readTargetCredIdentity(element);
            if (identityParent != null) {
                identityParent.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchId));
                ConfigElementData credentials = this.readTargetCredentials(identityParent);
                credentials.addParameter(new Parameter(ParameterCode.VSWITCH_ID, vswitchId));
                ConfigElementData targetSCSIPort = this.readTargetPort(element);
                SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)this);
                SrEventHandler.getEventMgr().sendAddElementEvent(targetSCSIPort, (Object)this);
                SrEventHandler.getEventMgr().sendAddElementEvent(identityParent, (Object)this);
                SrEventHandler.getEventMgr().sendAddElementEvent(credentials, (Object)this);
            }
            SnmpCommKey targetCommKeys = CommKeyUtil.getSpecificSnmpKey(element.getCommKey(), agentIndex);
            String targetKey = targetCommKeys.getKey();
            String prefix = targetKey.substring(targetKey.indexOf(".") + 1);
            CommVarBindList list = new CommVarBindList();
            list.add(new SrSnmpVarBind(MibItem.ACL_ENTRY_POSITION.toString()));
            CommVarBindList[] varBinds = this.commGetListsByKeyPrefix(list, prefix, agentIndex);
            String key = null;
            if (varBinds != null && varBinds.length > 0) {
                for (int i = 0; i < varBinds.length; ++i) {
                    CommVarBind varBind = (CommVarBind)varBinds[i].elementAt(0);
                    SrInteger value = (SrInteger)varBind.getValue();
                    if (value.intValue() != 0) continue;
                    key = varBind.getIndexForCommKey();
                    break;
                }
            }
            if (key == null) {
                theLogger.error(SrLogCategories.LEGACY, "Default ACL entry not found for target ", targetCommKeys);
            } else {
                SnmpCommKey defAclEntryCommKey = new SnmpCommKey(key, agentIndex);
                theLogger.trace(SrLogCategories.LEGACY, "Trying to read default acl entry: ", key);
                ConfigElementData aclElement = new ConfigElementData(defAclEntryCommKey, ClassID.ACL_ENTRY);
                aclElement.addParameter(new Parameter(ParameterCode.VSWITCH_ID, element.getValue(ParameterCode.VSWITCH_ID)));
                TargetAuthorizationConfigurator configurator = new TargetAuthorizationConfigurator();
                configurator.readAfterCreate(aclElement);
                if (element.containsParameter(ParameterCode.ISCSI_TARGET_DEFAULT_ACCESS)) {
                    boolean success = configurator.createDefaultAccessForTarget(element, aclElement);
                    if (success) {
                        theLogger.trace(SrLogCategories.LEGACY, "Default Acl entry was read for new target.");
                    } else {
                        theLogger.trace(SrLogCategories.LEGACY, "FAILED to read default acl entry for new target.");
                    }
                }
                SrEventHandler.getEventMgr().sendAddElementEvent(aclElement, (Object)this);
            }
        }
        return true;
    }

    private void readSCSITargetId(ConfigElementData element) throws SrCommException {
        String iscsiNodeKey = element.getCommKeyClassId().getCommKeys()[0].getKey().substring(2);
        SnmpCommKey iscsiNodeCommKey = new SnmpCommKey(iscsiNodeKey, element.getSnmpAgentFromParameter());
        ConfigElementData tempElementForReadOnly = new ConfigElementData(iscsiNodeCommKey, element.getClassId());
        tempElementForReadOnly.addParameter(new Parameter(ParameterCode.ISCSI_TARGET_TRANSPORT_TYPE));
        this.internalReadFields(tempElementForReadOnly);
        SrOidType scsiOidOfTarget = (SrOidType)tempElementForReadOnly.getValue(ParameterCode.ISCSI_TARGET_TRANSPORT_TYPE);
        String scsiTargetTransportKey = scsiOidOfTarget.getIndexFromOidType(ScsiTransportConfigurator.SCSI_NODE_INDEX_OID);
        String scsiTargetKey = scsiTargetTransportKey.substring(0, scsiTargetTransportKey.lastIndexOf("."));
        CommKeyClassId scsiTargetCommKeyClassId = new CommKeyClassId(new SnmpCommKey(scsiTargetKey, element.getSnmpAgentFromParameter()), ClassID.SCSI_TARGET);
        element.addParameter(new Parameter(ParameterCode.SCSI_DEVICE_ID, scsiTargetCommKeyClassId));
    }

    private ConfigElementData readTargetCredIdentity(ConfigElementData element) throws SrCommException {
        IdentityConfigurator identConfig = new IdentityConfigurator();
        ConfigElementDataList identities = identConfig.getAll(element.getSnmpAgentFromParameter(), null, null);
        IdentityXConfigurator identxConfig = new IdentityXConfigurator();
        ConfigElementDataList identitiesExtensions = identxConfig.getAll(element.getSnmpAgentFromParameter(), null, null);
        super.mergeElementLists(identities, identitiesExtensions, true);
        int listSize = identities.size();
        SrString targetAlias = (SrString)element.getValue(ParameterCode.ISCSI_TARGET_ALIAS);
        for (int i = 0; i < listSize; ++i) {
            ConfigElementData identElement = (ConfigElementData)identities.get(i);
            SrString alias = (SrString)identElement.getValue(ParameterCode.IDENTITY_ALIAS);
            if (alias == null || targetAlias == null || !alias.equals(targetAlias)) continue;
            identElement.setClassId(ClassID.IDENTITY);
            return identElement;
        }
        theLogger.info(SrLogCategories.LEGACY, "Couldn't find the target credentials for target - ", element);
        return null;
    }

    private void readSCSITargetData(ConfigElementData element) throws SrCommException {
        CommKeyClassId scsiTargetCommKeyClassID = (CommKeyClassId)element.getValue(ParameterCode.SCSI_DEVICE_ID);
        ConfigElementData scsiTargetElement = new ConfigElementData(scsiTargetCommKeyClassID);
        ScsiTargetDeviceConfigurator scsiTargetConfigurator = new ScsiTargetDeviceConfigurator();
        scsiTargetConfigurator.internalReadOnTargetCreation(scsiTargetElement);
        element.addParameter(scsiTargetElement.getParametersList());
    }

    private void readTargetLoginFailureData(ConfigElementData element) throws SrCommException {
        IscsiTargetLoginFailureConfigurator loginFailureConfigurator = new IscsiTargetLoginFailureConfigurator();
        ConfigElementDataList loginFailuresElements = loginFailureConfigurator.getAll(element.getSnmpAgentFromParameter(), null, null);
        for (int i = 0; i < loginFailuresElements.size(); ++i) {
            ConfigElementData loginFailureElement = (ConfigElementData)loginFailuresElements.getElementDataAt(i);
            String loginFailureElementKey = loginFailureElement.getSnmpKey().getKey();
            String targetKey = element.getSnmpKey().getKey();
            if (!targetKey.endsWith(loginFailureElementKey)) continue;
            element.addParameter(loginFailureElement.getParametersList());
            return;
        }
    }

    private ConfigElementData readTargetPort(ConfigElementData element) throws SrCommException {
        CommKeyClassId scsiTargetCommKeyClassId = (CommKeyClassId)element.getValue(ParameterCode.SCSI_DEVICE_ID);
        String scsiTargetKey = scsiTargetCommKeyClassId.getCommKeys()[0].getKey();
        ScsiPortConfigurator portConfig = new ScsiPortConfigurator();
        ConfigElementDataList ports = portConfig.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
        ConfigElementDataList targetPorts = new ConfigElementDataList();
        for (ElementData portElement : ports) {
            String portTargetKey;
            if (!portElement.getClassId().equals(ClassID.SCSI_TARGET_PORT) || !(portTargetKey = portElement.getCommKeyClassId().getCommKeys()[0].getKey()).startsWith(scsiTargetKey)) continue;
            targetPorts.add(portElement);
        }
        if (!targetPorts.isEmpty()) {
            return (ConfigElementData)targetPorts.get(0);
        }
        return null;
    }

    private ConfigElementData readTargetCredentials(ConfigElementData identElement) throws SrCommException {
        CommKey[] commkeys = identElement.getCommKey();
        SnmpCommKey commKey = new SnmpCommKey(commkeys[0].getKey() + ".1", identElement.getSnmpAgentFromParameter());
        ConfigElementData credElement = new ConfigElementData(commKey, ClassID.CHAP_CREDENTIALS);
        CHAPCredentialsConfigurator chapConfig = new CHAPCredentialsConfigurator();
        credElement.setClassId(ClassID.CHAP_CREDENTIALS);
        chapConfig.readAfterCreate(credElement);
        CHAPCredentialsExtensionConfigurator chapXConfig = new CHAPCredentialsExtensionConfigurator();
        chapXConfig.readAfterCreate(credElement);
        CHAPCredAttrExtentConfigurator attrConfig = new CHAPCredAttrExtentConfigurator();
        attrConfig.readAfterCreate(credElement);
        return credElement;
    }

    @Override
    public boolean readAfterChange(ConfigElementData element) throws SrCommException {
        return super.readAfterChange(element);
    }

    @Override
    public void refreshElement(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
        super.refreshElement(element, retrievedElements);
        this.readAfterCreate(element);
    }

    @Override
    public ConfigElementDataList refreshTable(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList targets = this.getAllExtended(snmpAgentIndex, lastUpdate, checkListElement);
        if (targets != null) {
            for (ConfigElementData current : targets) {
                this.readAfterCreate(current);
            }
        }
        return targets;
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList targetsList = this.getAllExtended(snmpAgentIndex, null, null);
        if (targetsList.size() > 0) {
            this.sendDiscoveredElementsToEventMgr(targetsList, vSwitchData);
        }
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList targetsList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (targetsList != null && targetsList.size() > 0) {
            IscsiTargetLoginFailureConfigurator loginFailureConfigurator = new IscsiTargetLoginFailureConfigurator();
            ConfigElementDataList loginFailureTargetsList = loginFailureConfigurator.getAll(snmpAgentIndex, lastUpdate, checkListElement);
            this.mergeElementLists(targetsList, loginFailureTargetsList, false);
        }
        return targetsList;
    }

    @Override
    protected void mergeElementLists(ConfigElementDataList mainList, ConfigElementDataList secondList, boolean setClassId) {
        try {
            for (ElementData secondaryED : secondList) {
                ConfigElementData secondElem = (ConfigElementData)secondaryED;
                String secondElemKey = secondElem.getSnmpKey().getKey();
                String keyWithStorageDomain = "1." + secondElemKey;
                ElementData matchingMainElem = null;
                for (ElementData mainED : mainList) {
                    ConfigElementData currentMainElem = (ConfigElementData)mainED;
                    String mainElemKey = currentMainElem.getSnmpKey().getKey();
                    if (!mainElemKey.equals(keyWithStorageDomain)) continue;
                    matchingMainElem = currentMainElem;
                    break;
                }
                ElementData tmp = null;
                if (matchingMainElem == null) {
                    theLogger.logAndAssert(SrLogCategories.ERROR, "Extension entry without a main table entry. Ext: " + secondElem + "; mainList: " + mainList);
                    continue;
                }
                matchingMainElem.addParameter(secondElem.getParametersList());
                tmp = matchingMainElem;
                if (!setClassId) continue;
                tmp.setClassId(this.myClassId);
            }
        }
        catch (RuntimeException e) {
            String msg = "Merge Failed at: " + CommKeyUtil.getKeyForMessage(((ConfigElementData)mainList.get(0)).getCommKey());
            theLogger.trace(SrLogCategories.LEGACY, e, msg);
            throw e;
        }
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 22: {
                return MibItem.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME;
            }
        }
        return super.getCommItemForTrapCommKey(trap);
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        if (trap.getTrapType().getTrapId() != 22) {
            throw new UnsupportedOperationException("Operation not supported for trap " + trap.toString());
        }
        theLogger.trace(SrLogCategories.LEGACY, "IscsiTargetConfigurator: Remote Initiator failed to login to a local target!");
        SrString remoteInitiatorName = (SrString)element.getValue(ParameterCode.ISCSI_TARGET_LAST_INITIATOR_FAILURE_NAME);
        ConfigElementDataList elements = this.getAllExtended(element.getSnmpAgentFromParameter(), null, null);
        ConfigElementData remoteInitiatorElement = this.getRemoteInitiatorElementByName(elements, remoteInitiatorName.toString());
        SrEventHandler.getEventMgr().sendChangeElementEvent(remoteInitiatorElement, (Object)trap);
    }

    private ConfigElementData getRemoteInitiatorElementByName(ConfigElementDataList elements, String remoteInitiatorName) {
        for (ElementData element : elements) {
            SrString currentRemoteInitiatorName;
            ClassID classId = element.getClassId();
            if (!classId.equals(ClassID.ISCSI_REMOTE_INITIATOR) || !(currentRemoteInitiatorName = (SrString)element.getValue(ParameterCode.ISCSI_REMOTE_INITIATOR_NAME)).toString().equals(remoteInitiatorName)) continue;
            return (ConfigElementData)element;
        }
        return null;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return this.getNextMIBIndex(aElement.getCommKeyClassId(), MibItem.ISCSI_TARGET_NEXT_INDEX);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String index;
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        SrOidType qosOid = (SrOidType)element.removeValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID);
        if (qosOid != null && (index = DsnmpUtil.getRowIndexFromOidComponents((long[])qosOid.value())) != null) {
            if (!index.equals("0")) {
                CommKeyClassId qosId = CommKeyUtil.createCommKeyClassId(ClassID.ISCSI_TARGET_QOS_GROUP, index, agentIndex);
                element.setValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, qosId);
            } else {
                element.setValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, (SrType)null);
            }
        }
    }

    @Override
    public void internalChange(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getSnmpAgentFromParameter();
        if (aElement.containsParameter(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID)) {
            CommKeyClassId qosGroupId = (CommKeyClassId)aElement.removeValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID);
            if (qosGroupId != null) {
                String qosGroupIndex = CommKeyUtil.getSpecificCommKey(qosGroupId, agentIndex).getKey();
                long[] oidComps = DsnmpUtil.convertMibNameToOidComponents(MibItem.TARGET_QOS_GROUP_INDEX.toString(), qosGroupIndex);
                SrOidType qosOid = new SrOidType(oidComps);
                aElement.setValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, qosOid);
            } else {
                long[] oidComps = DsnmpUtil.convertMibNameToOidComponents(MibItem.TARGET_QOS_GROUP_INDEX.toString(), "0");
                SrOidType qosOid = new SrOidType(oidComps);
                aElement.setValue(ParameterCode.ISCSI_TARGET_QOS_GROUP_ID, qosOid);
            }
        }
        super.internalChange(aElement);
    }
}

