/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.target;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.target.IscsiTgtPortalConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.IscsiPortalRolesConstant;
import java.util.HashMap;

public class IscsiPortalConfigurator
extends ElementConfigurator {
    private static final String TARGET_ROLE_BITS_CONST = "10000000";
    private static SrLogger theLogger = SrLogger.getLogger();
    static Integer[] lastPortalIndex = new Integer[0];

    public IscsiPortalConfigurator() {
        super(ClassID.PORTAL, "iscsiPortalAttributesTable", MibItem.ISCSI_PORTAL_RS, MibItem.ISCSI_TARGET_TBL_LAST_UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        String portalIndices = element.getSnmpKey().toString();
        Integer portalIndex = new Integer(portalIndices.substring(portalIndices.lastIndexOf(".") + 1));
        char agentIndex = element.getMyFirstSnmpAgentIndex();
        Integer[] integerArray = lastPortalIndex;
        synchronized (lastPortalIndex) {
            if (lastPortalIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastPortalIndex, 0, newArray, 0, lastPortalIndex.length);
                newArray[agentIndex] = portalIndex;
                lastPortalIndex = newArray;
            } else if (lastPortalIndex[agentIndex] == null || portalIndex > lastPortalIndex[agentIndex]) {
                IscsiPortalConfigurator.lastPortalIndex[agentIndex] = portalIndex;
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        theLogger.info(SrLogCategories.INFORMATIVE, "internal create starts");
        SrType portNumber = (SrType)element.getValue(ParameterCode.ISCSI_PORTAL_PORT);
        if (portNumber == null) {
            throw new MissingValueException("Portal creation: Missing value for Port number");
        }
        Integer[] integerArray = lastPortalIndex;
        synchronized (lastPortalIndex) {
            char agentIndex = element.getSnmpAgentFromParameter();
            if (lastPortalIndex.length <= agentIndex) {
                Integer[] newArray = new Integer[agentIndex + '\u0001'];
                System.arraycopy(lastPortalIndex, 0, newArray, 0, lastPortalIndex.length);
                newArray[agentIndex] = new Integer(0);
                lastPortalIndex = newArray;
            } else if (lastPortalIndex[agentIndex] == null) {
                IscsiPortalConfigurator.lastPortalIndex[agentIndex] = new Integer(0);
            }
            this.getAll(agentIndex, null, null);
            Integer newIndex = new Integer(lastPortalIndex[agentIndex] + 1);
            element.setCommKey(new SnmpCommKey("1." + newIndex.toString(), agentIndex));
            element.removeParameter(ParameterCode.ISCSI_PORTAL_PORT);
            super.internalCreate(element);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ConfigElementData exData = new ConfigElementData(element.getCommKey(), element.getClassId());
            exData.addParameter(new Parameter(ParameterCode.ISCSI_PORTAL_PORT, portNumber));
            IscsiTgtPortalConfigurator tgtPortalConfig = new IscsiTgtPortalConfigurator();
            try {
                tgtPortalConfig.internalChange(exData);
            }
            catch (SrCommException e) {
                theLogger.error(SrLogCategories.ERROR, "rolling back after: ", e.getMessage());
                this.internalRemove(element);
                throw e;
            }
            theLogger.info(SrLogCategories.INFORMATIVE, "internal create finishes");
            return;
        }
    }

    @Override
    protected void addCommVarBindsToCreateList(CommVarBindList list, ConfigElementData element) {
        SnmpCommKey portalSnmpKey = element.getSnmpKey();
        SrOid portalRolesOid = new SrOid(MibItem.ISCSI_PORTAL_ROLES.toString(), portalSnmpKey.toString());
        list.add(new SrSnmpVarBind(portalRolesOid, (SrType)IscsiPortalRolesConstant.TARGET));
    }

    @Override
    public void discover(CommKeyClassId vSwitchData) throws SrCommException {
        char snmpAgentIndex = vSwitchData.getMyFirstSnmpAgentIndex();
        ConfigElementDataList elementsList = this.getAllExtended(snmpAgentIndex, null, null);
        this.sendDiscoveredElementsToEventMgr(elementsList, vSwitchData);
    }

    @Override
    public ConfigElementDataList getAllExtended(char snmpAgentIndex, SrTimeTicks lastUpdate, CheckListConfigElementData checkListElement) throws SrCommException {
        ConfigElementDataList elementsList = this.getAll(snmpAgentIndex, lastUpdate, checkListElement);
        if (elementsList != null && elementsList.size() > 0) {
            IscsiTgtPortalConfigurator tgtPortalConfig = new IscsiTgtPortalConfigurator();
            ConfigElementDataList tgtPortalList = tgtPortalConfig.getAll(snmpAgentIndex, lastUpdate, null);
            this.mergeElementLists(elementsList, tgtPortalList, true, true);
        }
        return elementsList;
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.ISCSI_PORTAL_IP_ADDRESS, null);
        paramList.put(ParameterCode.ISCSI_PORTAL_PORT, null);
        paramList.put(ParameterCode.ISCSI_PORTAL_ROLE, null);
        return paramList;
    }

    private void refreshDependedTables(char snmpAgent) throws SrCommException {
        SCSIRemoteTargetConfigurator remoteTargetCfg = new SCSIRemoteTargetConfigurator();
        remoteTargetCfg.refreshRemoteTargetsForDependantOnOperations(snmpAgent);
    }

    @Override
    public void postSendCreateEvent(ConfigElementData element) throws SrCommException {
        theLogger.info(SrLogCategories.INFORMATIVE, "postSendCreateEvent() started");
        char snmpAgent = element.getSnmpAgentFromParameter();
        this.refreshDependedTables(snmpAgent);
        theLogger.info(SrLogCategories.INFORMATIVE, "postSendCreateEvent() started");
    }

    @Override
    public void postSendRemoveEvent(ConfigElementData element) throws SrCommException {
        char snmpAgent = element.getMyFirstSnmpAgentIndex();
        this.refreshDependedTables(snmpAgent);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return IscsiPortalConfigurator.getNextIncrementalIndex(aElement.getCommKeyClassId());
    }
}

