/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.exception.MissingValueException;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.storage.AbstractPhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;

public class SubDirectAccessDeviceConfigurator
extends AbstractPhysicalStorageConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();

    public SubDirectAccessDeviceConfigurator() {
        super(ClassID.SUB_DIRECT_ACCESS_DEVICE, "srPhysDiskSplitTable", MibItem.SUB_DIRECT_ACCESS_DEVICE_RS, MibItem.SUB_DIRECT_ACCESS_DEVICE_TABLE_LAST_UPDATE, true);
    }

    ConfigElementDataList discoverAll(CommKeyClassId vSwitchData) throws SrCommException {
        ConfigElementDataList subDiskList = this.getAll(vSwitchData.getMyFirstSnmpAgentIndex(), null, null);
        return subDiskList;
    }

    private void addSubdiskSimpleVolMapping(ConfigElementData aSubdiskData, char aAgentIndex) {
        SrType curVal = (SrType)aSubdiskData.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_VOL_ID);
        if (curVal != null && !(curVal instanceof SrInteger)) {
            theLogger.logAndAssert(SrLogCategories.ERROR, "DB Corruption found! The field SrPhysDiskSplitVolId in the ", "srPhysDiskSplitTable table should be an integer.");
            return;
        }
        int simpleId = ((SrInteger)curVal).intValue();
        if (simpleId == 0) {
            return;
        }
        SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(aAgentIndex, "1." + simpleId, aSubdiskData.getCommKeyClassId());
    }

    private CommKey[] createDiskKeyFromSubDiskKey(CommKey[] subDiskKey) {
        CommKey[] newKey = new CommKey[subDiskKey.length];
        int newKeyIndex = 0;
        String diskKey = null;
        for (int i = 0; i < subDiskKey.length; ++i) {
            if (((CommKeyFetcher)((Object)subDiskKey[i])).getSnmpCommKey() == null) continue;
            String indices = subDiskKey[i].getKey();
            int firstDot = indices.indexOf(".");
            String tmp = indices.substring(firstDot + 1);
            int secondDot = tmp.indexOf(".");
            diskKey = indices.substring(0, firstDot + secondDot + 1);
            newKey[newKeyIndex++] = new SnmpCommKey(diskKey, ((CommKeyFetcher)((Object)subDiskKey[i])).getSnmpCommKey().getSnmpAgentIndex());
        }
        if (newKeyIndex == subDiskKey.length) {
            return newKey;
        }
        if (newKeyIndex > 0) {
            CommKey[] resizedNewKey = new CommKey[newKeyIndex];
            System.arraycopy(newKey, 0, resizedNewKey, 0, newKey.length);
            return resizedNewKey;
        }
        return null;
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        SrLunFormat endAddress = (SrLunFormat)element.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR);
        CommKeyClassId diskData = (CommKeyClassId)element.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID);
        CommKeyClassId diskSpecificData = CommKeyUtil.getSpecificCommKeyClassId(diskData, snmpAgentIndex);
        if (diskSpecificData == null) {
            throw new MissingValueException("SubDisk Create - Missing Data of Physical Storage for Agent: " + CommKeyUtil.getIpFromIndex(snmpAgentIndex));
        }
        SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
        simpleCnf.removeSimpleVolume(diskSpecificData, snmpAgentIndex);
        CommKey[] diskKeys = diskSpecificData.getCommKeys();
        SnmpCommKey snmpKey = CommKeyUtil.getSnmpCommKey(diskKeys);
        SnmpCommKey snmpSubDiskKey = new SnmpCommKey(snmpKey.toString() + "." + endAddress.toSNMPIndexString(), snmpAgentIndex);
        element.setCommKey(snmpSubDiskKey);
        Object alias = element.getValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS);
        if (alias == null || alias.equals("")) {
            String subDiskIndex = endAddress.toString();
            for (int i = 0; i < subDiskIndex.length(); ++i) {
                if (subDiskIndex.charAt(i) == '0') continue;
                subDiskIndex = subDiskIndex.substring(i);
                break;
            }
            String tmpStr = snmpSubDiskKey.toString().substring(snmpSubDiskKey.toString().indexOf(".") + 1);
            String parentIndex = tmpStr.substring(0, tmpStr.indexOf("."));
            SrString newAlias = new SrString("Split_" + subDiskIndex + "_disk" + parentIndex);
            element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, newAlias);
        }
        super.internalCreate(element);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        HashMap<ParameterCodes, Object> paramList = new HashMap<ParameterCodes, Object>();
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_INFO, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_OPER_STATUS, null);
        paramList.put(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LAST_UPDATE, null);
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommException {
        String endAddress = null;
        CommKey[] diskKeys = this.createDiskKeyFromSubDiskKey(element.getCommKey());
        for (int i = 0; i < diskKeys.length; ++i) {
            if (((CommKeyFetcher)((Object)diskKeys[i])).getSnmpCommKey() == null) continue;
            int diskIndexLen = diskKeys[i].toString().length();
            endAddress = element.getCommKey()[i].getKey().substring(diskIndexLen + 1);
        }
        element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, new CommKeyClassId(diskKeys, ClassID.DIRECT_ACCESS_DEVICE));
        SrLunFormat endAddressInLunFormat = new SrLunFormat();
        endAddressInLunFormat.setValWithIntDotString(endAddress);
        element.setValue(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, endAddressInLunFormat);
        this.addSubdiskSimpleVolMapping(element, element.getCommKeyClassId().getMyFirstSnmpAgentIndex());
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        int trapId = trap.getTrapType().getTrapId();
        if (trapId != 11) {
            throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
        }
        this.internalRead(element);
        theLogger.trace(SrLogCategories.LEGACY, "Added by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)trap);
    }

    @Override
    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SnmpCommKey snmpKey = element.getSnmpKey();
        SrOid oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_LENGTH.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_INFO.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_ALIAS.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.SUB_DIRECT_ACCESS_DEVICE_VOL_ID.toString(), snmpKey.toString());
        list.add(new SrSnmpVarBind(oid, null));
    }

    @Override
    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        if (trap.getTrapType().getTrapId() == 11) {
            return MibItem.SUB_DIRECT_ACCESS_DEVICE_RS;
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.getTrapType().toString());
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return aElement.getCommKeyClassId();
    }
}

