/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.storage.AbstractPhysicalStorageConfigurator;
import com.sanrad.nms.server.mgr.storage.DirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierConfigurator;
import com.sanrad.nms.server.mgr.storage.LUIdentifierMgr;
import com.sanrad.nms.server.mgr.storage.PhysicalStorageCommandConfigurator;
import com.sanrad.nms.server.mgr.storage.SubDirectAccessDeviceConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyFetcher;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.VolumeTypeConstants;
import java.util.HashMap;
import java.util.List;

public class PhysicalStorageConfigurator
extends AbstractPhysicalStorageConfigurator {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final HashMap<ParameterCodes, Object> paramList = new HashMap();

    public PhysicalStorageConfigurator() {
        this(ClassID.GENERAL_PHYSICAL_STORAGE, "srPhysStorTable", MibItem.PHYSICAL_STORAGE_RS, MibItem.PHYSICAL_STORAGE_TBL_LAST_UPDATE, true);
    }

    protected PhysicalStorageConfigurator(ClassID classId, String tableName, MibItem rs) {
        this(classId, tableName, rs, MibItem.PHYSICAL_STORAGE_LAST_UPDATE, true);
    }

    protected PhysicalStorageConfigurator(ClassID classId, String tableName, MibItem rsMib, MibItem luMib, boolean hasLastUpdateForEntry) {
        super(classId, tableName, rsMib, luMib, hasLastUpdateForEntry);
    }

    @Override
    protected void internalReadExtentionTable(ConfigElementData element, ConfigElementDataList retrievedElements) throws SrCommException {
        SnmpCommKey elementCommKey = element.getSnmpKey();
        ConfigElementData physicalStorageComElement = new ConfigElementData(elementCommKey, ClassID.GENERAL_PHYSICAL_STORAGE);
        PhysicalStorageCommandConfigurator physicalStorageComConfigurator = new PhysicalStorageCommandConfigurator();
        physicalStorageComConfigurator.internalRead(physicalStorageComElement);
        element.addParameter(physicalStorageComElement.getParametersList());
        if (element.getClassId().equals(ClassID.DIRECT_ACCESS_DEVICE)) {
            DirectAccessDeviceConfigurator directAccessDeviceCfg = new DirectAccessDeviceConfigurator();
            ConfigElementData directAccessDeviceElement = new ConfigElementData(elementCommKey, ClassID.DIRECT_ACCESS_DEVICE);
            directAccessDeviceCfg.internalRead(directAccessDeviceElement);
            element.addParameter(directAccessDeviceElement.getParametersList());
        }
        if (retrievedElements != null && !retrievedElements.contains(element)) {
            retrievedElements.add(element);
        }
    }

    @Override
    public void discover(CommKeyClassId vswitchData) throws SrCommException {
        this.discover(vswitchData.getMyFirstSnmpAgentIndex());
    }

    public ConfigElementDataList discover(char snmpAgentIndex) throws SrCommException {
        CommKeyClassId vSwitchData = CommKeyUtil.getVSwitchData(snmpAgentIndex);
        LUIdentifierConfigurator luIdConfig = new LUIdentifierConfigurator();
        luIdConfig.discover(vSwitchData);
        ConfigElementDataList physicalStorageList = this.getAll(snmpAgentIndex, null, null);
        if (physicalStorageList.size() > 0) {
            PhysicalStorageCommandConfigurator physicalStorageComConfigurator = new PhysicalStorageCommandConfigurator();
            ConfigElementDataList physStorComList = physicalStorageComConfigurator.getAll(snmpAgentIndex, null, null);
            this.mergeElementLists(physicalStorageList, physStorComList, false);
        }
        DirectAccessDeviceConfigurator directAccessConfig = new DirectAccessDeviceConfigurator();
        SubDirectAccessDeviceConfigurator subDiskConfig = new SubDirectAccessDeviceConfigurator();
        directAccessConfig.discover(physicalStorageList, vSwitchData);
        ConfigElementDataList subdiskList = subDiskConfig.discoverAll(vSwitchData);
        physicalStorageList.addAll(subdiskList);
        this.sendDiscoveredElementsToEventMgr(physicalStorageList, vSwitchData);
        return physicalStorageList;
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return paramList;
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList rowList) throws SrCommException {
        SrType storageType = (SrType)element.getValue(ParameterCode.PHYSICAL_STORAGE_TYPE);
        if (storageType != null) {
            if (storageType.equals(PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE)) {
                element.setClassId(ClassID.DIRECT_ACCESS_DEVICE);
            } else if (storageType.equals(PhysicalStorageTypeConstant.PHYS_STOR_TYPE_SEQUENTIAL_ACCESS_DEVICE)) {
                element.setClassId(ClassID.SEQUENTIAL_ACCESS_DEVICE);
            } else {
                element.setClassId(ClassID.GENERAL_SCSI_DEVICE);
            }
        } else {
            theLogger.warn(SrLogCategories.LEGACY, "Storage type is null ", element);
        }
        SrType volId = PhysicalStorageConfigurator.getVarBindValueFromList(rowList, MibItem.PHYSICAL_STORAGE_VOL_ID);
        if (volId == null) {
            volId = (SrType)element.getValue(ParameterCode.PHYSICAL_STORAGE_VOLUME_ID);
        }
        element.setValue(ParameterCode.PHYSICAL_STORAGE_VOLUME_ID, volId);
        if (volId != null) {
            String volumeIndex = "1." + volId.toString();
            SrType[] volType = this.readTableCells(volumeIndex, element.getMyFirstSnmpAgentIndex(), MibItem.VIRTUAL_VOLUME_TYPE);
            if (VolumeTypeConstants.VOLUME_TYPE_SIMPLE.equals(volType[0])) {
                CommKeyClassId physStorData = new CommKeyClassId(element.getCommKey(), element.getClassId());
                SimpleVolumeMgr.getInstance().addSimpleToPhysMapping(physStorData.getMyFirstSnmpAgentIndex(), volumeIndex, physStorData);
            }
        }
        CommKeyClassId physStorCommKeyClassId = new CommKeyClassId(element.getCommKey(), element.getClassId());
        List<CommKeyClassId> luIds = LUIdentifierMgr.getInstance().getEntryFromLUIdPhysStorMap(physStorCommKeyClassId);
        if (luIds != null) {
            SrType[] luIdCommKeyClassIds = new CommKeyClassId[luIds.size()];
            luIds.toArray(luIdCommKeyClassIds);
            element.setValues(ParameterCode.PHYSICAL_STORAGE_LU_IDENTIFIER, luIdCommKeyClassIds);
        } else {
            theLogger.trace(SrLogCategories.LEGACY, "LU IDs of ", physStorCommKeyClassId.getClassID(), " CommKey ", physStorCommKeyClassId.getCommKeys()[0], " is null");
        }
        LUIdentifierMgr.getInstance().removeFromLUIdPhysStorMap(physStorCommKeyClassId);
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        switch (trap.getTrapType().getTrapId()) {
            case 0: 
            case 1: 
            case 2: {
                return MibItem.PHYSICAL_STORAGE_TYPE;
            }
            case 12: {
                return MibItem.PHYSICAL_STORAGE_COM_OPER_STATUS;
            }
            case 11: {
                return MibItem.SUB_DIRECT_ACCESS_DEVICE_RS;
            }
        }
        throw new UnsupportedOperationException("Operation not supported for trap " + trap.getTrapType().toString());
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        this.readDiscoverPostOperation(element, trap.getVarBindList());
        switch (trap.getTrapType().getTrapId()) {
            case 1: {
                this.physStorAddedByTrap(element, trap);
                break;
            }
            case 0: {
                theLogger.trace(SrLogCategories.LEGACY, "Removed by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
                SrEventHandler.getEventMgr().sendRemoveElementEvent(element, trap);
                break;
            }
            case 2: 
            case 12: {
                theLogger.trace(SrLogCategories.LEGACY, "Changed by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
                ElementConfigurator specificConfig = DataMgrAOImpl.getElementConfigFromClassID(element.getClassId());
                ConfigElementData specificDevice = new ConfigElementData(element.getCommKeyClassId());
                specificDevice.addParameter(specificConfig.getListOfParams());
                this.internalRead(specificDevice);
                SrEventHandler.getEventMgr().sendChangeElementEvent(specificDevice, (Object)trap);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation not supported for trap ID " + trap.getTrapType().getTrapId());
            }
        }
    }

    private void physStorAddedByTrap(ConfigElementData element, SrTrap trap) throws SrCommException {
        ElementConfigurator specificConfig = DataMgrAOImpl.getElementConfigFromClassID(element.getClassId());
        specificConfig.internalRead(element);
        theLogger.trace(SrLogCategories.LEGACY, "Added by Trap for ", element.getClassId(), " CommKey is: ", CommKeyUtil.getKeyForMessage(element.getCommKey()));
        SrEventHandler.getEventMgr().sendAddElementEvent(element, (Object)trap);
    }

    protected String[] getTablesOfElement(ConfigElementData element) {
        String[] tableName = new String[]{"srPhysStorTable"};
        return tableName;
    }

    public static CommKey[] getDeviceKeyFromMyKey(CommKey[] myKey) {
        CommKey[] newKey = new CommKey[myKey.length];
        int newKeyIndex = 0;
        String deviceKey = null;
        for (int i = 0; i < myKey.length; ++i) {
            if (((CommKeyFetcher)((Object)myKey[i])).getSnmpCommKey() == null) continue;
            String indices = myKey[i].getKey();
            int firstDot = indices.indexOf(".");
            String tmp = indices.substring(firstDot + 1);
            int secondDot = tmp.indexOf(".");
            deviceKey = indices.substring(0, firstDot + secondDot + 1);
            newKey[newKeyIndex++] = new SnmpCommKey(deviceKey, ((CommKeyFetcher)((Object)myKey[i])).getSnmpCommKey().getSnmpAgentIndex());
        }
        if (newKeyIndex == myKey.length) {
            return newKey;
        }
        if (newKeyIndex > 0) {
            CommKey[] resizedNewKey = new CommKey[newKeyIndex];
            System.arraycopy(newKey, 0, resizedNewKey, 0, newKey.length);
            return resizedNewKey;
        }
        return null;
    }

    @Override
    protected void addCommVarBindsToReadList(CommVarBindList list, ConfigElementData element) {
        super.addCommVarBindsToReadList(list, element);
        SrOid oid = new SrOid(MibItem.PHYSICAL_STORAGE_TYPE.toString(), element.getSnmpKey().toString());
        list.add(new SrSnmpVarBind(oid, null));
        oid = new SrOid(MibItem.PHYSICAL_STORAGE_VOL_ID.toString(), element.getSnmpKey().toString());
        list.add(new SrSnmpVarBind(oid, null));
    }

    @Override
    public void internalCreate(ConfigElementData element) throws SrCommException {
        char snmpAgentIndex = element.getSnmpAgentFromParameter();
        SnmpCommKey nextKey = this.getPhysicalStorageIndexNext(snmpAgentIndex);
        SrString sn = (SrString)element.getValue(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        if (sn != null && sn.value().equals("")) {
            element.removeParameter(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        }
        ParameterCode[] createCodes = PhysicalStorageConfigurator.getCreateParams();
        ConfigElementData createElement = new ConfigElementData(element.getClassId());
        createElement.setCommKey(nextKey);
        int i = createCodes.length;
        while (i-- > 0) {
            createElement.addParameterToElement(element, createCodes[i]);
        }
        super.internalCreate(createElement);
        element.setCommKeyClassId(createElement.getCommKeyClassId());
        ParameterCode[] changeCodes = this.getChangeParams();
        ConfigElementData changeElement = new ConfigElementData(element.getCommKeyClassId());
        int i2 = changeCodes.length;
        while (i2-- > 0) {
            changeElement.addParameterToElement(element, changeCodes[i2]);
        }
        super.internalChange(changeElement);
    }

    public static ParameterCode[] getCreateParams() {
        ParameterCode[] codes = new ParameterCode[]{ParameterCode.PHYSICAL_STORAGE_ALIAS, ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, ParameterCode.PHYSICAL_STORAGE_LUN, ParameterCode.PHYSICAL_STORAGE_TYPE, ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER};
        return codes;
    }

    public ParameterCode[] getChangeParams() {
        return new ParameterCode[0];
    }

    public SnmpCommKey getPhysicalStorageIndexNext(char agentIndex) throws SrCommException {
        String indexNext = super.getIndexNext(this.myTableName, "1.1", null, false, agentIndex);
        return new SnmpCommKey(indexNext, agentIndex);
    }

    public void postCreateEvent(ConfigElementData myElement) throws SrCommException {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ie) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, ie);
        }
        SCSIRemoteTargetConfigurator remoteTargetConf = new SCSIRemoteTargetConfigurator();
        remoteTargetConf.refreshRemoteTargetsForDependantOnOperations(myElement.getSnmpAgentFromParameter());
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getMyFirstSnmpAgentIndex();
        return new CommKeyClassId(this.getPhysicalStorageIndexNext(agentIndex), aElement.getClassId());
    }

    static {
        paramList.put(ParameterCode.PHYSICAL_STORAGE_ALIAS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_INFO, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_LUN, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_OPERATIONAL_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_COM_ADMIN_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_COM_DURATION, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_COM_OPER_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_PRODUCT_ID, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_REVISION_LEVEL, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_SCSI_VER, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_LAST_UPDATE, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_DRIVE_TYPE, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_LEVEL, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_STATUS, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_CREATION_TIME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_SYSTEM_NAME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_MODEL_NAME, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_FIRMWARE_REV, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL1, null);
        paramList.put(ParameterCode.PHYSICAL_STORAGE_RAID_CONTROLLER_URL2, null);
    }
}

