/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LUIdentifierMgr {
    private static LUIdentifierMgr theInstance = new LUIdentifierMgr();
    private static SrLogger theLogger = SrLogger.getLogger();
    private final Map<Character, VswitchLUIdentifierMgr> myIndexToMgrMap = new HashMap<Character, VswitchLUIdentifierMgr>();

    public static LUIdentifierMgr getInstance() {
        return theInstance;
    }

    public synchronized void addEntryToLUIdPhysStorMap(CommKeyClassId physStorCommKey, CommKeyClassId luId) {
        VswitchLUIdentifierMgr vsMgr = this.myIndexToMgrMap.get(Character.valueOf(physStorCommKey.getMyFirstSnmpAgentIndex()));
        vsMgr.addEntryToLUIdPhysStorMap(physStorCommKey, luId);
    }

    public synchronized List<CommKeyClassId> getEntryFromLUIdPhysStorMap(CommKeyClassId physStorCommKey) {
        VswitchLUIdentifierMgr vsMgr = this.myIndexToMgrMap.get(Character.valueOf(physStorCommKey.getMyFirstSnmpAgentIndex()));
        return vsMgr.getEntryFromLUIdPhysStorMap(physStorCommKey);
    }

    public synchronized void clearLUIdPhysStorMap(char aAgentIndex) {
        VswitchLUIdentifierMgr vsMgr = this.myIndexToMgrMap.get(Character.valueOf(aAgentIndex));
        if (vsMgr == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Clearing a non initialized vsMgr for VS index '", Character.valueOf(aAgentIndex), "'; VS: ", CommKeyUtil.getIpFromIndex(aAgentIndex));
            return;
        }
        vsMgr.clearLUIdPhysStorMap();
    }

    public synchronized void removeFromLUIdPhysStorMap(CommKeyClassId physStorCommKey) {
        VswitchLUIdentifierMgr vsMgr = this.myIndexToMgrMap.get(Character.valueOf(physStorCommKey.getMyFirstSnmpAgentIndex()));
        if (vsMgr == null) {
            theLogger.info(SrLogCategories.INFORMATIVE, "Removing a non initialized vsMgr for VS index '", Character.valueOf(physStorCommKey.getMyFirstSnmpAgentIndex()), "'; VS: ", CommKeyUtil.getIpFromIndex(physStorCommKey.getMyFirstSnmpAgentIndex()));
            return;
        }
        vsMgr.removeFromLUIdPhysStorMap(physStorCommKey);
    }

    public synchronized void addVswitch(CommKeyClassId aVswitchId) {
        this.addVswitch(aVswitchId.getMyFirstSnmpAgentIndex());
    }

    public synchronized void addVswitch(char aAgentIndex) {
        this.myIndexToMgrMap.put(Character.valueOf(aAgentIndex), new VswitchLUIdentifierMgr());
    }

    public synchronized void removeVswitch(CommKeyClassId aVswitchId) {
        this.removeVswitch(aVswitchId.getMyFirstSnmpAgentIndex());
    }

    public synchronized void removeVswitch(char aAgentIndex) {
        this.myIndexToMgrMap.remove(Character.valueOf(aAgentIndex));
    }

    private class VswitchLUIdentifierMgr {
        private final Map<CommKeyClassId, Set<CommKeyClassId>> myPhysIdToLUIds = new HashMap<CommKeyClassId, Set<CommKeyClassId>>();

        private VswitchLUIdentifierMgr() {
        }

        private void addEntryToLUIdPhysStorMap(CommKeyClassId aPhysStorKey, CommKeyClassId aLUIdentifierId) {
            Set<CommKeyClassId> currentLUIds = this.myPhysIdToLUIds.get(aPhysStorKey);
            if (currentLUIds == null) {
                currentLUIds = new HashSet<CommKeyClassId>();
                this.myPhysIdToLUIds.put(aPhysStorKey, currentLUIds);
            }
            currentLUIds.add(aLUIdentifierId);
        }

        private void clearLUIdPhysStorMap() {
            this.myPhysIdToLUIds.clear();
        }

        private void removeFromLUIdPhysStorMap(CommKeyClassId aPhysStorKey) {
            if (this.myPhysIdToLUIds.remove(aPhysStorKey) != null) {
                theLogger.trace(SrLogCategories.LEGACY, "Remove ", aPhysStorKey, " from physStorToLUIdMap");
            } else {
                theLogger.trace(SrLogCategories.LEGACY, "No entry for ", aPhysStorKey, " in physStorToLUIdMap when trying to remove");
            }
        }

        private List<CommKeyClassId> getEntryFromLUIdPhysStorMap(CommKeyClassId aPhysStorKey) {
            Set<CommKeyClassId> luList = this.myPhysIdToLUIds.get(aPhysStorKey);
            if (luList == null) {
                return null;
            }
            return new ArrayList<CommKeyClassId>(luList);
        }
    }
}

