/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.storage;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.SCSIRemoteTargetConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeConfigurator;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.mgr.volume.VolumeOperationConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import java.util.HashMap;

abstract class AbstractPhysicalStorageConfigurator
extends ElementConfigurator {
    public AbstractPhysicalStorageConfigurator(ClassID aClassId, String aTableName, MibItem aRowStatusMib, MibItem aLastUpdateMib, boolean aHasLastUpdateForEntry) {
        super(aClassId, aTableName, aRowStatusMib, aLastUpdateMib, aHasLastUpdateForEntry);
    }

    @Override
    public void internalChange(ConfigElementData element) throws SrCommException {
        SimpleVolumeConfigurator simpleConfig = new SimpleVolumeConfigurator();
        HashMap mirrVolParams = simpleConfig.getListOfParamsForMirror();
        this.splitParameterListOfDifferentElement(element, mirrVolParams);
        if (mirrVolParams.size() > 0) {
            char snmpAgentIndex = element.getMyFirstSnmpAgentIndex();
            CommKeyClassId thisPhysStor = new CommKeyClassId(element.getCommKey(), element.getClassId());
            String volId = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(snmpAgentIndex, thisPhysStor);
            SnmpCommKey volKey = new SnmpCommKey("1." + volId, snmpAgentIndex);
            ConfigElementData mirrVolData = new ConfigElementData((CommKey)volKey, ClassID.GENERAL_VOLUME, (HashMap<ParameterCodes, Object>)mirrVolParams);
            simpleConfig.internalChange(mirrVolData);
        }
        if (element.getParametersList().size() > 0) {
            super.internalChange(element);
        }
    }

    @Override
    public void internalRemove(ConfigElementData element) throws SrCommException {
        CommKeyClassId physStorData = new CommKeyClassId(element.getCommKey(), element.getClassId());
        SimpleVolumeConfigurator simpleCnf = new SimpleVolumeConfigurator();
        simpleCnf.removeSimpleVolume(physStorData, element.getMyFirstSnmpAgentIndex());
        super.internalRemove(element);
        VolumeOperationConfigurator volumeOperCfg = new VolumeOperationConfigurator();
        volumeOperCfg.refreshTable(element.getMyFirstSnmpAgentIndex(), null, new CheckListConfigElementData(ClassID.COPY_OPERATION));
    }

    @Override
    public void postRemoveOperation(ConfigElementData element) throws SrCommException {
        SCSIRemoteTargetConfigurator remoteTargetsCfg = new SCSIRemoteTargetConfigurator();
        remoteTargetsCfg.refreshRemoteTargetsForDependantOnOperations(element.getMyFirstSnmpAgentIndex());
    }
}

