/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.raid;

import com.sanrad.nms.server.comm.CommItem;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBindList;
import com.sanrad.nms.server.comm.snmp.raid.IbmRaidMibItem;
import com.sanrad.nms.server.comm.snmp.trap.SrTrap;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;
import java.util.Map;

public class RaidTrapConfigurator
extends ElementConfigurator {
    private static Map<ParameterCode, ParameterCode> theSpecificRaidToGeneralRaidParameterMap = new HashMap<ParameterCode, ParameterCode>();

    public RaidTrapConfigurator() {
        super(ClassID.STORAGE_NOTIFICATION, null, null, null);
    }

    @Override
    protected void trapProccessingPostOperation(ConfigElementData element, SrTrap trap) throws SrCommException {
        RaidTrapConfigurator.convertSpecificRaidToGeneralRaidParameters(element, trap);
        EventMgr.getInstance().sendStorageNotificationEvent(element, trap);
    }

    @Override
    protected CommItem getCommItemForTrapCommKey(SrTrap trap) {
        return IbmRaidMibItem.DEVICE_USER_LABEL;
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return null;
    }

    private static void convertSpecificRaidToGeneralRaidParameters(ConfigElementData aCED, SrTrap trap) {
        SrTimeTicks eventTime;
        CommVarBind vb;
        HashMap<ParameterCodes, Object> codeToObjMap = new HashMap<ParameterCodes, Object>(aCED.getParametersList());
        for (ParameterCodes code : codeToObjMap.keySet()) {
            if (!theSpecificRaidToGeneralRaidParameterMap.containsKey(code)) continue;
            Object o = aCED.removeParameter((ParameterCode)code);
            aCED.setValue(theSpecificRaidToGeneralRaidParameterMap.get(code), (SrType)o);
        }
        SrSnmpVarBindList vbList = trap.getVarBindList();
        if (vbList != null && (vb = vbList.getVarBind(MibItem.VSWITCH_SYS_UP_TIME)) != null && (eventTime = (SrTimeTicks)vb.getValue()) != null) {
            String textToSet = "Controller UpTime: " + eventTime.toFormattedString();
            aCED.setValue(ParameterCode.RAID_TRAP_EVENT_TIME, new SrString(textToSet));
        }
    }

    static {
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_DEVICE_HOST_NAME, ParameterCode.RAID_TRAP_DEVICE_HOST_NAME);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_DEVICE_HOST_IP, ParameterCode.RAID_TRAP_DEVICE_HOST_IP);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_DEVICE_ERROR_CODE, ParameterCode.RAID_TRAP_DEVICE_ERROR_CODE);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_DESCRIPTION, ParameterCode.RAID_TRAP_DESCRIPTION);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_EVENT_TIME, ParameterCode.RAID_TRAP_EVENT_TIME);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_COMPONENT_TYPE, ParameterCode.RAID_TRAP_COMPONENT_TYPE);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_COMPONENT_LOCATION, ParameterCode.RAID_TRAP_COMPONENT_LOCATION);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.IBM_RAID_TRAP_DEVICE_USER_LABEL, ParameterCode.RAID_TRAP_DEVICE_USER_LABEL);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.NEXSAN_RAID_TRAP_DEVICE_HOST_NAME, ParameterCode.RAID_TRAP_DEVICE_HOST_NAME);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.NEXSAN_RAID_TRAP_DEVICE_HOST_IP, ParameterCode.RAID_TRAP_DEVICE_HOST_IP);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.NEXSAN_RAID_TRAP_EVENT_TIME, ParameterCode.RAID_TRAP_EVENT_TIME);
        theSpecificRaidToGeneralRaidParameterMap.put(ParameterCode.NEXSAN_RAID_TRAP_DESCRIPTION, ParameterCode.RAID_TRAP_DESCRIPTION);
    }
}

