/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.raid;

import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.raid.RaidConfigurationException;
import com.sanrad.nms.server.comm.snmp.raid.RaidSubsystem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import java.util.HashMap;

public class AttachedRaidConfigurator
extends ElementConfigurator {
    private static final String NULL_VALUE_IP = "0.0.0.0";
    private static final int RAID_REGISTRATION_RETRIES_COUNT = ServerPropertiesFetcher.getRaidRegistrationRetriesCount();
    private static HashMap<ParameterCodes, Object> theParamList = new HashMap();

    public AttachedRaidConfigurator() {
        super(ClassID.ATTACHED_RAID, "srAttachedRaidTable", MibItem.ATTACHED_RAID_ROW_STATUS, MibItem.ATTACHED_RAID_LAST_UPDATE);
    }

    @Override
    protected CommKeyClassId recalculateNextIndex(ConfigElementData aElement) throws SrCommException {
        return this.getNextMIBIndex(aElement.getCommKeyClassId(), MibItem.ATTACHED_RAID_INDEX_NEXT);
    }

    @Override
    public HashMap<ParameterCodes, Object> getListOfParams() {
        return theParamList;
    }

    @Override
    public void internalCreate(ConfigElementData aElement) throws SrCommException {
        char agentIndex = aElement.getSnmpAgentFromParameter();
        SrString vendorName = (SrString)aElement.removeValue(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME);
        SrString raidName = (SrString)aElement.getValue(ParameterCode.ATTACHED_RAID_NAME);
        SrIpAddress raidCtrlIp1 = (SrIpAddress)aElement.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP1);
        SrIpAddress raidCtrlIp2 = (SrIpAddress)aElement.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP2);
        if (raidCtrlIp1 != null || raidCtrlIp2 != null) {
            RaidConfigurationException exception = null;
            for (int i = 0; i < RAID_REGISTRATION_RETRIES_COUNT; ++i) {
                try {
                    CommMgr.setRaidSnmpMgr(DataMgrAOImpl.getInstance(), vendorName, raidName, raidCtrlIp1, raidCtrlIp2, agentIndex);
                    exception = null;
                    break;
                }
                catch (RaidConfigurationException e) {
                    exception = e;
                    continue;
                }
            }
            if (exception != null) {
                throw exception;
            }
            RaidSubsystem raidSys = CommMgr.getRaidSubsystem(agentIndex, raidCtrlIp1, raidCtrlIp2);
            if (raidSys != null) {
                aElement.setValue(ParameterCode.ATTACHED_RAID_NAME, new SrString(raidSys.getName()));
            }
        }
        SrType nextIndex = this.getScalarFromComm(MibItem.ATTACHED_RAID_INDEX_NEXT, agentIndex);
        aElement.setCommKey(new SnmpCommKey(nextIndex.toString(), agentIndex));
        super.internalCreate(aElement);
    }

    @Override
    public void internalRemove(ConfigElementData aElement) throws SrCommException {
        ConfigElementData readCed = new ConfigElementData(aElement.getCommKeyClassId());
        this.internalRead(readCed);
        SrIpAddress raidCtrlIp1 = (SrIpAddress)readCed.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP1);
        SrIpAddress raidCtrlIp2 = (SrIpAddress)readCed.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP2);
        super.internalRemove(aElement);
        if (raidCtrlIp1 != null || raidCtrlIp2 != null) {
            CommMgr.removeRaidSnmpMgr(aElement.getMyFirstSnmpAgentIndex(), raidCtrlIp1, raidCtrlIp2);
        }
    }

    @Override
    public void internalChange(ConfigElementData aElement) throws SrCommException {
        SrString vendorName = (SrString)aElement.removeValue(ParameterCode.PHYSICAL_STORAGE_VENDOR_NAME);
        SrString raidName = (SrString)aElement.getValue(ParameterCode.ATTACHED_RAID_NAME);
        SrIpAddress raidCtrlIp1 = (SrIpAddress)aElement.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP1);
        SrIpAddress raidCtrlIp2 = (SrIpAddress)aElement.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP2);
        if (raidCtrlIp1 != null || raidCtrlIp2 != null) {
            RaidConfigurationException exception = null;
            for (int i = 0; i < RAID_REGISTRATION_RETRIES_COUNT; ++i) {
                try {
                    CommMgr.setRaidSnmpMgr(DataMgrAOImpl.getInstance(), vendorName, raidName, raidCtrlIp1, raidCtrlIp2, aElement.getMyFirstSnmpAgentIndex());
                    exception = null;
                    break;
                }
                catch (RaidConfigurationException e) {
                    exception = e;
                    continue;
                }
            }
            if (exception != null) {
                throw exception;
            }
            RaidSubsystem raidSys = CommMgr.getRaidSubsystem(aElement.getMyFirstSnmpAgentIndex(), raidCtrlIp1, raidCtrlIp2);
            if (raidSys != null) {
                aElement.setValue(ParameterCode.ATTACHED_RAID_NAME, new SrString(raidSys.getName()));
            }
        }
        if (aElement.containsParameter(ParameterCode.ATTACHED_RAID_CTRL_IP1) && raidCtrlIp1 == null) {
            aElement.setValue(ParameterCode.ATTACHED_RAID_CTRL_IP1, new SrIpAddress(NULL_VALUE_IP));
        }
        if (aElement.containsParameter(ParameterCode.ATTACHED_RAID_CTRL_IP2) && raidCtrlIp2 == null) {
            aElement.setValue(ParameterCode.ATTACHED_RAID_CTRL_IP2, new SrIpAddress(NULL_VALUE_IP));
        }
        super.internalChange(aElement);
    }

    @Override
    protected void readDiscoverPostOperation(ConfigElementData element, CommVarBindList list) throws SrCommException {
        SrIpAddress ip2;
        SrIpAddress ip1 = (SrIpAddress)element.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP1);
        if (ip1 != null && NULL_VALUE_IP.equals(ip1.toString())) {
            element.setValue(ParameterCode.ATTACHED_RAID_CTRL_IP1, (SrType)null);
        }
        if ((ip2 = (SrIpAddress)element.getValue(ParameterCode.ATTACHED_RAID_CTRL_IP2)) != null && NULL_VALUE_IP.equals(ip2.toString())) {
            element.setValue(ParameterCode.ATTACHED_RAID_CTRL_IP2, (SrType)null);
        }
    }

    static {
        theParamList.put(ParameterCode.ATTACHED_RAID_NAME, null);
        theParamList.put(ParameterCode.ATTACHED_RAID_UNIQUE_NAME, null);
        theParamList.put(ParameterCode.ATTACHED_RAID_CTRL_IP1, null);
        theParamList.put(ParameterCode.ATTACHED_RAID_CTRL_IP2, null);
    }
}

