/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling.groups;

import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.polling.PollingGroup;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.groups.PollAttachedRaidTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollIscsiTgtQosGroupItem;
import com.sanrad.nms.server.mgr.polling.groups.PollIscsiTgtTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollLunTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollPhysicalStorageLUIdentifierItem;
import com.sanrad.nms.server.mgr.polling.groups.PollPhysicalStorageTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollPolicyParamTableItem;
import com.sanrad.nms.server.mgr.polling.groups.PollPolicyTableItem;
import com.sanrad.nms.server.mgr.polling.groups.PollSnapSchedulerTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollSubDirectAccessDeviceTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollVirtVolMirrorTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollVirtVolTblItem;
import com.sanrad.nms.server.mgr.polling.groups.PollVolOperationTblItem;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.constants.StorageDiscoveryOperationConstant;
import com.sanrad.nms.server.util.types.constants.StorageDiscoveryStatusConstant;

public class PollingVirtualizationGroup
extends PollingGroup {
    private static final long STORAGE_DISCOVERING_INTERVAL = ServerPropertiesFetcher.getStorageDiscoveryPollInterval();
    private static final long STORAGE_DISCOVERING_COUNT = ServerPropertiesFetcher.getStorageDiscoveryPollCount();
    private boolean myIsStorageDiscoveryStarted = false;
    private long myPollInteval = this.getPollingState().getPollInterval();
    private int myIterationsCount = 0;

    public PollingVirtualizationGroup(CommKeyClassId aVswitchId, SrDouble groupInterval) {
        this(aVswitchId, PollingGroupType.VIRTUALIZATION_GROUP_TYPE, groupInterval, "VIRTUALIZATION_GROUP");
    }

    protected PollingVirtualizationGroup(CommKeyClassId aVsiwtchId, PollingGroupType aType, SrDouble groupInterval, String aName) {
        super(aVsiwtchId, aType, groupInterval, aName);
    }

    @Override
    public void execute() throws SrCommException {
        VSwitchConfigurator vsConfigurator = new VSwitchConfigurator();
        StorageDiscoveryStatusConstant storageDiscoveryStatus = (StorageDiscoveryStatusConstant)vsConfigurator.getScalarFromComm(MibItem.PHYSICAL_STORAGE_MANUAL_DISCOVERY_STATUS, this.getAgentIndex());
        ++this.myIterationsCount;
        if (!this.myIsStorageDiscoveryStarted) {
            if (StorageDiscoveryStatusConstant.IDLE.equals(storageDiscoveryStatus)) {
                ConfigElementData discoveryCed = new ConfigElementData(this.getVswitchId(), ConfigOperation.CHANGE);
                discoveryCed.setValue(ParameterCode.PHYSICAL_STORAGE_MANUAL_DISCOVERY, StorageDiscoveryOperationConstant.MANUAL_DISCOVERY_STATUS_ON);
                vsConfigurator.internalChange(discoveryCed);
            }
            this.myIsStorageDiscoveryStarted = true;
            this.getPollingState().setPollInterval(STORAGE_DISCOVERING_INTERVAL);
        } else if (this.myIsStorageDiscoveryStarted) {
            if (StorageDiscoveryStatusConstant.IDLE.equals(storageDiscoveryStatus) || (long)this.myIterationsCount > STORAGE_DISCOVERING_COUNT) {
                this.myIterationsCount = 0;
                this.myIsStorageDiscoveryStarted = false;
                this.getPollingState().setPollInterval(this.myPollInteval);
                super.execute();
            } else {
                this.getPollingState().setPollInterval(STORAGE_DISCOVERING_INTERVAL);
            }
        }
    }

    @Override
    public void initPollSingleItemsList() {
        char agentIndex = this.getAgentIndex();
        this.addPollSingleItemToList(new PollPhysicalStorageLUIdentifierItem(agentIndex));
        this.addPollSingleItemToList(new PollPhysicalStorageTblItem(agentIndex));
        this.addPollSingleItemToList(new PollSubDirectAccessDeviceTblItem(agentIndex));
        this.addPollSingleItemToList(new PollAttachedRaidTblItem(agentIndex));
        this.addPollSingleItemToList(new PollVirtVolTblItem(agentIndex));
        this.addPollSingleItemToList(new PollIscsiTgtTblItem(agentIndex));
        this.addPollSingleItemToList(new PollIscsiTgtQosGroupItem(agentIndex));
        this.addPollSingleItemToList(new PollLunTblItem(agentIndex));
        this.addPollSingleItemToList(new PollVirtVolMirrorTblItem(agentIndex));
        this.addPollSingleItemToList(new PollVolOperationTblItem(agentIndex));
        this.addPollSingleItemToList(new PollSnapSchedulerTblItem(agentIndex));
        this.addPollSingleItemToList(new PollPolicyTableItem(agentIndex));
        this.addPollSingleItemToList(new PollPolicyParamTableItem(agentIndex));
    }

    @Override
    public void initPollMultiItemsList() {
    }
}

