/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling.groups;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.LastChangedTableEntryItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PollAuthIdentTblItem
extends LastChangedTableEntryItem {
    private static final String[] TABLE_NAMES = new String[]{"ipsAuthIdentAttributesTable"};
    private static final ClassID[] CLASS_IDS = new ClassID[]{ClassID.IDENTITY};
    private static int numOfIndexes = 0;
    private static final int IDENTITY_CHECK_LIST_INDEX = numOfIndexes++;
    private static final int IDENTITY_NAMES_CHECK_LIST_INDEX = numOfIndexes++;
    private static final int IDENTITY_CHAP_CHECK_LIST_INDEX = numOfIndexes++;
    private static final int IDENTITY_SRP_CHECK_LIST_INDEX = numOfIndexes++;

    public PollAuthIdentTblItem(char agentIndex) {
        super(agentIndex, MibItem.IDENTITY_EXTENTION_TBL_LAST_UPDATE, MibItem.IDENTITY_ENTRY_LAST_UPDATED, TABLE_NAMES, CLASS_IDS);
    }

    @Override
    protected PollingData refresh() throws SrCommException {
        return this.refresh(ParameterCode.IDENTITY_LAST_UPDATE);
    }

    @Override
    protected final List<CheckListConfigElementData> getAllCheckLists(List<CommKeyClassId> checkListTopTable, ConfigElementDataList elementsList) {
        ArrayList<CheckListConfigElementData> checkLists = new ArrayList<CheckListConfigElementData>();
        checkLists.addAll(this.getCheckList(checkListTopTable));
        if (elementsList.size() > 0) {
            ArrayList<ArrayList<CommKeyClassId>> checkListsVectors = this.sortElementsListToCheckLists(elementsList);
            ArrayList<CommKeyClassId> listOfPrefixes = checkListsVectors.get(IDENTITY_CHECK_LIST_INDEX);
            ArrayList<CommKeyClassId> currCheckList = null;
            for (int index = 1; index < checkListsVectors.size(); ++index) {
                currCheckList = checkListsVectors.get(index);
                ClassID currClassId = index == IDENTITY_NAMES_CHECK_LIST_INDEX ? ClassID.IDENTITY_NAME : (index == IDENTITY_CHAP_CHECK_LIST_INDEX ? ClassID.CHAP_CREDENTIALS : ClassID.SRP_CREDENTIALS);
                checkLists.add(this.createCheckList(currClassId, currCheckList, listOfPrefixes));
            }
        }
        return checkLists;
    }

    private ArrayList<ArrayList<CommKeyClassId>> reorderByClassIdsCheckLists(ArrayList<ArrayList<CommKeyClassId>> source) {
        ArrayList<ArrayList<CommKeyClassId>> reorderedVecs = new ArrayList<ArrayList<CommKeyClassId>>();
        ArrayList dummyVec = new ArrayList();
        for (int i = 0; i < numOfIndexes; ++i) {
            reorderedVecs.add(dummyVec);
        }
        for (ArrayList<CommKeyClassId> currVec : source) {
            if (currVec == null || currVec.size() <= 0) continue;
            ClassID currVecClassId = currVec.get(0).getClassID();
            if (currVecClassId.getId() == ClassID.IDENTITY.getId()) {
                reorderedVecs.set(IDENTITY_CHECK_LIST_INDEX, currVec);
                continue;
            }
            if (currVecClassId.getId() == ClassID.IDENTITY_NAME.getId()) {
                reorderedVecs.set(IDENTITY_NAMES_CHECK_LIST_INDEX, currVec);
                continue;
            }
            if (currVecClassId.getId() == ClassID.CHAP_CREDENTIALS.getId()) {
                reorderedVecs.set(IDENTITY_CHAP_CHECK_LIST_INDEX, currVec);
                continue;
            }
            if (currVecClassId.getId() == ClassID.SRP_CREDENTIALS.getId()) {
                reorderedVecs.set(IDENTITY_SRP_CHECK_LIST_INDEX, currVec);
                continue;
            }
            SrLogger.getLogger().logAndAssert(SrLogCategories.ERROR, "Unexpected class ID - " + currVecClassId);
        }
        return reorderedVecs;
    }

    private ArrayList<ArrayList<CommKeyClassId>> sortElementsListToCheckLists(ConfigElementDataList elementsList) {
        Iterator elementIter = elementsList.iterator();
        ArrayList<ClassID> classIdsList = new ArrayList<ClassID>();
        ArrayList<ArrayList<CommKeyClassId>> checkListsVectors = new ArrayList<ArrayList<CommKeyClassId>>();
        while (elementIter.hasNext()) {
            ConfigElementData currElement = (ConfigElementData)elementIter.next();
            ClassID currElementClassId = currElement.getClassId();
            int indexOfClassId = classIdsList.indexOf(currElementClassId);
            if (indexOfClassId < 0) {
                classIdsList.add(currElementClassId);
                indexOfClassId = classIdsList.indexOf(currElementClassId);
            }
            this.addElementToCheckList(checkListsVectors, indexOfClassId, currElement);
        }
        ArrayList<ArrayList<CommKeyClassId>> reorderedCheckListsVectors = this.reorderByClassIdsCheckLists(checkListsVectors);
        return reorderedCheckListsVectors;
    }

    private void addElementToCheckList(ArrayList<ArrayList<CommKeyClassId>> checkListsVectors, int indexOfClassId, ConfigElementData element) {
        ArrayList<Object> checkList = null;
        if (indexOfClassId > checkListsVectors.size() - 1) {
            checkList = new ArrayList();
            checkListsVectors.add(checkList);
        } else {
            checkList = checkListsVectors.get(indexOfClassId);
        }
        CommKeyClassId commKeyClassId = element.getCommKeyClassId();
        checkList.add(commKeyClassId);
    }
}

