/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.comm.snmp.exception.SrSnmpTimeoutException;
import com.sanrad.nms.server.event.EventMgr;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrEventHandler;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.VSwitchConfigurator;
import com.sanrad.nms.server.mgr.polling.PollItem;
import com.sanrad.nms.server.mgr.polling.PollSingleItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.mgr.polling.PollingGroupState;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.polling.PollingMultiItems;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PollingGroup {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static final int MULTIPLE_FACTOR = 60000;
    private static final double DEFAULT_POLL_INTERVAL = 1.0;
    private PollingGroupType myType = null;
    private ArrayList<PollSingleItem> m_pollSingleItemList = new ArrayList();
    private ArrayList<PollingMultiItems> m_pollMultiItemsList = new ArrayList();
    private PollingGroupState myPollingState;
    protected String myName = "";
    private CommKeyClassId myVswitchId;
    private SrTimeTicks myLastSysUpTime = new SrTimeTicks(0);

    protected PollingGroup(CommKeyClassId aVswitchId, PollingGroupType groupType, SrDouble groupPollInterval, String name) {
        this.myVswitchId = aVswitchId;
        this.myType = groupType;
        this.initPollSingleItemsList();
        this.initPollMultiItemsList();
        this.myName = name;
        double pollIntervalMinutes = 0.0;
        pollIntervalMinutes = groupPollInterval == null ? 1.0 : groupPollInterval.doubleValue();
        long pollIntervalMillis = (long)(pollIntervalMinutes * 60000.0);
        this.myPollingState = new PollingGroupState(pollIntervalMillis);
    }

    protected PollingGroup(CommKeyClassId aVswitchId, PollingGroupType groupType, long pollIntervalMillis, String name) {
        this.myVswitchId = aVswitchId;
        this.myType = groupType;
        this.initPollSingleItemsList();
        this.initPollMultiItemsList();
        this.myName = name;
        this.myPollingState = new PollingGroupState(pollIntervalMillis);
    }

    public void execute() throws SrCommException {
        if (this.myPollingState.isSuspended() || !this.myPollingState.isActive()) {
            return;
        }
        this.operateSysTimeUpCheck();
        this.poll();
    }

    private void operateSysTimeUpCheck() throws SrCommException {
        VSwitchConfigurator vsConfigurator = new VSwitchConfigurator();
        char agentIndex = CommKeyUtil.getSnmpAgentIndex(this.myVswitchId.getCommKeys());
        SrTimeTicks currSysUpTime = (SrTimeTicks)vsConfigurator.getScalarFromComm(MibItem.VSWITCH_SYS_UP_TIME, agentIndex);
        if (currSysUpTime.compareLongValueTo(this.myLastSysUpTime) > 0) {
            this.myLastSysUpTime = currSysUpTime;
            return;
        }
        if (currSysUpTime.compareLongValueTo(this.myLastSysUpTime) < 0) {
            this.resetParameters();
        }
    }

    protected void sendTimeOutEvent(Object source, SrSnmpTimeoutException e) {
        SnmpErrorEvent event = new SnmpErrorEvent(source, "SNMP Timeout during polling", this.myVswitchId, 1);
        SrEventHandler.getSnmpErrorMgr().sendSnmpTimeOutEvent(event);
    }

    protected char getAgentIndex() {
        return CommKeyUtil.getSnmpAgentIndex(this.myVswitchId.getCommKeys());
    }

    protected CommKeyClassId getVswitchId() {
        return this.myVswitchId;
    }

    protected void addPollSingleItemToList(PollSingleItem item) {
        if (this.m_pollSingleItemList != null) {
            this.m_pollSingleItemList.add(item);
        }
    }

    protected void addPollMultiItemToList(PollingMultiItems item) {
        if (this.m_pollMultiItemsList != null) {
            this.m_pollMultiItemsList.add(item);
        }
    }

    protected List<PollSingleItem> getPollSingleItemList() {
        return this.m_pollSingleItemList;
    }

    protected List<PollingMultiItems> getPollMultiItemsList() {
        return this.m_pollMultiItemsList;
    }

    protected int pollSingleItemListSize() {
        return this.m_pollSingleItemList.size();
    }

    protected int pollMultiItemsListSize() {
        return this.m_pollMultiItemsList.size();
    }

    protected PollSingleItem getPollSingleItemAt(int index) {
        return this.m_pollSingleItemList.get(index);
    }

    protected PollingMultiItems getPollMultiItemsAt(int index) {
        return this.m_pollMultiItemsList.get(index);
    }

    public PollingGroupState getPollingState() {
        return this.myPollingState;
    }

    public PollingGroupType getPollingType() {
        return this.myType;
    }

    private List<MibItem> getListOfMibItemsToSnmpGet() {
        ArrayList<MibItem> listOfMibItemsToSnmpGet = new ArrayList<MibItem>();
        for (int index = 0; index < this.pollSingleItemListSize(); ++index) {
            PollSingleItem item = this.getPollSingleItemAt(index);
            item.addMibItemsToList(listOfMibItemsToSnmpGet);
        }
        return listOfMibItemsToSnmpGet;
    }

    private void operateUpdateCheck(CommVarBindList vbList) throws SrCommException {
        PollingData itemData;
        PollItem item;
        int index;
        PollingData pollData = new PollingData();
        for (index = 0; index < this.pollSingleItemListSize(); ++index) {
            item = this.getPollSingleItemAt(index);
            itemData = ((PollSingleItem)item).poll(vbList);
            if (!item.isPollingDataChanged()) continue;
            pollData.addPollingData(itemData);
        }
        for (index = 0; index < this.pollMultiItemsListSize(); ++index) {
            item = this.getPollMultiItemsAt(index);
            itemData = ((PollingMultiItems)item).poll(vbList);
            if (!item.isPollingDataChanged()) continue;
            pollData.addPollingData(itemData);
        }
        PollingGroup.sendPollingDataToEventMgr(pollData, this);
    }

    public static void sendPollingDataToEventMgr(PollingData aPollData, Object aDataSource) {
        if (!aPollData.isEmpty()) {
            EventMgr eventMgr = EventMgr.getInstance();
            for (ConfigElementDataList cedList : aPollData.getConfigElements()) {
                if (cedList.isEmpty()) continue;
                eventMgr.sendRefreshElementEvent(cedList, aDataSource);
            }
            List<CheckListConfigElementData> checkLists = aPollData.getCheckLists();
            ArrayList<CheckListConfigElementData> reversedCheckList = new ArrayList<CheckListConfigElementData>(checkLists);
            Collections.reverse(reversedCheckList);
            for (CheckListConfigElementData checkList : reversedCheckList) {
                eventMgr.sendCheckListEvent(checkList, aDataSource);
            }
        }
    }

    public void resetParameters() {
        for (int index = 0; index < this.pollSingleItemListSize(); ++index) {
            PollSingleItem item = this.getPollSingleItemAt(index);
            item.resetParameters();
        }
    }

    public final void poll() throws SrCommException {
        theLogger.trace(SrLogCategories.LEGACY, "Start Poll for group ", this.myName);
        List<MibItem> listOfMibItemsToSnmpGet = this.getListOfMibItemsToSnmpGet();
        CommVarBindList vbList = null;
        vbList = PollingGroup.convertMibItemsListToVarBindList(listOfMibItemsToSnmpGet);
        CommMgr.getInstance(this.getAgentIndex()).getList(vbList, this.getAgentIndex());
        this.operateUpdateCheck(vbList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.myType).append(':').append(CommKeyUtil.getIpFromIndex(this.getAgentIndex()));
        return sb.toString();
    }

    private static CommVarBindList convertMibItemsListToVarBindList(List<MibItem> mibItemsList) {
        CommVarBindList vbList = new CommVarBindList();
        for (MibItem mibItem : mibItemsList) {
            SrOid oid = new SrOid(mibItem.toString(), "0");
            SrSnmpVarBind vb = new SrSnmpVarBind(oid, null);
            vbList.add(vb);
        }
        return vbList;
    }

    protected abstract void initPollSingleItemsList();

    protected abstract void initPollMultiItemsList();
}

