/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PollingData {
    private List<ConfigElementDataList> myCedLists = new ArrayList<ConfigElementDataList>();
    private List<CheckListConfigElementData> myCheckDeletionLists = new ArrayList<CheckListConfigElementData>();

    public PollingData() {
    }

    public PollingData(ConfigElementDataList aCedList, CheckListConfigElementData aCheckList) {
        this.addConfigElementDataList(aCedList);
        this.addCheckList(aCheckList);
    }

    public void addConfigElementDataList(ConfigElementDataList aList) {
        if (aList == null) {
            throw new IllegalArgumentException("The CED list cannot be null");
        }
        this.myCedLists.add(aList);
    }

    public void addCheckList(CheckListConfigElementData aList) {
        if (aList == null) {
            throw new IllegalArgumentException("The CED list cannot be null");
        }
        this.myCheckDeletionLists.add(aList);
    }

    public void addAllCheckLists(List<CheckListConfigElementData> aCheckLists) {
        this.myCheckDeletionLists.addAll(aCheckLists);
    }

    public void addPollingData(PollingData aPollingData) {
        this.myCedLists.addAll(aPollingData.myCedLists);
        this.myCheckDeletionLists.addAll(aPollingData.myCheckDeletionLists);
    }

    public boolean isEmpty() {
        for (ConfigElementDataList cedList : this.myCedLists) {
            if (cedList.isEmpty()) continue;
            return false;
        }
        return this.myCheckDeletionLists.isEmpty();
    }

    public List<ConfigElementDataList> getConfigElements() {
        return Collections.unmodifiableList(this.myCedLists);
    }

    public List<CheckListConfigElementData> getCheckLists() {
        return Collections.unmodifiableList(this.myCheckDeletionLists);
    }
}

