/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.polling.PollItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.List;

public abstract class PollSingleItem
extends PollItem {
    private static SrLogger theLogger = SrLogger.getLogger();
    protected MibItem m_tableLastUpdatedMibItem = null;
    protected SrTimeTicks m_tableLastUpdatedMibValue = null;
    protected ClassID m_classId = null;
    private ClassID[] myAssociatedClassIDs = null;

    protected PollSingleItem(char agentIndex, MibItem tableLastUpdatedMibItem) {
        super(agentIndex);
        this.m_tableLastUpdatedMibItem = tableLastUpdatedMibItem;
        this.m_tableLastUpdatedMibValue = this.m_tableLastUpdatedMibItem == null ? null : new SrTimeTicks(0);
    }

    protected PollSingleItem(char agentIndex, MibItem tableLastUpdatedMibItem, ClassID classId) {
        this(agentIndex, tableLastUpdatedMibItem);
        this.m_classId = classId;
        this.myAssociatedClassIDs = new ClassID[]{this.m_classId};
    }

    protected PollSingleItem(char agentIndex, ClassID classId) {
        super(agentIndex);
        this.m_tableLastUpdatedMibItem = null;
        this.m_tableLastUpdatedMibValue = null;
        this.m_classId = classId;
        this.myAssociatedClassIDs = new ClassID[]{this.m_classId};
    }

    protected MibItem getTableLastUpdateMibItem() {
        return this.m_tableLastUpdatedMibItem;
    }

    public void addMibItemsToList(List<MibItem> list) {
        if (this.m_tableLastUpdatedMibItem != null) {
            list.add(this.m_tableLastUpdatedMibItem);
        }
    }

    @Override
    public PollingData poll(CommVarBindList vbList) throws SrCommException {
        SrTimeTicks readTableLastUpdateValue = null;
        if (this.m_tableLastUpdatedMibItem != null) {
            CommVarBind vb = (CommVarBind)vbList.elementAt(0);
            readTableLastUpdateValue = (SrTimeTicks)vb.getValue();
            if (readTableLastUpdateValue == null) {
                Object item = this.m_classId == null ? this.m_tableLastUpdatedMibItem : this.m_classId;
                theLogger.error(SrLogCategories.LEGACY, "LastUpdate value of ", item, " is not supported (for polling)");
            }
            vbList.remove(0);
        }
        if (this.m_tableLastUpdatedMibValue == null || readTableLastUpdateValue != null && readTableLastUpdateValue.compareLongValueTo(this.m_tableLastUpdatedMibValue) > 0) {
            PollingData pollData = this.refresh();
            if (this.m_tableLastUpdatedMibItem != null) {
                this.m_tableLastUpdatedMibValue = readTableLastUpdateValue;
            }
            return pollData;
        }
        return new PollingData();
    }

    public void resetParameters() {
        this.m_tableLastUpdatedMibValue = new SrTimeTicks(0);
    }

    @Override
    public ClassID[] getClassIDs() {
        return this.myAssociatedClassIDs;
    }
}

