/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.polling.PollSingleItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import java.util.List;

public class NoLastChangedGroupOfScalars
extends PollSingleItem {
    protected MibItem[] m_mibItemsToGetOnUpdate = null;

    public NoLastChangedGroupOfScalars(char agentIndex, MibItem[] mibItemsToGetOnUpdate, ClassID classId) {
        super(agentIndex, classId);
        this.m_mibItemsToGetOnUpdate = mibItemsToGetOnUpdate;
    }

    @Override
    public void addMibItemsToList(List<MibItem> list) {
        for (int index = 0; index < this.m_mibItemsToGetOnUpdate.length; ++index) {
            list.add(this.m_mibItemsToGetOnUpdate[index]);
        }
    }

    @Override
    public PollingData poll(CommVarBindList vbList) throws SrCommException {
        return this.refresh(vbList);
    }

    protected PollingData refresh(CommVarBindList vbList) throws SrCommException {
        PollingData pollData = new PollingData();
        CommVarBindList copyVbList = new CommVarBindList();
        if (this.m_mibItemsToGetOnUpdate != null) {
            for (int index = 0; index < this.m_mibItemsToGetOnUpdate.length; ++index) {
                copyVbList.add(vbList.elementAt(0));
                vbList.remove(0);
            }
            ElementConfigurator elementCfg = this.getElementConfigurator();
            ConfigElementData element = elementCfg.createConfigElementFromVarBindList(copyVbList, this.getAgentIndex());
            pollData.addConfigElementDataList(new ConfigElementDataList(element));
        }
        return pollData;
    }

    @Override
    protected PollingData refresh() throws SrCommException {
        return new PollingData();
    }

    protected ElementConfigurator getElementConfigurator() {
        ElementConfigurator elementCfg = DataMgrAOImpl.getElementConfigFromClassID(this.m_classId);
        return elementCfg;
    }

    public String toString() {
        return CommKeyUtil.getIpFromIndex(this.getAgentIndex()) + ": NoLastChangedGroupOfScalars";
    }
}

