/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.polling.PollSingleItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.types.ConfigElementDataList;

public class LastChangedTableItem
extends PollSingleItem {
    protected String[] m_tableNames = null;
    protected ClassID[] m_ClassIdList = null;

    public LastChangedTableItem(char agentIndex, MibItem tableLastUpdateMibItem, String[] tableNames, ClassID[] classIdList) {
        super(agentIndex, tableLastUpdateMibItem);
        this.initItem(tableNames, classIdList);
    }

    protected void initItem(String[] tableNames, ClassID[] classIdList) {
        this.m_tableNames = tableNames;
        this.m_ClassIdList = classIdList;
    }

    @Override
    protected PollingData refresh() throws SrCommException {
        PollingData pollData = new PollingData();
        if (this.m_ClassIdList != null) {
            for (int index = 0; index < this.m_ClassIdList.length; ++index) {
                ElementConfigurator elementCfg = DataMgrAOImpl.getElementConfigFromClassID(this.m_ClassIdList[index]);
                CheckListConfigElementData checkList = this.createCheckList(this.m_ClassIdList[index]);
                ConfigElementDataList dataList = elementCfg.refreshTable(this.getAgentIndex(), this.m_tableLastUpdatedMibValue, checkList);
                if (dataList == null) continue;
                pollData.addConfigElementDataList(dataList);
                pollData.addCheckList(checkList);
            }
        }
        return pollData;
    }

    protected CheckListConfigElementData createCheckList(ClassID classId) {
        return new CheckListConfigElementData(classId);
    }

    @Override
    public ClassID[] getClassIDs() {
        return this.m_ClassIdList;
    }
}

