/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBind;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.mgr.CheckListConfigElementData;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.polling.LastChangedTableItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.SnmpCommKey;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.SrTimeTicks;
import java.util.ArrayList;
import java.util.List;

public class LastChangedTableEntryItem
extends LastChangedTableItem {
    private MibItem m_tableEntryLastUpdateMibItem = null;

    public LastChangedTableEntryItem(char agentIndex, MibItem tableLastUpdateMibItem, MibItem tableEntryLastUpdateMibItem, String[] tableNames, ClassID[] classIdsList) {
        super(agentIndex, tableLastUpdateMibItem, tableNames, classIdsList);
        this.m_tableEntryLastUpdateMibItem = tableEntryLastUpdateMibItem;
    }

    @Override
    protected PollingData refresh() throws SrCommException {
        return this.refresh(ParameterCode.LAST_UPDATE);
    }

    protected PollingData refresh(ParameterCode lastUpdateParameterCode) throws SrCommException {
        PollingData pollData = new PollingData();
        CommVarBindList lastUpdateVarBindList = this.getLastUpdateVarBindList();
        CommVarBindList[] lastUpdateVarBinds = CommMgr.getInstance(this.getAgentIndex()).snmpGetBulk(lastUpdateVarBindList, this.getAgentIndex());
        if (lastUpdateVarBinds != null) {
            ElementConfigurator elementCfg = DataMgrAOImpl.getElementConfigFromClassID(this.m_ClassIdList[0]);
            ConfigElementDataList elementsList = new ConfigElementDataList();
            ConfigElementDataList retrievedElementsList = new ConfigElementDataList();
            ArrayList<CommKeyClassId> checkListTopTable = new ArrayList<CommKeyClassId>();
            for (int index = 0; index < lastUpdateVarBinds.length; ++index) {
                this.addCommKeyToCheckList(checkListTopTable, lastUpdateVarBinds[index]);
                CommVarBindList rowList = lastUpdateVarBinds[index];
                String currCommKey = ((CommVarBind)rowList.elementAt(0)).getIndexForCommKey();
                SrTimeTicks newLastUpdateOfEntryVal = (SrTimeTicks)rowList.getValue(lastUpdateParameterCode);
                if (this.m_tableLastUpdatedMibValue != null && newLastUpdateOfEntryVal.compareLongValueTo(this.m_tableLastUpdatedMibValue) <= 0) continue;
                ConfigElementData cfgElemData = new ConfigElementData(new SnmpCommKey(currCommKey, this.getAgentIndex()), this.m_ClassIdList[0]);
                elementCfg.refreshElement(cfgElemData, retrievedElementsList);
                if (!this.filterElementForRefresh(cfgElemData)) {
                    if (!retrievedElementsList.contains(cfgElemData)) {
                        elementsList.add(cfgElemData);
                    }
                    elementsList.addAll(retrievedElementsList);
                }
                retrievedElementsList.clear();
            }
            if (elementsList.size() > 0) {
                pollData.addConfigElementDataList(elementsList);
            }
            pollData.addAllCheckLists(this.getAllCheckLists(checkListTopTable, elementsList));
        }
        return pollData;
    }

    protected List<CheckListConfigElementData> getAllCheckLists(List<CommKeyClassId> checkListTopTable, ConfigElementDataList elementsList) {
        if (checkListTopTable != null) {
            return this.getCheckList(checkListTopTable);
        }
        return new ArrayList<CheckListConfigElementData>();
    }

    private void addCommKeyToCheckList(List<CommKeyClassId> checkList, CommVarBindList vbList) {
        String key = ((CommVarBind)vbList.elementAt(0)).getIndexForCommKey();
        SnmpCommKey commKey = new SnmpCommKey(key, this.getAgentIndex());
        checkList.add(new CommKeyClassId(commKey, this.m_ClassIdList[0]));
    }

    protected final List<CheckListConfigElementData> getCheckList(List<CommKeyClassId> checkListTopTable) {
        ArrayList<CheckListConfigElementData> list = new ArrayList<CheckListConfigElementData>();
        if (checkListTopTable != null) {
            list.add(this.createCheckList(this.m_ClassIdList[0], checkListTopTable, null));
        }
        return list;
    }

    protected final CheckListConfigElementData createCheckList(ClassID currClassId, List<CommKeyClassId> currChecklist, List<CommKeyClassId> listOfPrefixes) {
        CheckListConfigElementData checkListElement = new CheckListConfigElementData(currClassId);
        checkListElement.setValue(ParameterCode.LAST_UPDATE, this.m_tableLastUpdatedMibValue);
        checkListElement.setValue(ParameterCode.VSWITCH_ID, CommKeyUtil.getVSwitchData(this.getAgentIndex()));
        checkListElement.setCheckList(currChecklist);
        checkListElement.setSuperTblCheckList(listOfPrefixes);
        return checkListElement;
    }

    private CommVarBindList getLastUpdateVarBindList() {
        CommVarBindList varBindsToGet = new CommVarBindList();
        SrOid oid = new SrOid(this.m_tableEntryLastUpdateMibItem.toString(), "0");
        SrSnmpVarBind varBind = new SrSnmpVarBind(oid, null);
        varBindsToGet.add(varBind);
        return varBindsToGet;
    }

    protected boolean filterElementForRefresh(ConfigElementData element) {
        return false;
    }
}

