/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.mgr.polling;

import com.sanrad.nms.server.comm.CommMgr;
import com.sanrad.nms.server.comm.CommVarBindList;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.MibItem;
import com.sanrad.nms.server.comm.snmp.SrOid;
import com.sanrad.nms.server.comm.snmp.SrSnmpVarBind;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.ElementConfigurator;
import com.sanrad.nms.server.mgr.polling.PollSingleItem;
import com.sanrad.nms.server.mgr.polling.PollingData;
import com.sanrad.nms.server.util.types.ConfigElementDataList;

public class LastChangedGroupOfScalars
extends PollSingleItem {
    protected MibItem[] m_mibItemsToGetOnUpdate = null;

    public LastChangedGroupOfScalars(char agentIndex, MibItem lastUpdatedMibItem, MibItem[] mibItemsToGetOnUpdate) {
        super(agentIndex, lastUpdatedMibItem);
        this.initItem(mibItemsToGetOnUpdate);
    }

    protected void initItem(MibItem[] mibItemsToGetOnUpdate) {
        this.m_mibItemsToGetOnUpdate = mibItemsToGetOnUpdate;
    }

    @Override
    protected PollingData refresh() throws SrCommException {
        PollingData pollData = new PollingData();
        CommVarBindList vbList = null;
        if (this.m_mibItemsToGetOnUpdate != null) {
            vbList = LastChangedGroupOfScalars.convertMibItemsListToVarBindList(this.m_mibItemsToGetOnUpdate);
            CommMgr.getInstance(this.getAgentIndex()).getList(vbList, this.getAgentIndex());
            ElementConfigurator elementCfg = this.getElementConfigurator();
            ConfigElementData element = elementCfg.createConfigElementFromVarBindList(vbList, this.getAgentIndex());
            pollData.addConfigElementDataList(new ConfigElementDataList(element));
        }
        return pollData;
    }

    protected ElementConfigurator getElementConfigurator() {
        return null;
    }

    private static CommVarBindList convertMibItemsListToVarBindList(MibItem[] mibItemsList) {
        CommVarBindList vbList = new CommVarBindList();
        for (int index = 0; index < mibItemsList.length; ++index) {
            SrOid oid = new SrOid(mibItemsList[index].toString(), "0");
            SrSnmpVarBind vb = new SrSnmpVarBind(oid, null);
            vbList.add(vb);
        }
        return vbList;
    }
}

